/*
 * Decompiled with CFR 0.152.
 */
package com.example.bxlargeimageviewer;

import android.content.Context;
import android.support.annotation.DimenRes;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import android.support.v7.app.AlertDialog;
import android.view.View;
import android.view.ViewGroup;
import com.example.bxlargeimageviewer.Adapters.ImageViewAdapter;
import com.example.bxlargeimageviewer.R;
import java.util.List;

public class BxImageViewer {
    private int totalImages = 0;
    private int selectedPosition = 0;
    private ImageViewAdapter imageViewAdapter;
    private View header;
    private View imageViewer;
    private ViewPager viewPager;
    private ViewGroup headerContainer;
    private OnImageChangeListener imageChangeListener;
    private List<String> imageURIs;
    private static BxImageViewer bxImageViewer;
    private static Context context;
    private static AlertDialog alertDialog;
    private int backgroundColor;
    private int imageMarginPixels;
    ViewPager.OnPageChangeListener onPageChangeListener = new ViewPager.OnPageChangeListener(){
        int prevPosition = -1;
        int position;

        public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
            this.position = position;
        }

        public void onPageSelected(int position) {
        }

        public void onPageScrollStateChanged(int state) {
            if (0 == state && this.position != this.prevPosition) {
                BxImageViewer.this.imageChangeListener.onImageChanged(this.position);
                this.prevPosition = this.position;
            }
        }
    };

    public static BxImageViewer getInstance(Context con) {
        context = con;
        if (bxImageViewer == null) {
            bxImageViewer = new BxImageViewer();
        }
        return bxImageViewer;
    }

    private void initView() {
        this.imageViewer = View.inflate((Context)context, (int)R.layout.image_view_layout, null);
        this.viewPager = (ViewPager)this.imageViewer.findViewById(R.id.my_pager);
        this.headerContainer = (ViewGroup)this.imageViewer.findViewById(R.id.header_container);
    }

    public BxImageViewer initialization() {
        this.initView();
        this.initAdapter();
        this.onDismiss();
        this.imageViewer.setBackgroundResource(R.color.bxColorBlack);
        return bxImageViewer;
    }

    private void initAdapter() {
        this.imageViewAdapter = new ImageViewAdapter(context);
    }

    private void setViewPagerListener() {
        this.viewPager.setOnPageChangeListener(this.onPageChangeListener);
    }

    private void setViewPagerAdapter() {
        if (this.viewPager != null && this.imageViewAdapter != null) {
            this.viewPager.setAdapter((PagerAdapter)this.imageViewAdapter);
        }
    }

    private void setupAlertDialog() {
        alertDialog = new AlertDialog.Builder(context, 0x1030011).setView(this.imageViewer).create();
    }

    public BxImageViewer addDataSet(List<String> imageURIs) {
        this.imageURIs = imageURIs;
        if (imageURIs != null) {
            this.totalImages = imageURIs.size();
        }
        if (this.viewPager != null && this.imageViewAdapter != null) {
            this.imageViewAdapter.addDataSet(imageURIs);
        }
        return bxImageViewer;
    }

    public BxImageViewer setStartPosition(int selectedPosition) {
        this.selectedPosition = selectedPosition < 0 ? 0 : selectedPosition;
        return bxImageViewer;
    }

    public BxImageViewer setOverlayView(View header) {
        this.header = header;
        if (this.headerContainer != null) {
            this.headerContainer.removeAllViews();
            this.headerContainer.addView(header);
        }
        return bxImageViewer;
    }

    public BxImageViewer setBackgroundColor(int color2) {
        try {
            this.imageViewer.setBackgroundColor(color2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bxImageViewer;
    }

    public BxImageViewer setBackgroundColorRes(int color2) {
        try {
            this.imageViewer.setBackgroundResource(color2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bxImageViewer;
    }

    public BxImageViewer setImageMarginPx(int marginPixels) {
        try {
            this.imageMarginPixels = marginPixels;
            this.viewPager.setPageMargin(this.imageMarginPixels);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this;
    }

    public BxImageViewer setImageMargin(Context context, @DimenRes int dimen) {
        try {
            this.imageMarginPixels = Math.round(context.getResources().getDimension(dimen));
            this.viewPager.setPageMargin(this.imageMarginPixels);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this;
    }

    public BxImageViewer setProgressBarColorRes(int progressBarColor) {
        this.imageViewAdapter.setProgressBarColor(progressBarColor);
        return bxImageViewer;
    }

    public BxImageViewer setImageChangeListener(OnImageChangeListener imageChangeListener) {
        this.imageChangeListener = imageChangeListener;
        return bxImageViewer;
    }

    public void show() {
        this.setupAlertDialog();
        if (alertDialog != null && !alertDialog.isShowing()) {
            this.setViewPagerAdapter();
            this.setViewPagerListener();
            if (this.selectedPosition >= this.totalImages) {
                this.selectedPosition = this.totalImages - 1;
            }
            if (this.selectedPosition > 0) {
                this.viewPager.setCurrentItem(this.selectedPosition);
            }
            if (this.imageChangeListener != null) {
                this.imageChangeListener.onImageChanged(this.selectedPosition);
            }
            alertDialog.show();
        }
    }

    public void onDismiss() {
        if (alertDialog != null && alertDialog.isShowing()) {
            alertDialog.dismiss();
        }
    }

    public static interface OnImageChangeListener {
        public void onImageChanged(int var1);
    }
}

