/*
 * Decompiled with CFR 0.152.
 */
package com.braintreegateway;

import com.braintreegateway.Transaction;
import com.braintreegateway.UsBankAccount;
import com.braintreegateway.util.EnumUtils;
import com.braintreegateway.util.NodeWrapper;
import java.util.Calendar;

public class UsBankAccountVerification {
    private Calendar createdAt;
    private Calendar verificationDeterminedAt;
    private Transaction.GatewayRejectionReason gatewayRejectionReason;
    private Status status;
    private String additionalProcessorResponse;
    private String id;
    private String processorResponseCode;
    private String processorResponseText;
    private UsBankAccount usBankAccount;
    private VerificationAddOns verificationAddOns;
    private VerificationMethod verificationMethod;

    public UsBankAccountVerification(NodeWrapper node) {
        this.id = node.findString("id");
        this.status = EnumUtils.findByName(Status.class, node.findString("status"), Status.UNRECOGNIZED);
        this.verificationMethod = VerificationMethod.fromString(node.findString("verification-method"));
        this.verificationAddOns = EnumUtils.findByName(VerificationAddOns.class, node.findString("verification-add-ons"), VerificationAddOns.UNRECOGNIZED);
        this.processorResponseCode = node.findString("processor-response-code");
        this.additionalProcessorResponse = node.findString("additional-processor-response");
        this.processorResponseText = node.findString("processor-response-text");
        this.createdAt = node.findDateTime("created-at");
        this.verificationDeterminedAt = node.findDateTime("verification-determined-at");
        this.gatewayRejectionReason = EnumUtils.findByName(Transaction.GatewayRejectionReason.class, node.findString("gateway-rejection-reason"), Transaction.GatewayRejectionReason.UNRECOGNIZED);
        NodeWrapper usBankAccountNode = node.findFirst("us-bank-account");
        if (usBankAccountNode != null) {
            this.usBankAccount = new UsBankAccount(usBankAccountNode);
        }
    }

    public Calendar getCreatedAt() {
        return this.createdAt;
    }

    public String getId() {
        return this.id;
    }

    public Transaction.GatewayRejectionReason getGatewayRejectionReason() {
        return this.gatewayRejectionReason;
    }

    public VerificationMethod getVerificationMethod() {
        return this.verificationMethod;
    }

    public VerificationAddOns getVerificationAddOns() {
        return this.verificationAddOns;
    }

    public Calendar getVerificationDeterminedAt() {
        return this.verificationDeterminedAt;
    }

    public String getProcessorResponseCode() {
        return this.processorResponseCode;
    }

    public String getAdditionalProcessorResponse() {
        return this.additionalProcessorResponse;
    }

    public String getProcessorResponseText() {
        return this.processorResponseText;
    }

    public Status getStatus() {
        return this.status;
    }

    public UsBankAccount getUsBankAccount() {
        return this.usBankAccount;
    }

    public static enum VerificationAddOns {
        CUSTOMER_VERIFICATION("customer_verification"),
        UNRECOGNIZED("unrecognized");

        private final String name;

        private VerificationAddOns(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }

    public static enum VerificationMethod {
        INDEPENDENT_CHECK("independent_check"),
        INSTANT_VERIFICATION_ACCOUNT_VALIDATION("instant_verification_account_validation"),
        MICRO_TRANSFERS("micro_transfers"),
        NETWORK_CHECK("network_check"),
        TOKENIZED_CHECK("tokenized_check"),
        UNRECOGNIZED("unrecognized");

        private final String name;

        private VerificationMethod(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public static VerificationMethod fromString(String value) {
            if (value == null) {
                return UNRECOGNIZED;
            }
            for (VerificationMethod method : VerificationMethod.values()) {
                if (!method.name.equals(value)) continue;
                return method;
            }
            return UNRECOGNIZED;
        }
    }

    public static enum Status {
        FAILED("failed"),
        GATEWAY_REJECTED("gateway_rejected"),
        PENDING("pending"),
        PROCESSOR_DECLINED("processor_declined"),
        UNRECOGNIZED("unrecognized"),
        VERIFIED("verified");

        private final String name;

        private Status(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

