/*
 * Decompiled with CFR 0.152.
 */
package com.braintreegateway;

import com.braintreegateway.Configuration;
import com.braintreegateway.ExchangeRateQuotePayload;
import com.braintreegateway.ExchangeRateQuoteRequest;
import com.braintreegateway.Result;
import com.braintreegateway.ValidationErrors;
import com.braintreegateway.exceptions.UnexpectedException;
import com.braintreegateway.util.GraphQLClient;
import com.braintreegateway.util.Http;
import java.util.Map;

public class ExchangeRateQuoteGateway {
    private Http http;
    private GraphQLClient graphQLClient;
    private Configuration configuration;
    private static final String EXCHANGE_RATE_QUOTE_MUTATION = "mutation ($exchangeRateQuoteRequest: GenerateExchangeRateQuoteInput!) { generateExchangeRateQuote(input: $exchangeRateQuoteRequest) {    quotes {      id      baseAmount {value, currencyCode}      quoteAmount {value, currencyCode}      exchangeRate      tradeRate      expiresAt      refreshesAt    }  }}";

    public ExchangeRateQuoteGateway(Http http, GraphQLClient graphQLClient, Configuration configuration) {
        this.http = http;
        this.graphQLClient = graphQLClient;
        this.configuration = configuration;
    }

    public Result<ExchangeRateQuotePayload> generate(ExchangeRateQuoteRequest request) {
        ExchangeRateQuotePayload exchangeRateQuotePayload;
        Map<String, Object> response = this.graphQLClient.query(EXCHANGE_RATE_QUOTE_MUTATION, request);
        ValidationErrors errors = GraphQLClient.getErrors(response);
        if (errors != null) {
            return new Result<ValidationErrors>(errors);
        }
        try {
            Map data = (Map)response.get("data");
            Map result = (Map)data.get("generateExchangeRateQuote");
            exchangeRateQuotePayload = new ExchangeRateQuotePayload(result);
        }
        catch (Exception e) {
            throw new UnexpectedException("Couldn't parse response: " + e.getMessage());
        }
        return new Result<ExchangeRateQuotePayload>(exchangeRateQuotePayload);
    }
}

