/*
 * Decompiled with CFR 0.152.
 */
package com.braintreegateway;

import com.braintreegateway.Request;
import com.braintreegateway.Result;
import com.braintreegateway.ValidationErrors;
import com.braintreegateway.exceptions.AuthenticationException;
import com.braintreegateway.exceptions.AuthorizationException;
import com.braintreegateway.exceptions.NotFoundException;
import com.braintreegateway.exceptions.ServerException;
import com.braintreegateway.graphql.inputs.CreateCustomerSessionInput;
import com.braintreegateway.graphql.inputs.CustomerRecommendationsInput;
import com.braintreegateway.graphql.inputs.UpdateCustomerSessionInput;
import com.braintreegateway.graphql.types.CustomerRecommendationsPayload;
import com.braintreegateway.util.GraphQLClient;
import java.util.HashMap;
import java.util.Map;

public class CustomerSessionGateway {
    private static final String CREATE_CUSTOMER_SESSION = "mutation CreateCustomerSession($input: CreateCustomerSessionInput!) { createCustomerSession(input: $input) {    sessionId  }}";
    private static final String UPDATE_CUSTOMER_SESSION = "mutation UpdateCustomerSession($input: UpdateCustomerSessionInput!) { updateCustomerSession(input: $input) {    sessionId  }}";
    private static final String GET_CUSTOMER_RECOMMENDATIONS = "mutation GenerateCustomerRecommendations($input: GenerateCustomerRecommendationsInput!) {\ngenerateCustomerRecommendations(input: $input) {\n     sessionId \n    paymentRecommendations{\n        paymentOption\n        recommendedPriority\n    }\n    isInPayPalNetwork\n  }\n}";
    private final GraphQLClient graphQLClient;

    public CustomerSessionGateway(GraphQLClient graphQLClient) {
        this.graphQLClient = graphQLClient;
    }

    public Result<String> createCustomerSession(CreateCustomerSessionInput input) {
        return this.executeMutation(CREATE_CUSTOMER_SESSION, input, "data.createCustomerSession.sessionId");
    }

    public Result<String> updateCustomerSession(UpdateCustomerSessionInput input) {
        return this.executeMutation(UPDATE_CUSTOMER_SESSION, input, "data.updateCustomerSession.sessionId");
    }

    public Result<CustomerRecommendationsPayload> getCustomerRecommendations(CustomerRecommendationsInput customerRecommendationsInput) {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("input", customerRecommendationsInput.toGraphQLVariables());
        try {
            Map<String, Object> response = this.graphQLClient.query(GET_CUSTOMER_RECOMMENDATIONS, variables);
            ValidationErrors errors = GraphQLClient.getErrors(response);
            if (errors != null) {
                return new Result<ValidationErrors>(errors);
            }
            Object dataObj = response.get("data");
            if (!(dataObj instanceof Map)) {
                throw new ServerException("Response data is not a map");
            }
            return new Result<CustomerRecommendationsPayload>(new CustomerRecommendationsPayload((Map)dataObj));
        }
        catch (AuthenticationException | AuthorizationException | NotFoundException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new ServerException(e.getMessage());
        }
    }

    private Result<String> executeMutation(String query, Request input, String sessionIdKey) {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("input", input.toGraphQLVariables());
        try {
            Map<String, Object> response = this.graphQLClient.query(query, variables);
            ValidationErrors errors = GraphQLClient.getErrors(response);
            if (errors != null) {
                return new Result<ValidationErrors>(errors);
            }
            String sessionId = (String)CustomerSessionGateway.getValue(response, sessionIdKey);
            return new Result<String>(sessionId);
        }
        catch (Throwable e) {
            throw new ServerException(e.getMessage());
        }
    }

    private static <T> T getValue(Map<String, Object> response, String key) {
        Map map = response;
        String[] keyParts = key.split("\\.");
        for (int k = 0; k < keyParts.length - 1; ++k) {
            String subKey = keyParts[k];
            map = (Map)CustomerSessionGateway.popValue(map, subKey);
        }
        String lastKey = keyParts[keyParts.length - 1];
        return CustomerSessionGateway.popValue(map, lastKey);
    }

    private static <T> T popValue(Map<String, Object> response, String key) {
        if (!response.containsKey(key)) {
            throw new ServerException("Couldn't parse response");
        }
        return (T)response.get(key);
    }
}

