/*
 * Decompiled with CFR 0.152.
 */
package com.braintreegateway.graphql.inputs;

import com.braintreegateway.Request;
import com.braintreegateway.graphql.inputs.CustomerSessionInput;
import com.braintreegateway.graphql.inputs.PayPalPurchaseUnitInput;
import com.braintreegateway.util.Experimental;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Experimental(value="This class is experimental and may change in future releases.")
public class CustomerRecommendationsInput
extends Request {
    private final String merchantAccountId;
    private final String sessionId;
    private final String domain;
    private final List<PayPalPurchaseUnitInput> purchaseUnits;
    private final CustomerSessionInput customer;

    @Override
    public Map<String, Object> toGraphQLVariables() {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        if (this.merchantAccountId != null) {
            variables.put("merchantAccountId", this.merchantAccountId);
        }
        if (this.sessionId != null) {
            variables.put("sessionId", this.sessionId);
        }
        if (this.purchaseUnits != null && !this.purchaseUnits.isEmpty()) {
            ArrayList<Map<String, Object>> formattedPurchaseUnits = new ArrayList<Map<String, Object>>();
            for (PayPalPurchaseUnitInput purchaseUnit : this.purchaseUnits) {
                formattedPurchaseUnits.add(purchaseUnit.toGraphQLVariables());
            }
            variables.put("purchaseUnits", formattedPurchaseUnits);
        }
        if (this.customer != null) {
            variables.put("customer", this.customer.toGraphQLVariables());
        }
        if (this.domain != null) {
            variables.put("domain", this.domain);
        }
        return variables;
    }

    private CustomerRecommendationsInput(Builder builder) {
        this.merchantAccountId = builder.merchantAccountId;
        this.sessionId = builder.sessionId;
        this.domain = builder.domain;
        this.purchaseUnits = builder.purchaseUnits;
        this.customer = builder.customer;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String merchantAccountId;
        private String sessionId;
        private String domain;
        private List<PayPalPurchaseUnitInput> purchaseUnits;
        private CustomerSessionInput customer;

        public Builder merchantAccountId(String merchantAccountId) {
            this.merchantAccountId = merchantAccountId;
            return this;
        }

        public Builder sessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        public Builder customer(CustomerSessionInput customer) {
            this.customer = customer;
            return this;
        }

        public Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public Builder purchaseUnits(List<PayPalPurchaseUnitInput> purchaseUnits) {
            this.purchaseUnits = purchaseUnits;
            return this;
        }

        public CustomerRecommendationsInput build() {
            return new CustomerRecommendationsInput(this);
        }
    }
}

