/*
 * Decompiled with CFR 0.152.
 */
package com.braintreegateway.graphql.inputs;

import com.braintreegateway.Request;
import com.braintreegateway.graphql.inputs.CustomerSessionInput;
import com.braintreegateway.graphql.inputs.PayPalPurchaseUnitInput;
import com.braintreegateway.util.Experimental;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Experimental(value="This class is experimental and may change in future releases.")
public class CreateCustomerSessionInput
extends Request {
    private final String merchantAccountId;
    private final String sessionId;
    private final String domain;
    private final CustomerSessionInput customer;
    private final List<PayPalPurchaseUnitInput> purchaseUnits;

    @Override
    public Map<String, Object> toGraphQLVariables() {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("merchantAccountId", this.merchantAccountId);
        variables.put("sessionId", this.sessionId);
        if (this.purchaseUnits != null && !this.purchaseUnits.isEmpty()) {
            ArrayList<Map<String, Object>> formattedPurchaseUnits = new ArrayList<Map<String, Object>>();
            for (PayPalPurchaseUnitInput purchaseUnit : this.purchaseUnits) {
                formattedPurchaseUnits.add(purchaseUnit.toGraphQLVariables());
            }
            variables.put("purchaseUnits", formattedPurchaseUnits);
        }
        if (this.customer != null) {
            variables.put("customer", this.customer.toGraphQLVariables());
        }
        variables.put("domain", this.domain);
        return variables;
    }

    private CreateCustomerSessionInput(Builder builder) {
        this.merchantAccountId = builder.merchantAccountId;
        this.sessionId = builder.sessionId;
        this.customer = builder.customer;
        this.domain = builder.domain;
        this.purchaseUnits = builder.purchaseUnits;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String merchantAccountId;
        private String sessionId;
        private CustomerSessionInput customer;
        private String domain;
        private List<PayPalPurchaseUnitInput> purchaseUnits;

        public Builder merchantAccountId(String merchantAccountId) {
            this.merchantAccountId = merchantAccountId;
            return this;
        }

        public Builder sessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        public Builder customer(CustomerSessionInput customer) {
            this.customer = customer;
            return this;
        }

        public Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public Builder purchaseUnits(List<PayPalPurchaseUnitInput> purchaseUnits) {
            this.purchaseUnits = purchaseUnits;
            return this;
        }

        public CreateCustomerSessionInput build() {
            return new CreateCustomerSessionInput(this);
        }
    }
}

