/*
 * Decompiled with CFR 0.152.
 */
package com.braintreegateway.graphql.inputs;

import com.braintreegateway.Request;
import com.braintreegateway.graphql.inputs.CustomerSessionInput;
import java.util.HashMap;
import java.util.Map;

public class UpdateCustomerSessionInput
extends Request {
    private final String merchantAccountId;
    private final String sessionId;
    private final CustomerSessionInput customer;

    private UpdateCustomerSessionInput(Builder builder) {
        this.merchantAccountId = builder.merchantAccountId;
        this.sessionId = builder.sessionId;
        this.customer = builder.customer;
    }

    @Override
    public Map<String, Object> toGraphQLVariables() {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("merchantAccountId", this.merchantAccountId);
        variables.put("sessionId", this.sessionId);
        if (this.customer != null) {
            variables.put("customer", this.customer.toGraphQLVariables());
        }
        return variables;
    }

    public static Builder builder(String sessionId) {
        return new Builder(sessionId);
    }

    public static class Builder {
        private String merchantAccountId;
        private String sessionId;
        private CustomerSessionInput customer;

        public Builder(String sessionId) {
            this.sessionId = sessionId;
        }

        public Builder merchantAccountId(String merchantAccountId) {
            this.merchantAccountId = merchantAccountId;
            return this;
        }

        public Builder customer(CustomerSessionInput customer) {
            this.customer = customer;
            return this;
        }

        public UpdateCustomerSessionInput build() {
            return new UpdateCustomerSessionInput(this);
        }
    }
}

