/*
 * Decompiled with CFR 0.152.
 */
package com.braintreegateway;

import com.braintreegateway.CustomerRequest;
import com.braintreegateway.ExternalVaultRequest;
import com.braintreegateway.InstallmentRequest;
import com.braintreegateway.Request;
import com.braintreegateway.RequestBuilder;
import com.braintreegateway.RiskDataTransactionRequest;
import com.braintreegateway.Transaction;
import com.braintreegateway.TransactionAddressRequest;
import com.braintreegateway.TransactionAndroidPayCardRequest;
import com.braintreegateway.TransactionApplePayCardRequest;
import com.braintreegateway.TransactionCreditCardRequest;
import com.braintreegateway.TransactionDescriptorRequest;
import com.braintreegateway.TransactionIndustryRequest;
import com.braintreegateway.TransactionLineItemRequest;
import com.braintreegateway.TransactionOptionsRequest;
import com.braintreegateway.TransactionPayPalRequest;
import com.braintreegateway.TransactionThreeDSecurePassThruRequest;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TransactionRequest
extends Request {
    private BigDecimal amount;
    private TransactionAndroidPayCardRequest androidPayCardRequest;
    private TransactionApplePayCardRequest applePayCardRequest;
    private String billingAddressId;
    private TransactionAddressRequest billingAddressRequest;
    private String channel;
    private TransactionCreditCardRequest creditCardRequest;
    private String currencyIsoCode;
    private String customerId;
    private CustomerRequest customerRequest;
    private Map<String, String> customFields = new HashMap<String, String>();
    private TransactionDescriptorRequest descriptorRequest;
    private String deviceData;
    private String deviceSessionId;
    private BigDecimal discountAmount;
    private String exchangeRateQuoteId;
    private ExternalVaultRequest externalVaultRequest;
    private Boolean finalCapture;
    private Boolean foreignRetailer;
    private String fraudMerchantId;
    private TransactionIndustryRequest industryRequest;
    private InstallmentRequest installments;
    private String merchantAccountId;
    private String orderId;
    private String paymentMethodNonce;
    private String paymentMethodToken;
    private TransactionPayPalRequest paypalRequest;
    private String productSku;
    private String purchaseOrderNumber;
    private Boolean recurring;
    private RiskDataTransactionRequest riskDataTransactionRequest;
    private Transaction.ScaExemption scaExemption;
    private BigDecimal serviceFeeAmount;
    private String sharedBillingAddressId;
    private String sharedCustomerId;
    private String sharedPaymentMethodNonce;
    private String sharedPaymentMethodToken;
    private String sharedShippingAddressId;
    private String shippingAddressId;
    private TransactionAddressRequest shippingAddressRequest;
    private BigDecimal shippingAmount;
    private BigDecimal shippingTaxAmount;
    private String shipsFromPostalCode;
    private String source;
    private BigDecimal taxAmount;
    private Boolean taxExempt;
    private String threeDSecureAuthenticationId;
    private TransactionThreeDSecurePassThruRequest threeDSecurePassThruRequest;
    private String threeDSecureToken;
    private Boolean threeDSecureTransaction = false;
    private List<TransactionLineItemRequest> transactionLineItemRequests = new ArrayList<TransactionLineItemRequest>();
    private TransactionOptionsRequest transactionOptionsRequest;
    private Transaction.Type type;
    private String venmoSdkPaymentMethodCode;

    public TransactionRequest amount(BigDecimal amount) {
        this.amount = amount;
        return this;
    }

    public TransactionAndroidPayCardRequest androidPayCardRequest() {
        this.androidPayCardRequest = new TransactionAndroidPayCardRequest(this);
        return this.androidPayCardRequest;
    }

    public TransactionApplePayCardRequest applePayCardRequest() {
        TransactionApplePayCardRequest applePayCardRequest;
        this.applePayCardRequest = applePayCardRequest = new TransactionApplePayCardRequest(this);
        return applePayCardRequest;
    }

    public TransactionAddressRequest billingAddress() {
        this.billingAddressRequest = new TransactionAddressRequest(this, "billing");
        return this.billingAddressRequest;
    }

    public TransactionRequest billingAddressId(String billingAddressId) {
        this.billingAddressId = billingAddressId;
        return this;
    }

    public TransactionRequest channel(String channel) {
        this.channel = channel;
        return this;
    }

    public TransactionCreditCardRequest creditCard() {
        this.creditCardRequest = new TransactionCreditCardRequest(this);
        return this.creditCardRequest;
    }

    public TransactionRequest currencyIsoCode(String currencyIsoCode) {
        this.currencyIsoCode = currencyIsoCode;
        return this;
    }

    public CustomerRequest customer() {
        this.customerRequest = new CustomerRequest(this);
        return this.customerRequest;
    }

    public TransactionRequest customerId(String customerId) {
        this.customerId = customerId;
        return this;
    }

    public TransactionRequest customField(String apiName, String value) {
        this.customFields.put(apiName, value);
        return this;
    }

    public TransactionDescriptorRequest descriptor() {
        this.descriptorRequest = new TransactionDescriptorRequest(this);
        return this.descriptorRequest;
    }

    public TransactionRequest deviceData(String deviceData) {
        this.deviceData = deviceData;
        return this;
    }

    @Deprecated
    public TransactionRequest deviceSessionId(String deviceSessionId) {
        this.deviceSessionId = deviceSessionId;
        return this;
    }

    public TransactionRequest discountAmount(BigDecimal discountAmount) {
        this.discountAmount = discountAmount;
        return this;
    }

    public TransactionRequest exchangeRateQuoteId(String exchangeRateQuoteId) {
        this.exchangeRateQuoteId = exchangeRateQuoteId;
        return this;
    }

    public ExternalVaultRequest externalVault() {
        ExternalVaultRequest externalVaultRequest;
        this.externalVaultRequest = externalVaultRequest = new ExternalVaultRequest(this);
        return externalVaultRequest;
    }

    public TransactionRequest finalCapture(Boolean finalCapture) {
        this.finalCapture = finalCapture;
        return this;
    }

    public TransactionRequest foreignRetailer(Boolean foreignRetailer) {
        this.foreignRetailer = foreignRetailer;
        return this;
    }

    @Deprecated
    public TransactionRequest fraudMerchantId(String fraudMerchantId) {
        this.fraudMerchantId = fraudMerchantId;
        return this;
    }

    public TransactionIndustryRequest industry() {
        this.industryRequest = new TransactionIndustryRequest(this);
        return this.industryRequest;
    }

    public InstallmentRequest installments() {
        this.installments = new InstallmentRequest(this);
        return this.installments;
    }

    public TransactionLineItemRequest lineItem() {
        TransactionLineItemRequest transactionLineItemRequest = new TransactionLineItemRequest(this);
        this.transactionLineItemRequests.add(transactionLineItemRequest);
        return transactionLineItemRequest;
    }

    public TransactionRequest merchantAccountId(String merchantAccountId) {
        this.merchantAccountId = merchantAccountId;
        return this;
    }

    public TransactionOptionsRequest options() {
        this.transactionOptionsRequest = new TransactionOptionsRequest(this);
        return this.transactionOptionsRequest;
    }

    public TransactionRequest orderId(String orderId) {
        this.orderId = orderId;
        return this;
    }

    public TransactionRequest paymentMethodNonce(String paymentMethodNonce) {
        this.paymentMethodNonce = paymentMethodNonce;
        return this;
    }

    public TransactionRequest paymentMethodToken(String paymentMethodToken) {
        this.paymentMethodToken = paymentMethodToken;
        return this;
    }

    public TransactionPayPalRequest paypalAccount() {
        this.paypalRequest = new TransactionPayPalRequest(this);
        return this.paypalRequest;
    }

    public TransactionRequest productSku(String productSku) {
        this.productSku = productSku;
        return this;
    }

    public TransactionRequest purchaseOrderNumber(String purchaseOrderNumber) {
        this.purchaseOrderNumber = purchaseOrderNumber;
        return this;
    }

    @Deprecated
    public TransactionRequest recurring(Boolean recurring) {
        this.recurring = recurring;
        return this;
    }

    public RiskDataTransactionRequest riskData() {
        this.riskDataTransactionRequest = new RiskDataTransactionRequest(this);
        return this.riskDataTransactionRequest;
    }

    public TransactionRequest scaExemption(Transaction.ScaExemption scaExemption) {
        this.scaExemption = scaExemption;
        return this;
    }

    public TransactionRequest serviceFeeAmount(BigDecimal fee) {
        this.serviceFeeAmount = fee;
        return this;
    }

    public TransactionRequest sharedBillingAddressId(String sharedBillingAddressId) {
        this.sharedBillingAddressId = sharedBillingAddressId;
        return this;
    }

    public TransactionRequest sharedCustomerId(String sharedCustomerId) {
        this.sharedCustomerId = sharedCustomerId;
        return this;
    }

    public TransactionRequest sharedPaymentMethodNonce(String sharedPaymentMethodNonce) {
        this.sharedPaymentMethodNonce = sharedPaymentMethodNonce;
        return this;
    }

    public TransactionRequest sharedPaymentMethodToken(String sharedPaymentMethodToken) {
        this.sharedPaymentMethodToken = sharedPaymentMethodToken;
        return this;
    }

    public TransactionRequest sharedShippingAddressId(String sharedShippingAddressId) {
        this.sharedShippingAddressId = sharedShippingAddressId;
        return this;
    }

    public TransactionAddressRequest shippingAddress() {
        this.shippingAddressRequest = new TransactionAddressRequest(this, "shipping");
        return this.shippingAddressRequest;
    }

    public TransactionRequest shippingAddressId(String shippingAddressId) {
        this.shippingAddressId = shippingAddressId;
        return this;
    }

    public TransactionRequest shippingAmount(BigDecimal shippingAmount) {
        this.shippingAmount = shippingAmount;
        return this;
    }

    public TransactionRequest shipsFromPostalCode(String shipsFromPostalCode) {
        this.shipsFromPostalCode = shipsFromPostalCode;
        return this;
    }

    public TransactionRequest taxAmount(BigDecimal taxAmount) {
        this.taxAmount = taxAmount;
        return this;
    }

    public TransactionRequest shippingTaxAmount(BigDecimal shippingTaxAmount) {
        this.shippingTaxAmount = shippingTaxAmount;
        return this;
    }

    public TransactionRequest taxExempt(Boolean taxExempt) {
        this.taxExempt = taxExempt;
        return this;
    }

    public TransactionRequest threeDSecureAuthenticationId(String threeDSecureAuthenticationId) {
        this.threeDSecureTransaction = true;
        this.threeDSecureAuthenticationId = threeDSecureAuthenticationId;
        return this;
    }

    public TransactionThreeDSecurePassThruRequest threeDSecurePassThru() {
        this.threeDSecurePassThruRequest = new TransactionThreeDSecurePassThruRequest(this);
        return this.threeDSecurePassThruRequest;
    }

    @Deprecated
    public TransactionRequest threeDSecureToken(String threeDSecureToken) {
        this.threeDSecureTransaction = true;
        this.threeDSecureToken = threeDSecureToken;
        return this;
    }

    public TransactionRequest transactionSource(String source) {
        this.source = source;
        return this;
    }

    public TransactionRequest type(Transaction.Type type) {
        this.type = type;
        return this;
    }

    @Deprecated
    public TransactionRequest venmoSdkPaymentMethodCode(String venmoSdkPaymentMethodCode) {
        this.venmoSdkPaymentMethodCode = venmoSdkPaymentMethodCode;
        return this;
    }

    @Override
    public String toQueryString() {
        return this.toQueryString("transaction");
    }

    @Override
    public String toQueryString(String root) {
        return this.buildRequest(root).toQueryString();
    }

    @Override
    public String toXML() {
        return this.buildRequest("transaction").toXML();
    }

    protected RequestBuilder buildRequest(String root) {
        RequestBuilder builder = new RequestBuilder(root).addElement("amount", this.amount).addElement("androidPayCard", this.androidPayCardRequest).addElement("applePayCard", this.applePayCardRequest).addElement("billing", this.billingAddressRequest).addElement("billingAddressId", this.billingAddressId).addElement("channel", this.channel).addElement("creditCard", this.creditCardRequest).addElement("currencyIsoCode", this.currencyIsoCode).addElement("customer", this.customerRequest).addElement("customerId", this.customerId).addElement("descriptor", this.descriptorRequest).addElement("deviceData", this.deviceData).addElement("deviceSessionId", this.deviceSessionId).addElement("discountAmount", this.discountAmount).addElement("exchangeRateQuoteId", this.exchangeRateQuoteId).addElement("externalVault", this.externalVaultRequest).addElement("finalCapture", this.finalCapture).addElement("foreignRetailer", this.foreignRetailer).addElement("fraudMerchantId", this.fraudMerchantId).addElement("industry", this.industryRequest).addElement("installments", this.installments).addElement("merchantAccountId", this.merchantAccountId).addElement("options", this.transactionOptionsRequest).addElement("orderId", this.orderId).addElement("paymentMethodNonce", this.paymentMethodNonce).addElement("paymentMethodToken", this.paymentMethodToken).addElement("paypalAccount", this.paypalRequest).addElement("productSku", this.productSku).addElement("purchaseOrderNumber", this.purchaseOrderNumber).addElement("recurring", this.recurring).addElement("riskData", this.riskDataTransactionRequest).addElement("serviceFeeAmount", this.serviceFeeAmount).addElement("sharedBillingAddressId", this.sharedBillingAddressId).addElement("sharedCustomerId", this.sharedCustomerId).addElement("sharedPaymentMethodNonce", this.sharedPaymentMethodNonce).addElement("sharedPaymentMethodToken", this.sharedPaymentMethodToken).addElement("sharedShippingAddressId", this.sharedShippingAddressId).addElement("shipping", this.shippingAddressRequest).addElement("shippingAddressId", this.shippingAddressId).addElement("shippingAmount", this.shippingAmount).addElement("shippingTaxAmount", this.shippingTaxAmount).addElement("shipsFromPostalCode", this.shipsFromPostalCode).addElement("transactionSource", this.source).addElement("taxAmount", this.taxAmount).addElement("taxExempt", this.taxExempt).addElement("threeDSecurePassThru", this.threeDSecurePassThruRequest).addElement("venmoSdkPaymentMethodCode", this.venmoSdkPaymentMethodCode);
        if (!this.customFields.isEmpty()) {
            builder.addElement("customFields", this.customFields);
        }
        if (!this.transactionLineItemRequests.isEmpty()) {
            builder.addElement("lineItems", this.transactionLineItemRequests);
        }
        if (this.scaExemption != null) {
            builder.addElement("scaExemption", this.scaExemption.toString());
        }
        if (this.threeDSecureTransaction.booleanValue()) {
            if (this.threeDSecureAuthenticationId != null) {
                builder.addElement("threeDSecureAuthenticationId", this.threeDSecureAuthenticationId);
            } else {
                String token = this.threeDSecureToken != null ? this.threeDSecureToken : "";
                builder.addElement("threeDSecureToken", token);
            }
        }
        if (this.type != null) {
            builder.addElement("type", this.type.toString().toLowerCase());
        }
        return builder;
    }
}

