/*
 * Decompiled with CFR 0.152.
 */
package com.braintreegateway;

import com.braintreegateway.Configuration;
import com.braintreegateway.Request;
import com.braintreegateway.ThreeDSecureLookupAdditionalInformation;
import com.braintreegateway.ThreeDSecureLookupAddress;
import com.braintreegateway.ThreeDSecureLookupPriorAuthenticationDetails;
import com.braintreegateway.exceptions.UnexpectedException;
import com.fasterxml.jackson.jr.ob.JSON;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class ThreeDSecureLookupRequest
extends Request {
    private ThreeDSecureLookupAdditionalInformation additionalInformation;
    private String amount;
    private String authorizationFingerprint;
    private ThreeDSecureLookupAddress billingAddress;
    private String braintreeLibraryVersion;
    private Boolean cardAddChallengeRequested;
    private Boolean challengeRequested;
    private Map clientMetadata;
    private Boolean dataOnlyRequested;
    private String dfReferenceId;
    private String email;
    private Boolean exemptionRequested;
    private String merchantAccountId;
    private String merchantInitiatedRequestType;
    private String merchantOnRecordName;
    private String nonce;
    private ThreeDSecureLookupPriorAuthenticationDetails priorAuthenticationDetails;
    private String priorAuthenticationId;
    private String requestedExemptionType;
    private String browserAcceptHeader;
    private String browserColorDepth;
    private Boolean browserJavaEnabled;
    private Boolean browserJavascriptEnabled;
    private String browserLanguage;
    private String browserScreenHeight;
    private String browserScreenWidth;
    private String browserTimeZone;
    private String deviceChannel;
    private String ipAddress;
    private String userAgent;

    public ThreeDSecureLookupRequest additionalInformation(ThreeDSecureLookupAdditionalInformation additionalInformation) {
        this.additionalInformation = additionalInformation;
        return this;
    }

    public ThreeDSecureLookupRequest amount(String amount) {
        this.amount = amount;
        return this;
    }

    public ThreeDSecureLookupRequest billingAddress(ThreeDSecureLookupAddress billingAddress) {
        this.billingAddress = billingAddress;
        return this;
    }

    public ThreeDSecureLookupRequest cardAddChallengeRequested(Boolean cardAddChallengeRequested) {
        this.cardAddChallengeRequested = cardAddChallengeRequested;
        return this;
    }

    public ThreeDSecureLookupRequest challengeRequested(Boolean challengeRequested) {
        this.challengeRequested = challengeRequested;
        return this;
    }

    public ThreeDSecureLookupRequest clientData(String clientData) {
        Map jsonMap;
        try {
            jsonMap = JSON.std.mapFrom((Object)clientData);
        }
        catch (IOException e) {
            throw new UnexpectedException(e.getMessage(), e);
        }
        this.nonce = (String)jsonMap.get("nonce");
        this.authorizationFingerprint = (String)jsonMap.get("authorizationFingerprint");
        this.braintreeLibraryVersion = (String)jsonMap.get("braintreeLibraryVersion");
        this.dfReferenceId = (String)jsonMap.get("dfReferenceId");
        this.clientMetadata = (Map)jsonMap.get("clientMetadata");
        return this;
    }

    public ThreeDSecureLookupRequest dataOnlyRequested(Boolean dataOnlyRequested) {
        this.dataOnlyRequested = dataOnlyRequested;
        return this;
    }

    public ThreeDSecureLookupRequest exemptionRequested(Boolean exemptionRequested) {
        this.exemptionRequested = exemptionRequested;
        return this;
    }

    public ThreeDSecureLookupRequest email(String email) {
        this.email = email;
        return this;
    }

    public ThreeDSecureLookupRequest merchantAccountId(String merchantAccountId) {
        this.merchantAccountId = merchantAccountId;
        return this;
    }

    public ThreeDSecureLookupRequest merchantInitiatedRequestType(String merchantInitiatedRequestType) {
        this.merchantInitiatedRequestType = merchantInitiatedRequestType;
        return this;
    }

    public ThreeDSecureLookupRequest merchantOnRecordName(String merchantOnRecordName) {
        this.merchantOnRecordName = merchantOnRecordName;
        return this;
    }

    public ThreeDSecureLookupRequest priorAuthenticationDetails(ThreeDSecureLookupPriorAuthenticationDetails priorAuthenticationDetails) {
        this.priorAuthenticationDetails = priorAuthenticationDetails;
        return this;
    }

    public ThreeDSecureLookupRequest priorAuthenticationId(String priorAuthenticationId) {
        this.priorAuthenticationId = priorAuthenticationId;
        return this;
    }

    public ThreeDSecureLookupRequest requestedExemptionType(String requestedExemptionType) {
        this.requestedExemptionType = requestedExemptionType;
        return this;
    }

    public ThreeDSecureLookupRequest browserJavaEnabled(Boolean enabled) {
        this.browserJavaEnabled = enabled;
        return this;
    }

    public ThreeDSecureLookupRequest browserAcceptHeader(String header) {
        this.browserAcceptHeader = header;
        return this;
    }

    public ThreeDSecureLookupRequest browserLanguage(String language) {
        this.browserLanguage = language;
        return this;
    }

    public ThreeDSecureLookupRequest browserColorDepth(String depth) {
        this.browserColorDepth = depth;
        return this;
    }

    public ThreeDSecureLookupRequest browserJavascriptEnabled(Boolean enabled) {
        this.browserJavascriptEnabled = enabled;
        return this;
    }

    public ThreeDSecureLookupRequest browserScreenHeight(String height) {
        this.browserScreenHeight = height;
        return this;
    }

    public ThreeDSecureLookupRequest browserScreenWidth(String width) {
        this.browserScreenWidth = width;
        return this;
    }

    public ThreeDSecureLookupRequest browserTimeZone(String zone) {
        this.browserTimeZone = zone;
        return this;
    }

    public ThreeDSecureLookupRequest deviceChannel(String channel) {
        this.deviceChannel = channel;
        return this;
    }

    public ThreeDSecureLookupRequest ipAddress(String address) {
        this.ipAddress = address;
        return this;
    }

    public ThreeDSecureLookupRequest userAgent(String agent) {
        this.userAgent = agent;
        return this;
    }

    public String getAmount() {
        return this.amount;
    }

    private String getAuthorizationFingerprint() {
        return this.authorizationFingerprint;
    }

    private String getBraintreeLibraryVersion() {
        return this.braintreeLibraryVersion;
    }

    private Boolean getCardAddChallengeRequested() {
        return this.cardAddChallengeRequested;
    }

    private Boolean getChallengeRequested() {
        return this.challengeRequested;
    }

    private Map getClientMetadata() {
        return this.clientMetadata;
    }

    private Boolean getDataOnlyRequested() {
        return this.dataOnlyRequested;
    }

    private String getDfReferenceId() {
        return this.dfReferenceId;
    }

    private String getEmail() {
        return this.email;
    }

    private Boolean getExemptionRequested() {
        return this.exemptionRequested;
    }

    private String getMerchantAccountId() {
        return this.merchantAccountId;
    }

    private String getMerchantInitiatedRequestType() {
        return this.merchantInitiatedRequestType;
    }

    private String getMerchantOnRecordName() {
        return this.merchantOnRecordName;
    }

    public String getNonce() {
        return this.nonce;
    }

    private String getPriorAuthenticationId() {
        return this.priorAuthenticationId;
    }

    private String getRequestedExemptionType() {
        return this.requestedExemptionType;
    }

    private String getBrowserAcceptHeader() {
        return this.browserAcceptHeader;
    }

    private String getBrowserColorDepth() {
        return this.browserColorDepth;
    }

    private Boolean getBrowserJavaEnabled() {
        return this.browserJavaEnabled;
    }

    private Boolean getBrowserJavascriptEnabled() {
        return this.browserJavascriptEnabled;
    }

    private String getBrowserLanguage() {
        return this.browserLanguage;
    }

    private String getBrowserScreenHeight() {
        return this.browserScreenHeight;
    }

    private String getBrowserScreenWidth() {
        return this.browserScreenWidth;
    }

    private String getBrowserTimeZone() {
        return this.browserTimeZone;
    }

    private String getDeviceChannel() {
        return this.deviceChannel;
    }

    private String getIpAddress() {
        return this.ipAddress;
    }

    private String getUserAgent() {
        return this.userAgent;
    }

    public String toJSON() {
        HashMap<String, Object> jsonMap = new HashMap<String, Object>();
        HashMap<String, String> metaMap = new HashMap<String, String>();
        Map<String, Object> additionalInfo = this.additionalInformation != null ? this.additionalInformation.toMap() : new HashMap<String, Object>();
        Map<String, Object> priorAuthenticationDetails = this.priorAuthenticationDetails != null ? this.priorAuthenticationDetails.toMap() : new HashMap<String, Object>();
        try {
            metaMap.put("platform", "java");
            metaMap.put("sdkVersion", Configuration.VERSION);
            metaMap.put("source", "http");
            if (this.billingAddress != null) {
                additionalInfo.put("billingCity", this.billingAddress.getLocality());
                additionalInfo.put("billingCountryCode", this.billingAddress.getCountryCodeAlpha2());
                additionalInfo.put("billingGivenName", this.billingAddress.getGivenName());
                additionalInfo.put("billingLine1", this.billingAddress.getStreetAddress());
                additionalInfo.put("billingLine2", this.billingAddress.getExtendedAddress());
                additionalInfo.put("billingPhoneNumber", this.billingAddress.getPhoneNumber());
                additionalInfo.put("billingPostalCode", this.billingAddress.getPostalCode());
                additionalInfo.put("billingState", this.billingAddress.getRegion());
                additionalInfo.put("billingSurname", this.billingAddress.getSurname());
            }
            jsonMap.put("_meta", metaMap);
            jsonMap.put("additional_info", additionalInfo);
            jsonMap.put("authorizationFingerprint", this.getAuthorizationFingerprint());
            jsonMap.put("amount", this.getAmount());
            jsonMap.put("braintreeLibraryVersion", this.getBraintreeLibraryVersion());
            jsonMap.put("cardAddChallengeRequested", this.getCardAddChallengeRequested());
            jsonMap.put("challengeRequested", this.getChallengeRequested());
            jsonMap.put("clientMetadata", this.getClientMetadata());
            jsonMap.put("dataOnlyRequested", this.getDataOnlyRequested());
            jsonMap.put("df_reference_id", this.getDfReferenceId());
            jsonMap.put("email", this.getEmail());
            jsonMap.put("exemptionRequested", this.getExemptionRequested());
            jsonMap.put("merchantAccountId", this.getMerchantAccountId());
            jsonMap.put("merchantInitiatedRequestType", this.getMerchantInitiatedRequestType());
            jsonMap.put("merchantOnRecordName", this.getMerchantOnRecordName());
            jsonMap.put("prior_authentication_details", priorAuthenticationDetails);
            jsonMap.put("priorAuthenticationId", this.getPriorAuthenticationId());
            jsonMap.put("requestedExemptionType", this.getRequestedExemptionType());
            jsonMap.put("browserColorDepth", this.getBrowserColorDepth());
            jsonMap.put("browserHeader", this.getBrowserAcceptHeader());
            jsonMap.put("browserJavaEnabled", this.getBrowserJavaEnabled());
            jsonMap.put("browserJavascriptEnabled", this.getBrowserJavascriptEnabled());
            jsonMap.put("browserLanguage", this.getBrowserLanguage());
            jsonMap.put("browserScreenHeight", this.getBrowserScreenHeight());
            jsonMap.put("browserScreenWidth", this.getBrowserScreenWidth());
            jsonMap.put("browserTimeZone", this.getBrowserTimeZone());
            jsonMap.put("deviceChannel", this.getDeviceChannel());
            jsonMap.put("ipAddress", this.getIpAddress());
            jsonMap.put("userAgent", this.getUserAgent());
            return JSON.std.asString(jsonMap);
        }
        catch (IOException e) {
            throw new UnexpectedException(e.getMessage(), e);
        }
    }
}

