/*
 * Decompiled with CFR 0.152.
 */
package com.braintreegateway;

import com.braintreegateway.SepaDirectDebitAccountDetails;
import com.braintreegateway.util.EnumUtils;
import com.braintreegateway.util.NodeWrapper;
import java.util.Map;

public class PaymentMethodNonceDetailsSepaDirectDebit {
    private SepaDirectDebitAccountDetails.MandateType mandateType;
    private String bankReferenceToken;
    private String correlationId;
    private String ibanLastChars;
    private String merchantOrPartnerCustomerId;

    public PaymentMethodNonceDetailsSepaDirectDebit(NodeWrapper node) {
        this.bankReferenceToken = node.findString("bank-reference-token");
        this.correlationId = node.findString("correlation-id");
        this.ibanLastChars = node.findString("iban-last-chars");
        this.mandateType = EnumUtils.findByName(SepaDirectDebitAccountDetails.MandateType.class, node.findString("mandate-type"), SepaDirectDebitAccountDetails.MandateType.ONE_OFF);
        this.merchantOrPartnerCustomerId = node.findString("merchant-or-partner-customer-id");
    }

    public PaymentMethodNonceDetailsSepaDirectDebit(Map<String, Object> map) {
        this.bankReferenceToken = (String)map.get("bank-reference-token");
        this.correlationId = (String)map.get("correlation-id");
        this.ibanLastChars = (String)map.get("iban-last-chars");
        this.mandateType = EnumUtils.findByName(SepaDirectDebitAccountDetails.MandateType.class, (String)map.get("mandate-type"), SepaDirectDebitAccountDetails.MandateType.ONE_OFF);
        this.merchantOrPartnerCustomerId = (String)map.get("merchant-or-partner-customer-id");
    }

    public String getBankReferenceToken() {
        return this.bankReferenceToken;
    }

    public String getCorrelationId() {
        return this.correlationId;
    }

    public String getIbanLastChars() {
        return this.ibanLastChars;
    }

    public String getMandateType() {
        return this.mandateType.name();
    }

    public String getMerchantOrPartnerCustomerId() {
        return this.merchantOrPartnerCustomerId;
    }
}

