/*
 * Decompiled with CFR 0.152.
 */
package com.braintreegateway;

import com.braintreegateway.DisputeEvidence;
import com.braintreegateway.DisputeStatusHistory;
import com.braintreegateway.DisputeTransaction;
import com.braintreegateway.TransactionDetails;
import com.braintreegateway.util.EnumUtils;
import com.braintreegateway.util.NodeWrapper;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;

public class Dispute {
    private final Calendar createdAt;
    private final Calendar receivedDate;
    private final Calendar replyByDate;
    private final Calendar openedDate;
    private final Calendar updatedAt;
    private final Calendar wonDate;
    private final List<DisputeEvidence> evidence;
    private final List<DisputeStatusHistory> statusHistory;
    private final String caseNumber;
    private final String currencyIsoCode;
    private final String graphqlId;
    private final String id;
    private final String processorComments;
    private final String merchantAccountId;
    private final String originalDisputeId;
    private final String reasonCode;
    private final String reasonDescription;
    private final String referenceNumber;
    private final Reason reason;
    private final Status status;
    private final Kind kind;
    private final BigDecimal amount;
    private final BigDecimal disputedAmount;
    private final BigDecimal wonAmount;
    private final TransactionDetails transactionDetails;
    private final DisputeTransaction transaction;

    public Dispute(NodeWrapper node) {
        this.createdAt = node.findDateTime("created-at");
        this.receivedDate = node.findDate("received-date");
        this.replyByDate = node.findDate("reply-by-date");
        this.openedDate = node.findDate("date-opened");
        this.updatedAt = node.findDateTime("updated-at");
        this.wonDate = node.findDate("date-won");
        this.caseNumber = node.findString("case-number");
        this.currencyIsoCode = node.findString("currency-iso-code");
        this.processorComments = node.findString("processor-comments");
        this.merchantAccountId = node.findString("merchant-account-id");
        this.originalDisputeId = node.findString("original-dispute-id");
        this.reasonCode = node.findString("reason-code");
        this.reasonDescription = node.findString("reason-description");
        this.referenceNumber = node.findString("reference-number");
        this.reason = EnumUtils.findByName(Reason.class, node.findString("reason"), Reason.GENERAL);
        this.status = EnumUtils.findByName(Status.class, node.findString("status"), Status.UNRECOGNIZED);
        this.kind = EnumUtils.findByName(Kind.class, node.findString("kind"), Kind.UNRECOGNIZED);
        this.amount = node.findBigDecimal("amount");
        this.disputedAmount = node.findBigDecimal("amount-disputed");
        this.wonAmount = node.findBigDecimal("amount-won");
        this.graphqlId = node.findString("global-id");
        this.id = node.findString("id");
        this.transaction = new DisputeTransaction(node.findFirst("transaction"));
        this.transactionDetails = new TransactionDetails(node.findFirst("transaction"));
        this.evidence = new ArrayList<DisputeEvidence>();
        for (NodeWrapper evidenceNode : node.findAll("evidence/evidence")) {
            this.evidence.add(new DisputeEvidence(evidenceNode));
        }
        this.statusHistory = new ArrayList<DisputeStatusHistory>();
        for (NodeWrapper statusNode : node.findAll("status-history/status-history")) {
            this.statusHistory.add(new DisputeStatusHistory(statusNode));
        }
    }

    public Calendar getCreatedAt() {
        return this.createdAt;
    }

    public Calendar getReceivedDate() {
        return this.receivedDate;
    }

    public Calendar getReplyByDate() {
        return this.replyByDate;
    }

    public Calendar getOpenedDate() {
        return this.openedDate;
    }

    public Calendar getUpdatedAt() {
        return this.updatedAt;
    }

    public Calendar getWonDate() {
        return this.wonDate;
    }

    public String getCaseNumber() {
        return this.caseNumber;
    }

    public String getCurrencyIsoCode() {
        return this.currencyIsoCode;
    }

    public String getProcessorComments() {
        return this.processorComments;
    }

    public String getId() {
        return this.id;
    }

    public String getGraphQLId() {
        return this.graphqlId;
    }

    public String getMerchantAccountId() {
        return this.merchantAccountId;
    }

    public String getOriginalDisputeId() {
        return this.originalDisputeId;
    }

    public String getReasonCode() {
        return this.reasonCode;
    }

    public String getReasonDescription() {
        return this.reasonDescription;
    }

    public String getReferenceNumber() {
        return this.referenceNumber;
    }

    public Reason getReason() {
        return this.reason;
    }

    public Status getStatus() {
        return this.status;
    }

    public Kind getKind() {
        return this.kind;
    }

    public BigDecimal getAmount() {
        return this.amount;
    }

    public BigDecimal getDisputedAmount() {
        return this.disputedAmount;
    }

    public BigDecimal getWonAmount() {
        return this.wonAmount;
    }

    public List<DisputeEvidence> getEvidence() {
        return this.evidence;
    }

    public List<DisputeStatusHistory> getStatusHistory() {
        return this.statusHistory;
    }

    public DisputeTransaction getTransaction() {
        return this.transaction;
    }

    public static enum Kind {
        CHARGEBACK,
        PRE_ARBITRATION,
        RETRIEVAL,
        UNRECOGNIZED;

    }

    public static enum Reason {
        CANCELLED_RECURRING_TRANSACTION,
        CREDIT_NOT_PROCESSED,
        DUPLICATE,
        FRAUD,
        GENERAL,
        INVALID_ACCOUNT,
        NOT_RECOGNIZED,
        PRODUCT_NOT_RECEIVED,
        PRODUCT_UNSATISFACTORY,
        TRANSACTION_AMOUNT_DIFFERS,
        RETRIEVAL;

    }

    public static enum Status {
        OPEN,
        LOST,
        WON,
        UNRECOGNIZED,
        ACCEPTED,
        DISPUTED,
        EXPIRED;

    }
}

