/*
 * Decompiled with CFR 0.152.
 */
package com.braintreegateway;

import com.braintreegateway.PaymentMethodNonceDetailsPayerInfo;
import com.braintreegateway.PaymentMethodNonceDetailsSepaDirectDebit;
import com.braintreegateway.util.NodeWrapper;
import java.util.Map;

public class PaymentMethodNonceDetails {
    private PaymentMethodNonceDetailsPayerInfo payerInfo;
    private PaymentMethodNonceDetailsSepaDirectDebit sepaDirectDebit;
    private String bin;
    private String cardType;
    private String cardholderName;
    private String dpanLastTwo;
    private String email;
    private String expirationMonth;
    private String expirationYear;
    private String lastFour;
    private String lastTwo;
    private String paymentInstrumentName;
    private String username;
    private String venmoUserId;

    public PaymentMethodNonceDetails(NodeWrapper node) {
        this.bin = node.findString("bin");
        this.cardType = node.findString("card-type");
        this.cardholderName = node.findString("cardholder-name");
        this.dpanLastTwo = node.findString("dpan-last-two");
        this.email = node.findString("email");
        this.expirationMonth = node.findString("expiration-month");
        this.expirationYear = node.findString("expiration-year");
        this.lastFour = node.findString("last-four");
        this.lastTwo = node.findString("last-two");
        this.paymentInstrumentName = node.findString("payment-instrument-name");
        this.username = node.findString("username");
        this.venmoUserId = node.findString("venmo-user-id");
        NodeWrapper payerInfoNode = node.findFirst("payer-info");
        if (payerInfoNode != null && !payerInfoNode.isBlank()) {
            this.payerInfo = new PaymentMethodNonceDetailsPayerInfo(payerInfoNode);
        }
        if (node.findString("bank-reference-token") != null && node.findString("iban-last-chars") != null) {
            this.sepaDirectDebit = new PaymentMethodNonceDetailsSepaDirectDebit(node);
        }
    }

    public PaymentMethodNonceDetails(Map<String, Object> map) {
        this.bin = (String)map.get("bin");
        this.cardType = (String)map.get("card-type");
        this.cardholderName = (String)map.get("cardholder-name");
        this.dpanLastTwo = (String)map.get("dpan-last-two");
        this.email = (String)map.get("email");
        this.expirationMonth = (String)map.get("expiration-month");
        this.expirationYear = (String)map.get("expiration-year");
        this.lastFour = (String)map.get("last-four");
        this.lastTwo = (String)map.get("last-two");
        this.paymentInstrumentName = (String)map.get("payment-instrument-name");
        this.username = (String)map.get("username");
        this.venmoUserId = (String)map.get("venmo-user-id");
        Map payerInfoMap = (Map)map.get("payer-info");
        if (payerInfoMap != null) {
            this.payerInfo = new PaymentMethodNonceDetailsPayerInfo(payerInfoMap);
        }
        if (map.get("bank-reference-token") != null && map.get("iban-last-chars") != null) {
            this.sepaDirectDebit = new PaymentMethodNonceDetailsSepaDirectDebit(map);
        }
    }

    public String getBin() {
        return this.bin;
    }

    public String getCardType() {
        return this.cardType;
    }

    public String getCardholderName() {
        return this.cardholderName;
    }

    public String getDpanLastTwo() {
        return this.dpanLastTwo;
    }

    public String getEmail() {
        return this.email;
    }

    public String getExpirationMonth() {
        return this.expirationMonth;
    }

    public String getExpirationYear() {
        return this.expirationYear;
    }

    public String getLastTwo() {
        return this.lastTwo;
    }

    public String getLastFour() {
        return this.lastFour;
    }

    public String getPaymentInstrumentName() {
        return this.paymentInstrumentName;
    }

    public String getUsername() {
        return this.username;
    }

    public String getVenmoUserId() {
        return this.venmoUserId;
    }

    public PaymentMethodNonceDetailsPayerInfo getPayerInfo() {
        return this.payerInfo;
    }

    public PaymentMethodNonceDetailsSepaDirectDebit getSepaDirectDebit() {
        return this.sepaDirectDebit;
    }
}

