/*
 * Decompiled with CFR 0.152.
 */
package com.braintreegateway;

import com.braintreegateway.ValidationError;
import com.braintreegateway.ValidationErrorCode;
import com.braintreegateway.util.NodeWrapper;
import com.braintreegateway.util.StringUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ValidationErrors {
    private List<ValidationError> errors = new ArrayList<ValidationError>();
    private Map<String, ValidationErrors> nestedErrors = new HashMap<String, ValidationErrors>();

    public ValidationErrors() {
    }

    public ValidationErrors(NodeWrapper node) {
        this();
        this.populateErrors(node);
    }

    public void addError(ValidationError error) {
        this.errors.add(error);
    }

    public void addErrors(String objectName, ValidationErrors errors) {
        this.nestedErrors.put(objectName, errors);
    }

    public int deepSize() {
        int size = this.errors.size();
        for (ValidationErrors nestedError : this.nestedErrors.values()) {
            size += nestedError.deepSize();
        }
        return size;
    }

    public ValidationErrors forIndex(int index) {
        return this.forObject("index_" + index);
    }

    public ValidationErrors forObject(String objectName) {
        ValidationErrors errorsOnObject = this.nestedErrors.get(StringUtils.dasherize(objectName));
        if (errorsOnObject == null) {
            return new ValidationErrors();
        }
        return errorsOnObject;
    }

    public List<ValidationError> getAllDeepValidationErrors() {
        ArrayList<ValidationError> result = new ArrayList<ValidationError>(this.errors);
        for (ValidationErrors validationErrors : this.nestedErrors.values()) {
            result.addAll(validationErrors.getAllDeepValidationErrors());
        }
        return result;
    }

    public List<ValidationError> getAllValidationErrors() {
        return Collections.unmodifiableList(new ArrayList<ValidationError>(this.errors));
    }

    public List<ValidationError> onField(String fieldName) {
        ArrayList<ValidationError> list = new ArrayList<ValidationError>();
        for (ValidationError error : this.errors) {
            if (!error.getAttribute().equals(StringUtils.underscore(fieldName))) continue;
            list.add(error);
        }
        return list;
    }

    private void populateErrors(NodeWrapper node) {
        if (node.getElementName().equals("api-error-response")) {
            node = node.findFirst("errors");
        }
        List<NodeWrapper> errorResponses = node.findAll("*");
        for (NodeWrapper errorResponse : errorResponses) {
            if (!errorResponse.getElementName().equals("errors")) {
                this.nestedErrors.put(errorResponse.getElementName(), new ValidationErrors(errorResponse));
                continue;
            }
            this.populateTopLevelErrors(errorResponse.findAll("error"));
        }
    }

    private void populateTopLevelErrors(List<NodeWrapper> childErrors) {
        for (NodeWrapper childError : childErrors) {
            ValidationErrorCode code = ValidationErrorCode.findByCode(childError.findString("code"));
            String message = childError.findString("message");
            this.errors.add(new ValidationError(childError.findString("attribute"), code, message));
        }
    }

    public int size() {
        return this.errors.size();
    }
}

