/*
 * Decompiled with CFR 0.152.
 */
package com.braintreegateway;

import com.braintreegateway.AchReturnResponse;
import com.braintreegateway.AddOn;
import com.braintreegateway.Address;
import com.braintreegateway.AmexExpressCheckoutDetails;
import com.braintreegateway.AndroidPayDetails;
import com.braintreegateway.ApplePayDetails;
import com.braintreegateway.AuthorizationAdjustment;
import com.braintreegateway.BraintreeGateway;
import com.braintreegateway.CreditCard;
import com.braintreegateway.CustomActionsPaymentMethodDetails;
import com.braintreegateway.Customer;
import com.braintreegateway.Descriptor;
import com.braintreegateway.DisbursementDetails;
import com.braintreegateway.Discount;
import com.braintreegateway.Dispute;
import com.braintreegateway.FacilitatedDetails;
import com.braintreegateway.FacilitatorDetails;
import com.braintreegateway.Installment;
import com.braintreegateway.LocalPaymentDetails;
import com.braintreegateway.MasterpassCardDetails;
import com.braintreegateway.PayPalDetails;
import com.braintreegateway.PayPalHereDetails;
import com.braintreegateway.ProcessorResponseType;
import com.braintreegateway.RiskData;
import com.braintreegateway.SamsungPayCardDetails;
import com.braintreegateway.SepaDirectDebitAccountDetails;
import com.braintreegateway.StatusEvent;
import com.braintreegateway.Subscription;
import com.braintreegateway.SubscriptionDetails;
import com.braintreegateway.ThreeDSecureInfo;
import com.braintreegateway.TransactionLineItem;
import com.braintreegateway.UsBankAccountDetails;
import com.braintreegateway.VenmoAccountDetails;
import com.braintreegateway.VisaCheckoutCardDetails;
import com.braintreegateway.util.EnumUtils;
import com.braintreegateway.util.NodeWrapper;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Map;

public class Transaction {
    private Address billingAddress;
    private Address shippingAddress;
    private AmexExpressCheckoutDetails amexExpressCheckoutDetails;
    private AndroidPayDetails androidPayDetails;
    private ApplePayDetails applePayDetails;
    private BigDecimal amount;
    private BigDecimal discountAmount;
    private BigDecimal serviceFeeAmount;
    private BigDecimal shippingAmount;
    private BigDecimal taxAmount;
    private Boolean recurring;
    private Boolean taxExempt;
    private Calendar authorizationExpiresAt;
    private Calendar createdAt;
    private Calendar updatedAt;
    private CreditCard creditCard;
    private CustomActionsPaymentMethodDetails customActionsPaymentMethodDetails;
    private CreditCard networkToken;
    private Customer customer;
    private Descriptor descriptor;
    private DisbursementDetails disbursementDetails;
    private EscrowStatus escrowStatus;
    private FacilitatedDetails facilitatedDetails;
    private FacilitatorDetails facilitatorDetails;
    private GatewayRejectionReason gatewayRejectionReason;
    private Integer installmentCount;
    private List<AchReturnResponse> achReturnResponses;
    private List<AddOn> addOns;
    private List<AuthorizationAdjustment> authorizationAdjustments;
    private List<Discount> discounts;
    private List<Dispute> disputes;
    private List<Installment> installments;
    private List<Installment> refundedInstallments;
    private List<StatusEvent> statusHistory;
    private List<String> partialSettlementTransactionIds;
    private List<String> refundIds;
    private LocalPaymentDetails localPaymentDetails;
    private Map<String, String> customFields;
    private MasterpassCardDetails masterpassCardDetails;
    private PayPalDetails paypalDetails;
    private PayPalHereDetails paypalHereDetails;
    private ProcessorResponseType processorResponseType;
    private RiskData riskData;
    private SamsungPayCardDetails samsungPayCardDetails;
    private ScaExemption scaExemptionRequested;
    private SepaDirectDebitAccountDetails sepaDirectDebitAccountDetails;
    private Status status;
    private String achReturnCode;
    private String acquirerReferenceNumber;
    private String additionalProcessorResponse;
    private String authorizedTransactionId;
    private String avsErrorResponseCode;
    private String avsPostalCodeResponseCode;
    private String avsStreetAddressResponseCode;
    private String channel;
    private String currencyIsoCode;
    private String cvvResponseCode;
    private String debitNetwork;
    private String duplicateOfTransactionId;
    private String graphqlId;
    private String id;
    private String merchantAccountId;
    private String merchantAdviceCode;
    private String merchantAdviceCodeText;
    private String networkResponseCode;
    private String networkResponseText;
    private String networkTransactionId;
    private String orderId;
    private String paymentInstrumentType;
    private String planId;
    private String processorAuthorizationCode;
    private String processorResponseCode;
    private String processorResponseText;
    private String processorSettlementResponseCode;
    private String processorSettlementResponseText;
    private String purchaseOrderNumber;
    private String refundId;
    private String refundedTransactionId;
    private String retrievalReferenceNumber;
    private String sepaDirectDebitReturnCode;
    private String settlementBatchId;
    private String shipsFromPostalCode;
    private String subscriptionId;
    private String voiceReferralNumber;
    private Subscription subscription;
    private SubscriptionDetails subscriptionDetails;
    private ThreeDSecureInfo threeDSecureInfo;
    private Type type;
    private UsBankAccountDetails usBankAccountDetails;
    private VenmoAccountDetails venmoAccountDetails;
    private VisaCheckoutCardDetails visaCheckoutCardDetails;
    private boolean processedWithNetworkToken;
    private boolean retried;

    public boolean isDisbursed() {
        return this.getDisbursementDetails().isValid();
    }

    public Transaction(NodeWrapper node) {
        NodeWrapper facilitatorDetailsNode;
        NodeWrapper threeDSecureInfoNode;
        NodeWrapper customActionsPaymentMethodNode;
        NodeWrapper samsungPayCardNode;
        NodeWrapper masterpassCardNode;
        NodeWrapper visaCheckoutCardNode;
        NodeWrapper localPaymentNode;
        NodeWrapper usBankAccountNode;
        NodeWrapper venmoAccountNode;
        NodeWrapper sepaDirectDebitAccountNode;
        NodeWrapper amexExpressCheckoutCardNode;
        NodeWrapper androidPayCardNode;
        NodeWrapper applePayNode;
        NodeWrapper paypalHereNode;
        NodeWrapper paypalNode;
        NodeWrapper descriptorNode;
        NodeWrapper disbursementDetailsNode;
        NodeWrapper customerNode;
        NodeWrapper networkTokenNode;
        NodeWrapper creditCardNode;
        this.amount = node.findBigDecimal("amount");
        this.avsErrorResponseCode = node.findString("avs-error-response-code");
        this.avsPostalCodeResponseCode = node.findString("avs-postal-code-response-code");
        this.avsStreetAddressResponseCode = node.findString("avs-street-address-response-code");
        this.channel = node.findString("channel");
        this.createdAt = node.findDateTime("created-at");
        this.currencyIsoCode = node.findString("currency-iso-code");
        this.customFields = node.findMap("custom-fields/*");
        this.cvvResponseCode = node.findString("cvv-response-code");
        this.debitNetwork = node.findString("debit-network");
        this.escrowStatus = EnumUtils.findByName(EscrowStatus.class, node.findString("escrow-status"), EscrowStatus.UNRECOGNIZED);
        this.gatewayRejectionReason = EnumUtils.findByName(GatewayRejectionReason.class, node.findString("gateway-rejection-reason"), GatewayRejectionReason.UNRECOGNIZED);
        this.duplicateOfTransactionId = node.findString("duplicate-of-transaction-id");
        this.graphqlId = node.findString("global-id");
        this.id = node.findString("id");
        this.merchantAccountId = node.findString("merchant-account-id");
        this.orderId = node.findString("order-id");
        this.scaExemptionRequested = EnumUtils.findByName(ScaExemption.class, node.findString("sca-exemption-requested"), null);
        NodeWrapper billingAddressNode = node.findFirst("billing");
        if (billingAddressNode != null) {
            this.billingAddress = new Address(billingAddressNode);
        }
        if ((creditCardNode = node.findFirst("credit-card")) != null) {
            this.creditCard = new CreditCard(creditCardNode);
        }
        if ((networkTokenNode = node.findFirst("network-token")) != null) {
            this.networkToken = new CreditCard(networkTokenNode);
        }
        if ((customerNode = node.findFirst("customer")) != null) {
            this.customer = new Customer(customerNode);
        }
        if ((disbursementDetailsNode = node.findFirst("disbursement-details")) != null) {
            this.disbursementDetails = new DisbursementDetails(disbursementDetailsNode);
        }
        if ((descriptorNode = node.findFirst("descriptor")) != null) {
            this.descriptor = new Descriptor(descriptorNode);
        }
        if ((paypalNode = node.findFirst("paypal")) != null) {
            this.paypalDetails = new PayPalDetails(paypalNode);
        }
        if ((paypalHereNode = node.findFirst("paypal-here")) != null) {
            this.paypalHereDetails = new PayPalHereDetails(paypalHereNode);
        }
        if ((applePayNode = node.findFirst("apple-pay")) != null) {
            this.applePayDetails = new ApplePayDetails(applePayNode);
        }
        if ((androidPayCardNode = node.findFirst("android-pay-card")) != null) {
            this.androidPayDetails = new AndroidPayDetails(androidPayCardNode);
        }
        if ((amexExpressCheckoutCardNode = node.findFirst("amex-express-checkout-card")) != null) {
            this.amexExpressCheckoutDetails = new AmexExpressCheckoutDetails(amexExpressCheckoutCardNode);
        }
        if ((sepaDirectDebitAccountNode = node.findFirst("sepa-debit-account-detail")) != null) {
            this.sepaDirectDebitAccountDetails = new SepaDirectDebitAccountDetails(sepaDirectDebitAccountNode);
        }
        if ((venmoAccountNode = node.findFirst("venmo-account")) != null) {
            this.venmoAccountDetails = new VenmoAccountDetails(venmoAccountNode);
        }
        if ((usBankAccountNode = node.findFirst("us-bank-account")) != null) {
            this.usBankAccountDetails = new UsBankAccountDetails(usBankAccountNode);
        }
        if ((localPaymentNode = node.findFirst("local-payment")) != null) {
            this.localPaymentDetails = new LocalPaymentDetails(localPaymentNode);
        }
        if ((visaCheckoutCardNode = node.findFirst("visa-checkout-card")) != null) {
            this.visaCheckoutCardDetails = new VisaCheckoutCardDetails(visaCheckoutCardNode);
        }
        if ((masterpassCardNode = node.findFirst("masterpass-card")) != null) {
            this.masterpassCardDetails = new MasterpassCardDetails(masterpassCardNode);
        }
        if ((samsungPayCardNode = node.findFirst("samsung-pay-card")) != null) {
            this.samsungPayCardDetails = new SamsungPayCardDetails(samsungPayCardNode);
        }
        if ((customActionsPaymentMethodNode = node.findFirst("custom-actions-payment-method")) != null) {
            this.customActionsPaymentMethodDetails = new CustomActionsPaymentMethodDetails(customActionsPaymentMethodNode);
        }
        this.achReturnCode = node.findString("ach-return-code");
        this.sepaDirectDebitReturnCode = node.findString("sepa-direct-debit-return-code");
        this.planId = node.findString("plan-id");
        this.processedWithNetworkToken = node.findBoolean("processed-with-network-token");
        this.processorAuthorizationCode = node.findString("processor-authorization-code");
        this.processorResponseCode = node.findString("processor-response-code");
        this.processorResponseText = node.findString("processor-response-text");
        this.merchantAdviceCode = node.findString("merchant-advice-code");
        this.merchantAdviceCodeText = node.findString("merchant-advice-code-text");
        this.processorResponseType = EnumUtils.findByName(ProcessorResponseType.class, node.findString("processor-response-type"), ProcessorResponseType.UNRECOGNIZED);
        this.processorSettlementResponseCode = node.findString("processor-settlement-response-code");
        this.processorSettlementResponseText = node.findString("processor-settlement-response-text");
        this.additionalProcessorResponse = node.findString("additional-processor-response");
        this.networkResponseCode = node.findString("network-response-code");
        this.networkResponseText = node.findString("network-response-text");
        this.voiceReferralNumber = node.findString("voice-referral-number");
        this.purchaseOrderNumber = node.findString("purchase-order-number");
        this.recurring = node.findBoolean("recurring");
        this.refundedTransactionId = node.findString("refunded-transaction-id");
        this.refundId = node.findString("refund-id");
        NodeWrapper riskDataNode = node.findFirst("risk-data");
        if (riskDataNode != null) {
            this.riskData = new RiskData(riskDataNode);
        }
        if ((threeDSecureInfoNode = node.findFirst("three-d-secure-info")) != null && !threeDSecureInfoNode.isBlank()) {
            this.threeDSecureInfo = new ThreeDSecureInfo(threeDSecureInfoNode);
        }
        this.serviceFeeAmount = node.findBigDecimal("service-fee-amount");
        this.settlementBatchId = node.findString("settlement-batch-id");
        NodeWrapper shippingAddressNode = node.findFirst("shipping");
        if (shippingAddressNode != null) {
            this.shippingAddress = new Address(shippingAddressNode);
        }
        this.status = EnumUtils.findByName(Status.class, node.findString("status"), Status.UNRECOGNIZED);
        NodeWrapper subscriptionNode = node.findFirst("subscription");
        if (subscriptionNode != null) {
            this.subscriptionDetails = new SubscriptionDetails(subscriptionNode);
            this.subscription = new Subscription(subscriptionNode);
        }
        this.subscriptionId = node.findString("subscription-id");
        this.taxAmount = node.findBigDecimal("tax-amount");
        this.taxExempt = node.findBoolean("tax-exempt");
        this.shippingAmount = node.findBigDecimal("shipping-amount");
        this.discountAmount = node.findBigDecimal("discount-amount");
        this.shipsFromPostalCode = node.findString("ships-from-postal-code");
        this.type = EnumUtils.findByName(Type.class, node.findString("type"), Type.UNRECOGNIZED);
        this.updatedAt = node.findDateTime("updated-at");
        this.refundIds = new ArrayList<String>();
        for (NodeWrapper refundIdNode : node.findAll("refund-ids/item")) {
            this.refundIds.add(refundIdNode.findString("."));
        }
        this.retrievalReferenceNumber = node.findString("retrieval-reference-number");
        this.acquirerReferenceNumber = node.findString("acquirer-reference-number");
        this.statusHistory = new ArrayList<StatusEvent>();
        for (NodeWrapper statusNode : node.findAll("status-history/status-event")) {
            this.statusHistory.add(new StatusEvent(statusNode));
        }
        this.achReturnResponses = new ArrayList<AchReturnResponse>();
        for (NodeWrapper statusNode : node.findAll("ach-return-responses/ach-return-response")) {
            this.achReturnResponses.add(new AchReturnResponse(statusNode));
        }
        this.addOns = new ArrayList<AddOn>();
        for (NodeWrapper addOnResponse : node.findAll("add-ons/add-on")) {
            this.addOns.add(new AddOn(addOnResponse));
        }
        this.discounts = new ArrayList<Discount>();
        for (NodeWrapper discountResponse : node.findAll("discounts/discount")) {
            this.discounts.add(new Discount(discountResponse));
        }
        this.disputes = new ArrayList<Dispute>();
        for (NodeWrapper dispute : node.findAll("disputes/dispute")) {
            this.disputes.add(new Dispute(dispute));
        }
        this.paymentInstrumentType = node.findString("payment-instrument-type");
        this.authorizedTransactionId = node.findString("authorized-transaction-id");
        this.partialSettlementTransactionIds = new ArrayList<String>();
        for (NodeWrapper partialSettlementTransactionIdNode : node.findAll("partial-settlement-transaction-ids/*")) {
            this.partialSettlementTransactionIds.add(partialSettlementTransactionIdNode.findString("."));
        }
        this.authorizationAdjustments = new ArrayList<AuthorizationAdjustment>();
        for (NodeWrapper authorizationAdjustmentNode : node.findAll("authorization-adjustments/authorization-adjustment")) {
            this.authorizationAdjustments.add(new AuthorizationAdjustment(authorizationAdjustmentNode));
        }
        NodeWrapper facilitatedDetailsNode = node.findFirst("facilitated-details");
        if (facilitatedDetailsNode != null) {
            this.facilitatedDetails = new FacilitatedDetails(facilitatedDetailsNode);
        }
        if ((facilitatorDetailsNode = node.findFirst("facilitator-details")) != null) {
            this.facilitatorDetails = new FacilitatorDetails(facilitatorDetailsNode);
        }
        this.networkTransactionId = node.findString("network-transaction-id");
        this.authorizationExpiresAt = node.findDateTime("authorization-expires-at");
        this.installmentCount = node.findInteger("installment-count");
        this.installments = new ArrayList<Installment>();
        for (NodeWrapper installmentsNode : node.findAll("installments/installment")) {
            this.installments.add(new Installment(installmentsNode));
        }
        this.refundedInstallments = new ArrayList<Installment>();
        for (NodeWrapper installmentsNode : node.findAll("refunded-installments/refunded-installment")) {
            this.refundedInstallments.add(new Installment(installmentsNode));
        }
        this.retried = node.findBoolean("retried");
    }

    public List<AddOn> getAddOns() {
        return this.addOns;
    }

    public BigDecimal getAmount() {
        return this.amount;
    }

    public String getAvsErrorResponseCode() {
        return this.avsErrorResponseCode;
    }

    public String getAvsPostalCodeResponseCode() {
        return this.avsPostalCodeResponseCode;
    }

    public String getAvsStreetAddressResponseCode() {
        return this.avsStreetAddressResponseCode;
    }

    public Address getBillingAddress() {
        return this.billingAddress;
    }

    public String getChannel() {
        return this.channel;
    }

    public Calendar getCreatedAt() {
        return this.createdAt;
    }

    public CreditCard getCreditCard() {
        return this.creditCard;
    }

    public String getCurrencyIsoCode() {
        return this.currencyIsoCode;
    }

    public Customer getCustomer() {
        return this.customer;
    }

    public Map<String, String> getCustomFields() {
        return this.customFields;
    }

    public String getCvvResponseCode() {
        return this.cvvResponseCode;
    }

    public String getDebitNetwork() {
        return this.debitNetwork;
    }

    public DisbursementDetails getDisbursementDetails() {
        return this.disbursementDetails;
    }

    public List<Dispute> getDisputes() {
        return this.disputes;
    }

    public Descriptor getDescriptor() {
        return this.descriptor;
    }

    public List<Discount> getDiscounts() {
        return this.discounts;
    }

    public String getDuplicateOfTransactionId() {
        return this.duplicateOfTransactionId;
    }

    public EscrowStatus getEscrowStatus() {
        return this.escrowStatus;
    }

    public GatewayRejectionReason getGatewayRejectionReason() {
        return this.gatewayRejectionReason;
    }

    public String getId() {
        return this.id;
    }

    public String getGraphQLId() {
        return this.graphqlId;
    }

    public String getMerchantAccountId() {
        return this.merchantAccountId;
    }

    public CreditCard getNetworkToken() {
        return this.networkToken;
    }

    public String getOrderId() {
        return this.orderId;
    }

    public PayPalDetails getPayPalDetails() {
        return this.paypalDetails;
    }

    public PayPalHereDetails getPayPalHereDetails() {
        return this.paypalHereDetails;
    }

    public SepaDirectDebitAccountDetails getSepaDirectDebitAccountDetails() {
        return this.sepaDirectDebitAccountDetails;
    }

    public ScaExemption getScaExemptionRequested() {
        return this.scaExemptionRequested;
    }

    public ApplePayDetails getApplePayDetails() {
        return this.applePayDetails;
    }

    public AndroidPayDetails getAndroidPayDetails() {
        return this.androidPayDetails;
    }

    @Deprecated
    public AmexExpressCheckoutDetails getAmexExpressCheckoutDetails() {
        return this.amexExpressCheckoutDetails;
    }

    public VenmoAccountDetails getVenmoAccountDetails() {
        return this.venmoAccountDetails;
    }

    public UsBankAccountDetails getUsBankAccountDetails() {
        return this.usBankAccountDetails;
    }

    public LocalPaymentDetails getLocalPaymentDetails() {
        return this.localPaymentDetails;
    }

    public VisaCheckoutCardDetails getVisaCheckoutCardDetails() {
        return this.visaCheckoutCardDetails;
    }

    @Deprecated
    public MasterpassCardDetails getMasterpassCardDetails() {
        return this.masterpassCardDetails;
    }

    public SamsungPayCardDetails getSamsungPayCardDetails() {
        return this.samsungPayCardDetails;
    }

    public CustomActionsPaymentMethodDetails getCustomActionsPaymentMethodDetails() {
        return this.customActionsPaymentMethodDetails;
    }

    public String getPlanId() {
        return this.planId;
    }

    public boolean isProcessedWithNetworkToken() {
        return this.processedWithNetworkToken;
    }

    public String getProcessorAuthorizationCode() {
        return this.processorAuthorizationCode;
    }

    public String getProcessorResponseCode() {
        return this.processorResponseCode;
    }

    public String getProcessorResponseText() {
        return this.processorResponseText;
    }

    public ProcessorResponseType getProcessorResponseType() {
        return this.processorResponseType;
    }

    public String getProcessorSettlementResponseCode() {
        return this.processorSettlementResponseCode;
    }

    public String getProcessorSettlementResponseText() {
        return this.processorSettlementResponseText;
    }

    public String getAdditionalProcessorResponse() {
        return this.additionalProcessorResponse;
    }

    public String getNetworkResponseCode() {
        return this.networkResponseCode;
    }

    public String getAchReturnCode() {
        return this.achReturnCode;
    }

    public String getMerchantAdviceCode() {
        return this.merchantAdviceCode;
    }

    public String getMerchantAdviceCodeText() {
        return this.merchantAdviceCodeText;
    }

    public String getSepaDirectDebitReturnCode() {
        return this.sepaDirectDebitReturnCode;
    }

    public String getNetworkResponseText() {
        return this.networkResponseText;
    }

    public String getVoiceReferralNumber() {
        return this.voiceReferralNumber;
    }

    public List<AchReturnResponse> getAchReturnResponses() {
        return this.achReturnResponses;
    }

    public String getPurchaseOrderNumber() {
        return this.purchaseOrderNumber;
    }

    public String getRefundedTransactionId() {
        return this.refundedTransactionId;
    }

    public List<String> getRefundIds() {
        return this.refundIds;
    }

    public String getRetrievalReferenceNumber() {
        return this.retrievalReferenceNumber;
    }

    public String getAcquirerReferenceNumber() {
        return this.acquirerReferenceNumber;
    }

    public RiskData getRiskData() {
        return this.riskData;
    }

    public ThreeDSecureInfo getThreeDSecureInfo() {
        return this.threeDSecureInfo;
    }

    public BigDecimal getServiceFeeAmount() {
        return this.serviceFeeAmount;
    }

    public String getSettlementBatchId() {
        return this.settlementBatchId;
    }

    public Address getShippingAddress() {
        return this.shippingAddress;
    }

    public Status getStatus() {
        return this.status;
    }

    public List<StatusEvent> getStatusHistory() {
        return this.statusHistory;
    }

    public String getSubscriptionId() {
        return this.subscriptionId;
    }

    public SubscriptionDetails getSubscriptionDetails() {
        return this.subscriptionDetails;
    }

    public BigDecimal getTaxAmount() {
        return this.taxAmount;
    }

    public BigDecimal getShippingAmount() {
        return this.shippingAmount;
    }

    public BigDecimal getDiscountAmount() {
        return this.discountAmount;
    }

    public String getShipsFromPostalCode() {
        return this.shipsFromPostalCode;
    }

    public Type getType() {
        return this.type;
    }

    @Deprecated
    public Boolean getRecurring() {
        return this.recurring;
    }

    public Boolean isRecurring() {
        return this.recurring;
    }

    public Calendar getUpdatedAt() {
        return this.updatedAt;
    }

    public Address getVaultBillingAddress(BraintreeGateway gateway) {
        if (this.billingAddress.getId() == null) {
            return null;
        }
        return gateway.address().find(this.customer.getId(), this.billingAddress.getId());
    }

    public CreditCard getVaultCreditCard(BraintreeGateway gateway) {
        if (this.creditCard.getToken() == null) {
            return null;
        }
        return gateway.creditCard().find(this.creditCard.getToken());
    }

    public Customer getVaultCustomer(BraintreeGateway gateway) {
        if (this.customer.getId() == null) {
            return null;
        }
        return gateway.customer().find(this.customer.getId());
    }

    public Address getVaultShippingAddress(BraintreeGateway gateway) {
        if (this.shippingAddress.getId() == null) {
            return null;
        }
        return gateway.address().find(this.customer.getId(), this.shippingAddress.getId());
    }

    public Boolean isTaxExempt() {
        return this.taxExempt;
    }

    public String getPaymentInstrumentType() {
        return this.paymentInstrumentType;
    }

    public String getAuthorizedTransactionId() {
        return this.authorizedTransactionId;
    }

    public List<String> getPartialSettlementTransactionIds() {
        return this.partialSettlementTransactionIds;
    }

    public List<AuthorizationAdjustment> getAuthorizationAdjustments() {
        return this.authorizationAdjustments;
    }

    public FacilitatedDetails getFacilitatedDetails() {
        return this.facilitatedDetails;
    }

    public FacilitatorDetails getFacilitatorDetails() {
        return this.facilitatorDetails;
    }

    public List<TransactionLineItem> getLineItems(BraintreeGateway gateway) {
        return gateway.transactionLineItem().findAll(this.id);
    }

    public String getNetworkTransactionId() {
        return this.networkTransactionId;
    }

    public Calendar getAuthorizationExpiresAt() {
        return this.authorizationExpiresAt;
    }

    public Integer getInstallmentCount() {
        return this.installmentCount;
    }

    public List<Installment> getInstallments() {
        return this.installments;
    }

    public List<Installment> getRefundedInstallments() {
        return this.refundedInstallments;
    }

    public boolean isRetried() {
        return this.retried;
    }

    public static enum Type {
        CREDIT("credit"),
        SALE("sale"),
        UNRECOGNIZED("unrecognized");

        private final String name;

        private Type(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }

    public static enum IndustryType {
        LODGING("lodging"),
        TRAVEL_CRUISE("travel_cruise"),
        TRAVEL_FLIGHT("travel_flight");

        private final String name;

        private IndustryType(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }

    public static enum Status {
        AUTHORIZATION_EXPIRED,
        AUTHORIZED,
        AUTHORIZING,
        FAILED,
        GATEWAY_REJECTED,
        PROCESSOR_DECLINED,
        SETTLED,
        SETTLEMENT_CONFIRMED,
        SETTLEMENT_DECLINED,
        SETTLEMENT_PENDING,
        SETTLING,
        SUBMITTED_FOR_SETTLEMENT,
        UNRECOGNIZED,
        VOIDED;

    }

    public static enum Source {
        API("api"),
        CONTROL_PANEL("control_panel"),
        RECURRING("recurring"),
        UNRECOGNIZED("unrecognized");

        private final String name;

        private Source(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }

    public static enum ScaExemption {
        LOW_VALUE("low_value"),
        SECURE_CORPORATE("secure_corporate"),
        TRUSTED_BENEFICIARY("trusted_beneficiary"),
        TRANSACTION_RISK_ANALYSIS("transaction_risk_analysis");

        private final String exemption;

        private ScaExemption(String exemption) {
            this.exemption = exemption;
        }

        public String toString() {
            return this.exemption;
        }
    }

    public static enum GatewayRejectionReason {
        APPLICATION_INCOMPLETE("application_incomplete"),
        AVS("avs"),
        AVS_AND_CVV("avs_and_cvv"),
        CVV("cvv"),
        DUPLICATE("duplicate"),
        EXCESSIVE_RETRY("excessive_retry"),
        FRAUD("fraud"),
        RISK_THRESHOLD("risk_threshold"),
        THREE_D_SECURE("three_d_secure"),
        TOKEN_ISSUANCE("token_issuance"),
        UNRECOGNIZED("unrecognized");

        private final String name;

        private GatewayRejectionReason(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }

    public static enum EscrowStatus {
        HELD,
        HOLD_PENDING,
        RELEASE_PENDING,
        RELEASED,
        REFUNDED,
        UNRECOGNIZED;

    }

    public static enum CreatedUsing {
        FULL_INFORMATION("full_information"),
        TOKEN("token"),
        UNRECOGNIZED("unrecognized");

        private final String name;

        private CreatedUsing(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

