/*
 * Decompiled with CFR 0.152.
 */
package com.braintreegateway;

import com.braintreegateway.PaymentMethodOptionsAdyenRequest;
import com.braintreegateway.PaymentMethodOptionsPayPalRequest;
import com.braintreegateway.PaymentMethodRequest;
import com.braintreegateway.Request;
import com.braintreegateway.RequestBuilder;
import com.braintreegateway.UsBankAccountVerification;

public class PaymentMethodOptionsRequest
extends Request {
    private Boolean failOnDuplicatePaymentMethod;
    private Boolean makeDefault;
    private Boolean skipAdvancedFraudChecking;
    private Boolean verifyCard;
    private PaymentMethodOptionsAdyenRequest paymentMethodOptionsAdyenRequest;
    private PaymentMethodOptionsPayPalRequest paymentMethodOptionsPayPalRequest;
    private PaymentMethodRequest parent;
    private String venmoSdkSession;
    private String verificationAccountType;
    private String verificationAmount;
    private String verificationCurrencyIsoCode;
    private String verificationMerchantAccountId;
    private UsBankAccountVerification.VerificationMethod usBankAccountVerificationMethod;

    public PaymentMethodOptionsRequest() {
    }

    public PaymentMethodOptionsRequest(PaymentMethodRequest parent) {
        this.parent = parent;
    }

    public PaymentMethodRequest done() {
        return this.parent;
    }

    public Boolean getMakeDefault() {
        return this.makeDefault;
    }

    public PaymentMethodOptionsRequest makeDefault(Boolean makeDefault) {
        this.makeDefault = makeDefault;
        return this;
    }

    public PaymentMethodOptionsRequest verificationMerchantAccountId(String verificationMerchantAccountId) {
        this.verificationMerchantAccountId = verificationMerchantAccountId;
        return this;
    }

    public PaymentMethodOptionsRequest verificationAccountType(String verificationAccountType) {
        this.verificationAccountType = verificationAccountType;
        return this;
    }

    public PaymentMethodOptionsRequest failOnDuplicatePaymentMethod(Boolean failOnDuplicatePaymentMethod) {
        this.failOnDuplicatePaymentMethod = failOnDuplicatePaymentMethod;
        return this;
    }

    public PaymentMethodOptionsRequest verifyCard(Boolean verifyCard) {
        this.verifyCard = verifyCard;
        return this;
    }

    public PaymentMethodOptionsRequest skipAdvancedFraudChecking(Boolean skipAdvancedFraudChecking) {
        this.skipAdvancedFraudChecking = skipAdvancedFraudChecking;
        return this;
    }

    public PaymentMethodOptionsRequest verificationAmount(String verificationAmount) {
        this.verificationAmount = verificationAmount;
        return this;
    }

    public PaymentMethodOptionsRequest venmoSdkSession(String venmoSdkSession) {
        this.venmoSdkSession = venmoSdkSession;
        return this;
    }

    public PaymentMethodOptionsRequest verificationCurrencyIsoCode(String verificationCurrencyIsoCode) {
        this.verificationCurrencyIsoCode = verificationCurrencyIsoCode;
        return this;
    }

    public PaymentMethodOptionsPayPalRequest paypal() {
        this.paymentMethodOptionsPayPalRequest = new PaymentMethodOptionsPayPalRequest(this);
        return this.paymentMethodOptionsPayPalRequest;
    }

    public PaymentMethodOptionsAdyenRequest adyen() {
        this.paymentMethodOptionsAdyenRequest = new PaymentMethodOptionsAdyenRequest(this);
        return this.paymentMethodOptionsAdyenRequest;
    }

    public PaymentMethodOptionsRequest usBankAccountVerificationMethod(UsBankAccountVerification.VerificationMethod verificationMethod) {
        this.usBankAccountVerificationMethod = verificationMethod;
        return this;
    }

    @Override
    public String toXML() {
        return this.buildRequest("options").toXML();
    }

    protected RequestBuilder buildRequest(String root) {
        RequestBuilder builder = new RequestBuilder(root);
        builder.addElement("adyen", this.paymentMethodOptionsAdyenRequest);
        builder.addElement("failOnDuplicatePaymentMethod", this.failOnDuplicatePaymentMethod);
        builder.addElement("paypal", this.paymentMethodOptionsPayPalRequest);
        builder.addElement("skipAdvancedFraudChecking", this.skipAdvancedFraudChecking);
        builder.addElement("usBankAccountVerificationMethod", (Object)this.usBankAccountVerificationMethod);
        builder.addElement("venmoSdkSession", this.venmoSdkSession);
        builder.addElement("verificationAccountType", this.verificationAccountType);
        builder.addElement("verificationAmount", this.verificationAmount);
        builder.addElement("verificationCurrencyIsoCode", this.verificationCurrencyIsoCode);
        builder.addElement("verificationMerchantAccountId", this.verificationMerchantAccountId);
        builder.addElement("verifyCard", this.verifyCard);
        if (this.makeDefault != null && this.makeDefault.booleanValue()) {
            builder.addElement("makeDefault", this.makeDefault);
        }
        return builder;
    }
}

