/*
 * Decompiled with CFR 0.152.
 */
package com.braintreegateway;

import com.braintreegateway.Configuration;
import com.braintreegateway.Plan;
import com.braintreegateway.PlanRequest;
import com.braintreegateway.Result;
import com.braintreegateway.exceptions.NotFoundException;
import com.braintreegateway.util.Http;
import com.braintreegateway.util.NodeWrapper;
import java.util.ArrayList;
import java.util.List;

public class PlanGateway {
    private Http http;
    private Configuration configuration;

    public PlanGateway(Http http, Configuration configuration) {
        this.http = http;
        this.configuration = configuration;
    }

    public List<Plan> all() {
        NodeWrapper node = this.http.get(this.configuration.getMerchantPath() + "/plans");
        ArrayList<Plan> plans = new ArrayList<Plan>();
        for (NodeWrapper planResponse : node.findAll("plan")) {
            plans.add(new Plan(planResponse));
        }
        return plans;
    }

    public Result<Plan> create(PlanRequest request) {
        NodeWrapper node = this.http.post(this.configuration.getMerchantPath() + "/plans", request);
        return new Result<Plan>(node, Plan.class);
    }

    public Plan find(String id) {
        if (id == null || id.trim().equals("")) {
            throw new NotFoundException();
        }
        return new Plan(this.http.get(this.configuration.getMerchantPath() + "/plans/" + id));
    }

    public Result<Plan> update(String id, PlanRequest request) {
        NodeWrapper node = this.http.put(this.configuration.getMerchantPath() + "/plans/" + id, request);
        return new Result<Plan>(node, Plan.class);
    }
}

