/*
 * Decompiled with CFR 0.152.
 */
package com.braintreegateway;

import com.braintreegateway.ProcessorResponseType;
import com.braintreegateway.util.EnumUtils;
import com.braintreegateway.util.NodeWrapper;
import java.math.BigDecimal;
import java.util.Calendar;

public class AuthorizationAdjustment {
    private BigDecimal amount;
    private Boolean success;
    private Calendar timestamp;
    private String processorResponseCode;
    private String processorResponseText;
    private ProcessorResponseType processorResponseType;

    public AuthorizationAdjustment(NodeWrapper node) {
        this.amount = node.findBigDecimal("amount");
        this.success = node.findBoolean("success");
        this.timestamp = node.findDateTime("timestamp");
        this.processorResponseCode = node.findString("processor-response-code");
        this.processorResponseText = node.findString("processor-response-text");
        this.processorResponseType = EnumUtils.findByName(ProcessorResponseType.class, node.findString("processor-response-type"), ProcessorResponseType.UNRECOGNIZED);
    }

    public BigDecimal getAmount() {
        return this.amount;
    }

    public Boolean isSuccess() {
        return this.success;
    }

    public Calendar getTimestamp() {
        return this.timestamp;
    }

    public String getProcessorResponseCode() {
        return this.processorResponseCode;
    }

    public String getProcessorResponseText() {
        return this.processorResponseText;
    }

    public ProcessorResponseType getProcessorResponseType() {
        return this.processorResponseType;
    }
}

