/*
 * Decompiled with CFR 0.152.
 */
package com.braintreegateway;

import com.braintreegateway.Configuration;
import com.braintreegateway.PaymentMethod;
import com.braintreegateway.PaymentMethodDeleteRequest;
import com.braintreegateway.PaymentMethodGrantRequest;
import com.braintreegateway.PaymentMethodGrantRevokeRequest;
import com.braintreegateway.PaymentMethodNonce;
import com.braintreegateway.PaymentMethodRequest;
import com.braintreegateway.RequestBuilder;
import com.braintreegateway.Result;
import com.braintreegateway.exceptions.NotFoundException;
import com.braintreegateway.util.Http;
import com.braintreegateway.util.NodeWrapper;
import com.braintreegateway.util.PaymentMethodParser;

public class PaymentMethodGateway {
    private Http http;
    private Configuration configuration;

    public PaymentMethodGateway(Http http, Configuration configuration) {
        this.http = http;
        this.configuration = configuration;
    }

    public Result<? extends PaymentMethod> create(PaymentMethodRequest request) {
        NodeWrapper response = this.http.post(this.configuration.getMerchantPath() + "/payment_methods", request);
        return this.parseResponse(response);
    }

    public Result<? extends PaymentMethod> update(String token, PaymentMethodRequest request) {
        NodeWrapper response = this.http.put(this.configuration.getMerchantPath() + "/payment_methods/any/" + token, request);
        return this.parseResponse(response);
    }

    public Result<? extends PaymentMethod> delete(String token) {
        this.http.delete(this.configuration.getMerchantPath() + "/payment_methods/any/" + token);
        return new Result();
    }

    public Result<? extends PaymentMethod> delete(String token, PaymentMethodDeleteRequest request) {
        this.http.delete(this.configuration.getMerchantPath() + "/payment_methods/any/" + token + "?" + request.toQueryString());
        return new Result();
    }

    public PaymentMethod find(String token) {
        if (token == null || token.trim().equals("")) {
            throw new NotFoundException();
        }
        NodeWrapper response = this.http.get(this.configuration.getMerchantPath() + "/payment_methods/any/" + token);
        return this.parseResponse(response).getTarget();
    }

    public Result<PaymentMethodNonce> grant(String token) {
        String request = new RequestBuilder("payment-method").addElement("shared-payment-method-token", token).toXML();
        NodeWrapper response = this.http.post(this.configuration.getMerchantPath() + "/payment_methods/grant", request);
        return new Result<PaymentMethodNonce>(response, PaymentMethodNonce.class);
    }

    public Result<PaymentMethodNonce> grant(String token, PaymentMethodGrantRequest grantRequest) {
        String request = grantRequest.sharedPaymentMethodToken(token).toXML();
        NodeWrapper response = this.http.post(this.configuration.getMerchantPath() + "/payment_methods/grant", request);
        return new Result<PaymentMethodNonce>(response, PaymentMethodNonce.class);
    }

    public Result<? extends PaymentMethod> revoke(String token) {
        PaymentMethodGrantRevokeRequest revokeRequest = new PaymentMethodGrantRevokeRequest();
        String request = revokeRequest.sharedPaymentMethodToken(token).toXML();
        NodeWrapper response = this.http.post(this.configuration.getMerchantPath() + "/payment_methods/revoke", request);
        return this.parseResponse(response);
    }

    public Result<? extends PaymentMethod> parseResponse(NodeWrapper response) {
        return PaymentMethodParser.parsePaymentMethod(response);
    }
}

