/*
 * Decompiled with CFR 0.152.
 */
package com.braintreegateway;

import com.braintreegateway.AddOn;
import com.braintreegateway.Address;
import com.braintreegateway.AmexExpressCheckoutDetails;
import com.braintreegateway.AndroidPayDetails;
import com.braintreegateway.ApplePayDetails;
import com.braintreegateway.AuthorizationAdjustment;
import com.braintreegateway.BraintreeGateway;
import com.braintreegateway.CreditCard;
import com.braintreegateway.CustomActionsPaymentMethodDetails;
import com.braintreegateway.Customer;
import com.braintreegateway.Descriptor;
import com.braintreegateway.DisbursementDetails;
import com.braintreegateway.Discount;
import com.braintreegateway.Dispute;
import com.braintreegateway.FacilitatedDetails;
import com.braintreegateway.FacilitatorDetails;
import com.braintreegateway.LocalPaymentDetails;
import com.braintreegateway.MasterpassCardDetails;
import com.braintreegateway.PayPalDetails;
import com.braintreegateway.PayPalHereDetails;
import com.braintreegateway.ProcessorResponseType;
import com.braintreegateway.RiskData;
import com.braintreegateway.SamsungPayCardDetails;
import com.braintreegateway.StatusEvent;
import com.braintreegateway.Subscription;
import com.braintreegateway.SubscriptionDetails;
import com.braintreegateway.ThreeDSecureInfo;
import com.braintreegateway.TransactionLineItem;
import com.braintreegateway.UsBankAccountDetails;
import com.braintreegateway.VenmoAccountDetails;
import com.braintreegateway.VisaCheckoutCardDetails;
import com.braintreegateway.util.EnumUtils;
import com.braintreegateway.util.NodeWrapper;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Map;

public class Transaction {
    private List<AddOn> addOns;
    private BigDecimal amount;
    private String avsErrorResponseCode;
    private String avsPostalCodeResponseCode;
    private String avsStreetAddressResponseCode;
    private Address billingAddress;
    private String channel;
    private Calendar createdAt;
    private CreditCard creditCard;
    private String currencyIsoCode;
    private Customer customer;
    private Map<String, String> customFields;
    private String cvvResponseCode;
    private DisbursementDetails disbursementDetails;
    private List<Dispute> disputes;
    private Descriptor descriptor;
    private List<Discount> discounts;
    private EscrowStatus escrowStatus;
    private GatewayRejectionReason gatewayRejectionReason;
    private String graphqlId;
    private String id;
    private String merchantAccountId;
    private String orderId;
    private PayPalDetails paypalDetails;
    private PayPalHereDetails paypalHereDetails;
    private ApplePayDetails applePayDetails;
    private AndroidPayDetails androidPayDetails;
    private AmexExpressCheckoutDetails amexExpressCheckoutDetails;
    private VenmoAccountDetails venmoAccountDetails;
    private UsBankAccountDetails usBankAccountDetails;
    private VisaCheckoutCardDetails visaCheckoutCardDetails;
    private MasterpassCardDetails masterpassCardDetails;
    private LocalPaymentDetails localPaymentDetails;
    private CustomActionsPaymentMethodDetails customActionsPaymentMethodDetails;
    private String planId;
    private String processorAuthorizationCode;
    private String processorResponseCode;
    private String processorResponseText;
    private ProcessorResponseType processorResponseType;
    private String processorSettlementResponseCode;
    private String processorSettlementResponseText;
    private String additionalProcessorResponse;
    private String networkResponseCode;
    private String networkResponseText;
    private String voiceReferralNumber;
    private String purchaseOrderNumber;
    private Boolean recurring;
    private String refundedTransactionId;
    private String refundId;
    private List<String> refundIds;
    private String retrievalReferenceNumber;
    private SamsungPayCardDetails samsungPayCardDetails;
    private String settlementBatchId;
    private Address shippingAddress;
    private Status status;
    private List<StatusEvent> statusHistory;
    private String subscriptionId;
    private Subscription subscription;
    private SubscriptionDetails subscriptionDetails;
    private BigDecimal taxAmount;
    private Boolean taxExempt;
    private BigDecimal shippingAmount;
    private BigDecimal discountAmount;
    private String shipsFromPostalCode;
    private Type type;
    private Calendar updatedAt;
    private BigDecimal serviceFeeAmount;
    private String paymentInstrumentType;
    private RiskData riskData;
    private ThreeDSecureInfo threeDSecureInfo;
    private String authorizedTransactionId;
    private List<String> partialSettlementTransactionIds;
    private List<AuthorizationAdjustment> authorizationAdjustments;
    private FacilitatedDetails facilitatedDetails;
    private FacilitatorDetails facilitatorDetails;
    private String networkTransactionId;
    private Calendar authorizationExpiresAt;

    public boolean isDisbursed() {
        return this.getDisbursementDetails().isValid();
    }

    public Transaction(NodeWrapper node) {
        NodeWrapper facilitatorDetailsNode;
        NodeWrapper threeDSecureInfoNode;
        NodeWrapper customActionsPaymentMethodNode;
        NodeWrapper samsungPayCardNode;
        NodeWrapper masterpassCardNode;
        NodeWrapper visaCheckoutCardNode;
        NodeWrapper localPaymentNode;
        NodeWrapper usBankAccountNode;
        NodeWrapper venmoAccountNode;
        NodeWrapper amexExpressCheckoutCardNode;
        NodeWrapper androidPayCardNode;
        NodeWrapper applePayNode;
        NodeWrapper paypalHereNode;
        NodeWrapper paypalNode;
        NodeWrapper descriptorNode;
        NodeWrapper disbursementDetailsNode;
        NodeWrapper customerNode;
        NodeWrapper creditCardNode;
        this.amount = node.findBigDecimal("amount");
        this.avsErrorResponseCode = node.findString("avs-error-response-code");
        this.avsPostalCodeResponseCode = node.findString("avs-postal-code-response-code");
        this.avsStreetAddressResponseCode = node.findString("avs-street-address-response-code");
        this.channel = node.findString("channel");
        this.createdAt = node.findDateTime("created-at");
        this.currencyIsoCode = node.findString("currency-iso-code");
        this.customFields = node.findMap("custom-fields/*");
        this.cvvResponseCode = node.findString("cvv-response-code");
        this.escrowStatus = EnumUtils.findByName(EscrowStatus.class, node.findString("escrow-status"), EscrowStatus.UNRECOGNIZED);
        this.gatewayRejectionReason = EnumUtils.findByName(GatewayRejectionReason.class, node.findString("gateway-rejection-reason"), GatewayRejectionReason.UNRECOGNIZED);
        this.graphqlId = node.findString("global-id");
        this.id = node.findString("id");
        this.merchantAccountId = node.findString("merchant-account-id");
        this.orderId = node.findString("order-id");
        NodeWrapper billingAddressNode = node.findFirst("billing");
        if (billingAddressNode != null) {
            this.billingAddress = new Address(billingAddressNode);
        }
        if ((creditCardNode = node.findFirst("credit-card")) != null) {
            this.creditCard = new CreditCard(creditCardNode);
        }
        if ((customerNode = node.findFirst("customer")) != null) {
            this.customer = new Customer(customerNode);
        }
        if ((disbursementDetailsNode = node.findFirst("disbursement-details")) != null) {
            this.disbursementDetails = new DisbursementDetails(disbursementDetailsNode);
        }
        if ((descriptorNode = node.findFirst("descriptor")) != null) {
            this.descriptor = new Descriptor(descriptorNode);
        }
        if ((paypalNode = node.findFirst("paypal")) != null) {
            this.paypalDetails = new PayPalDetails(paypalNode);
        }
        if ((paypalHereNode = node.findFirst("paypal-here")) != null) {
            this.paypalHereDetails = new PayPalHereDetails(paypalHereNode);
        }
        if ((applePayNode = node.findFirst("apple-pay")) != null) {
            this.applePayDetails = new ApplePayDetails(applePayNode);
        }
        if ((androidPayCardNode = node.findFirst("android-pay-card")) != null) {
            this.androidPayDetails = new AndroidPayDetails(androidPayCardNode);
        }
        if ((amexExpressCheckoutCardNode = node.findFirst("amex-express-checkout-card")) != null) {
            this.amexExpressCheckoutDetails = new AmexExpressCheckoutDetails(amexExpressCheckoutCardNode);
        }
        if ((venmoAccountNode = node.findFirst("venmo-account")) != null) {
            this.venmoAccountDetails = new VenmoAccountDetails(venmoAccountNode);
        }
        if ((usBankAccountNode = node.findFirst("us-bank-account")) != null) {
            this.usBankAccountDetails = new UsBankAccountDetails(usBankAccountNode);
        }
        if ((localPaymentNode = node.findFirst("local-payment")) != null) {
            this.localPaymentDetails = new LocalPaymentDetails(localPaymentNode);
        }
        if ((visaCheckoutCardNode = node.findFirst("visa-checkout-card")) != null) {
            this.visaCheckoutCardDetails = new VisaCheckoutCardDetails(visaCheckoutCardNode);
        }
        if ((masterpassCardNode = node.findFirst("masterpass-card")) != null) {
            this.masterpassCardDetails = new MasterpassCardDetails(masterpassCardNode);
        }
        if ((samsungPayCardNode = node.findFirst("samsung-pay-card")) != null) {
            this.samsungPayCardDetails = new SamsungPayCardDetails(samsungPayCardNode);
        }
        if ((customActionsPaymentMethodNode = node.findFirst("custom-actions-payment-method")) != null) {
            this.customActionsPaymentMethodDetails = new CustomActionsPaymentMethodDetails(customActionsPaymentMethodNode);
        }
        this.planId = node.findString("plan-id");
        this.processorAuthorizationCode = node.findString("processor-authorization-code");
        this.processorResponseCode = node.findString("processor-response-code");
        this.processorResponseText = node.findString("processor-response-text");
        this.processorResponseType = EnumUtils.findByName(ProcessorResponseType.class, node.findString("processor-response-type"), ProcessorResponseType.UNRECOGNIZED);
        this.processorSettlementResponseCode = node.findString("processor-settlement-response-code");
        this.processorSettlementResponseText = node.findString("processor-settlement-response-text");
        this.additionalProcessorResponse = node.findString("additional-processor-response");
        this.networkResponseCode = node.findString("network-response-code");
        this.networkResponseText = node.findString("network-response-text");
        this.voiceReferralNumber = node.findString("voice-referral-number");
        this.purchaseOrderNumber = node.findString("purchase-order-number");
        this.recurring = node.findBoolean("recurring");
        this.refundedTransactionId = node.findString("refunded-transaction-id");
        this.refundId = node.findString("refund-id");
        NodeWrapper riskDataNode = node.findFirst("risk-data");
        if (riskDataNode != null) {
            this.riskData = new RiskData(riskDataNode);
        }
        if ((threeDSecureInfoNode = node.findFirst("three-d-secure-info")) != null && !threeDSecureInfoNode.isBlank()) {
            this.threeDSecureInfo = new ThreeDSecureInfo(threeDSecureInfoNode);
        }
        this.serviceFeeAmount = node.findBigDecimal("service-fee-amount");
        this.settlementBatchId = node.findString("settlement-batch-id");
        NodeWrapper shippingAddressNode = node.findFirst("shipping");
        if (shippingAddressNode != null) {
            this.shippingAddress = new Address(shippingAddressNode);
        }
        this.status = EnumUtils.findByName(Status.class, node.findString("status"), Status.UNRECOGNIZED);
        NodeWrapper subscriptionNode = node.findFirst("subscription");
        if (subscriptionNode != null) {
            this.subscriptionDetails = new SubscriptionDetails(subscriptionNode);
            this.subscription = new Subscription(subscriptionNode);
        }
        this.subscriptionId = node.findString("subscription-id");
        this.taxAmount = node.findBigDecimal("tax-amount");
        this.taxExempt = node.findBoolean("tax-exempt");
        this.shippingAmount = node.findBigDecimal("shipping-amount");
        this.discountAmount = node.findBigDecimal("discount-amount");
        this.shipsFromPostalCode = node.findString("ships-from-postal-code");
        this.type = EnumUtils.findByName(Type.class, node.findString("type"), Type.UNRECOGNIZED);
        this.updatedAt = node.findDateTime("updated-at");
        this.refundIds = new ArrayList<String>();
        for (NodeWrapper refundIdNode : node.findAll("refund-ids/item")) {
            this.refundIds.add(refundIdNode.findString("."));
        }
        this.retrievalReferenceNumber = node.findString("retrieval-reference-number");
        this.statusHistory = new ArrayList<StatusEvent>();
        for (NodeWrapper statusNode : node.findAll("status-history/status-event")) {
            this.statusHistory.add(new StatusEvent(statusNode));
        }
        this.addOns = new ArrayList<AddOn>();
        for (NodeWrapper addOnResponse : node.findAll("add-ons/add-on")) {
            this.addOns.add(new AddOn(addOnResponse));
        }
        this.discounts = new ArrayList<Discount>();
        for (NodeWrapper discountResponse : node.findAll("discounts/discount")) {
            this.discounts.add(new Discount(discountResponse));
        }
        this.disputes = new ArrayList<Dispute>();
        for (NodeWrapper dispute : node.findAll("disputes/dispute")) {
            this.disputes.add(new Dispute(dispute));
        }
        this.paymentInstrumentType = node.findString("payment-instrument-type");
        this.authorizedTransactionId = node.findString("authorized-transaction-id");
        this.partialSettlementTransactionIds = new ArrayList<String>();
        for (NodeWrapper partialSettlementTransactionIdNode : node.findAll("partial-settlement-transaction-ids/*")) {
            this.partialSettlementTransactionIds.add(partialSettlementTransactionIdNode.findString("."));
        }
        this.authorizationAdjustments = new ArrayList<AuthorizationAdjustment>();
        for (NodeWrapper authorizationAdjustmentNode : node.findAll("authorization-adjustments/authorization-adjustment")) {
            this.authorizationAdjustments.add(new AuthorizationAdjustment(authorizationAdjustmentNode));
        }
        NodeWrapper facilitatedDetailsNode = node.findFirst("facilitated-details");
        if (facilitatedDetailsNode != null) {
            this.facilitatedDetails = new FacilitatedDetails(facilitatedDetailsNode);
        }
        if ((facilitatorDetailsNode = node.findFirst("facilitator-details")) != null) {
            this.facilitatorDetails = new FacilitatorDetails(facilitatorDetailsNode);
        }
        this.networkTransactionId = node.findString("network-transaction-id");
        this.authorizationExpiresAt = node.findDateTime("authorization-expires-at");
    }

    public List<AddOn> getAddOns() {
        return this.addOns;
    }

    public BigDecimal getAmount() {
        return this.amount;
    }

    public String getAvsErrorResponseCode() {
        return this.avsErrorResponseCode;
    }

    public String getAvsPostalCodeResponseCode() {
        return this.avsPostalCodeResponseCode;
    }

    public String getAvsStreetAddressResponseCode() {
        return this.avsStreetAddressResponseCode;
    }

    public Address getBillingAddress() {
        return this.billingAddress;
    }

    public String getChannel() {
        return this.channel;
    }

    public Calendar getCreatedAt() {
        return this.createdAt;
    }

    public CreditCard getCreditCard() {
        return this.creditCard;
    }

    public String getCurrencyIsoCode() {
        return this.currencyIsoCode;
    }

    public Customer getCustomer() {
        return this.customer;
    }

    public Map<String, String> getCustomFields() {
        return this.customFields;
    }

    public String getCvvResponseCode() {
        return this.cvvResponseCode;
    }

    public DisbursementDetails getDisbursementDetails() {
        return this.disbursementDetails;
    }

    public List<Dispute> getDisputes() {
        return this.disputes;
    }

    public Descriptor getDescriptor() {
        return this.descriptor;
    }

    public List<Discount> getDiscounts() {
        return this.discounts;
    }

    public EscrowStatus getEscrowStatus() {
        return this.escrowStatus;
    }

    public GatewayRejectionReason getGatewayRejectionReason() {
        return this.gatewayRejectionReason;
    }

    public String getId() {
        return this.id;
    }

    public String getGraphQLId() {
        return this.graphqlId;
    }

    public String getMerchantAccountId() {
        return this.merchantAccountId;
    }

    public String getOrderId() {
        return this.orderId;
    }

    public PayPalDetails getPayPalDetails() {
        return this.paypalDetails;
    }

    public PayPalHereDetails getPayPalHereDetails() {
        return this.paypalHereDetails;
    }

    public ApplePayDetails getApplePayDetails() {
        return this.applePayDetails;
    }

    public AndroidPayDetails getAndroidPayDetails() {
        return this.androidPayDetails;
    }

    public AmexExpressCheckoutDetails getAmexExpressCheckoutDetails() {
        return this.amexExpressCheckoutDetails;
    }

    public VenmoAccountDetails getVenmoAccountDetails() {
        return this.venmoAccountDetails;
    }

    public UsBankAccountDetails getUsBankAccountDetails() {
        return this.usBankAccountDetails;
    }

    public LocalPaymentDetails getLocalPaymentDetails() {
        return this.localPaymentDetails;
    }

    public VisaCheckoutCardDetails getVisaCheckoutCardDetails() {
        return this.visaCheckoutCardDetails;
    }

    public MasterpassCardDetails getMasterpassCardDetails() {
        return this.masterpassCardDetails;
    }

    public SamsungPayCardDetails getSamsungPayCardDetails() {
        return this.samsungPayCardDetails;
    }

    public CustomActionsPaymentMethodDetails getCustomActionsPaymentMethodDetails() {
        return this.customActionsPaymentMethodDetails;
    }

    public String getPlanId() {
        return this.planId;
    }

    public String getProcessorAuthorizationCode() {
        return this.processorAuthorizationCode;
    }

    public String getProcessorResponseCode() {
        return this.processorResponseCode;
    }

    public String getProcessorResponseText() {
        return this.processorResponseText;
    }

    public ProcessorResponseType getProcessorResponseType() {
        return this.processorResponseType;
    }

    public String getProcessorSettlementResponseCode() {
        return this.processorSettlementResponseCode;
    }

    public String getProcessorSettlementResponseText() {
        return this.processorSettlementResponseText;
    }

    public String getAdditionalProcessorResponse() {
        return this.additionalProcessorResponse;
    }

    public String getNetworkResponseCode() {
        return this.networkResponseCode;
    }

    public String getNetworkResponseText() {
        return this.networkResponseText;
    }

    public String getVoiceReferralNumber() {
        return this.voiceReferralNumber;
    }

    public String getPurchaseOrderNumber() {
        return this.purchaseOrderNumber;
    }

    public String getRefundedTransactionId() {
        return this.refundedTransactionId;
    }

    public List<String> getRefundIds() {
        return this.refundIds;
    }

    public String getRetrievalReferenceNumber() {
        return this.retrievalReferenceNumber;
    }

    public RiskData getRiskData() {
        return this.riskData;
    }

    public ThreeDSecureInfo getThreeDSecureInfo() {
        return this.threeDSecureInfo;
    }

    public BigDecimal getServiceFeeAmount() {
        return this.serviceFeeAmount;
    }

    public String getSettlementBatchId() {
        return this.settlementBatchId;
    }

    public Address getShippingAddress() {
        return this.shippingAddress;
    }

    public Status getStatus() {
        return this.status;
    }

    public List<StatusEvent> getStatusHistory() {
        return this.statusHistory;
    }

    public String getSubscriptionId() {
        return this.subscriptionId;
    }

    public SubscriptionDetails getSubscriptionDetails() {
        return this.subscriptionDetails;
    }

    public BigDecimal getTaxAmount() {
        return this.taxAmount;
    }

    public BigDecimal getShippingAmount() {
        return this.shippingAmount;
    }

    public BigDecimal getDiscountAmount() {
        return this.discountAmount;
    }

    public String getShipsFromPostalCode() {
        return this.shipsFromPostalCode;
    }

    public Type getType() {
        return this.type;
    }

    public Boolean getRecurring() {
        return this.recurring;
    }

    public Calendar getUpdatedAt() {
        return this.updatedAt;
    }

    public Address getVaultBillingAddress(BraintreeGateway gateway) {
        if (this.billingAddress.getId() == null) {
            return null;
        }
        return gateway.address().find(this.customer.getId(), this.billingAddress.getId());
    }

    public CreditCard getVaultCreditCard(BraintreeGateway gateway) {
        if (this.creditCard.getToken() == null) {
            return null;
        }
        return gateway.creditCard().find(this.creditCard.getToken());
    }

    public Customer getVaultCustomer(BraintreeGateway gateway) {
        if (this.customer.getId() == null) {
            return null;
        }
        return gateway.customer().find(this.customer.getId());
    }

    public Address getVaultShippingAddress(BraintreeGateway gateway) {
        if (this.shippingAddress.getId() == null) {
            return null;
        }
        return gateway.address().find(this.customer.getId(), this.shippingAddress.getId());
    }

    public Boolean isTaxExempt() {
        return this.taxExempt;
    }

    public String getPaymentInstrumentType() {
        return this.paymentInstrumentType;
    }

    public String getAuthorizedTransactionId() {
        return this.authorizedTransactionId;
    }

    public List<String> getPartialSettlementTransactionIds() {
        return this.partialSettlementTransactionIds;
    }

    public List<AuthorizationAdjustment> getAuthorizationAdjustments() {
        return this.authorizationAdjustments;
    }

    public FacilitatedDetails getFacilitatedDetails() {
        return this.facilitatedDetails;
    }

    public FacilitatorDetails getFacilitatorDetails() {
        return this.facilitatorDetails;
    }

    public List<TransactionLineItem> getLineItems(BraintreeGateway gateway) {
        return gateway.transactionLineItem().findAll(this.id);
    }

    public String getNetworkTransactionId() {
        return this.networkTransactionId;
    }

    public Calendar getAuthorizationExpiresAt() {
        return this.authorizationExpiresAt;
    }

    public static enum Type {
        CREDIT("credit"),
        SALE("sale"),
        UNRECOGNIZED("unrecognized");

        private final String name;

        private Type(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }

    public static enum IndustryType {
        LODGING("lodging"),
        TRAVEL_CRUISE("travel_cruise"),
        TRAVEL_FLIGHT("travel_flight");

        private final String name;

        private IndustryType(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }

    public static enum Status {
        AUTHORIZATION_EXPIRED,
        AUTHORIZED,
        AUTHORIZING,
        FAILED,
        GATEWAY_REJECTED,
        PROCESSOR_DECLINED,
        SETTLED,
        SETTLEMENT_CONFIRMED,
        SETTLEMENT_DECLINED,
        SETTLEMENT_PENDING,
        SETTLING,
        SUBMITTED_FOR_SETTLEMENT,
        UNRECOGNIZED,
        VOIDED;

    }

    public static enum Source {
        API("api"),
        CONTROL_PANEL("control_panel"),
        RECURRING("recurring"),
        UNRECOGNIZED("unrecognized");

        private final String name;

        private Source(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }

    public static enum GatewayRejectionReason {
        APPLICATION_INCOMPLETE("application_incomplete"),
        AVS("avs"),
        AVS_AND_CVV("avs_and_cvv"),
        CVV("cvv"),
        DUPLICATE("duplicate"),
        FRAUD("fraud"),
        THREE_D_SECURE("three_d_secure"),
        TOKEN_ISSUANCE("token_issuance"),
        UNRECOGNIZED("unrecognized");

        private final String name;

        private GatewayRejectionReason(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }

    public static enum EscrowStatus {
        HELD,
        HOLD_PENDING,
        RELEASE_PENDING,
        RELEASED,
        REFUNDED,
        UNRECOGNIZED;

    }

    public static enum CreatedUsing {
        FULL_INFORMATION("full_information"),
        TOKEN("token"),
        UNRECOGNIZED("unrecognized");

        private final String name;

        private CreatedUsing(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

