/*
 * Decompiled with CFR 0.152.
 */
package com.braintreegateway;

import com.braintreegateway.Configuration;
import com.braintreegateway.Result;
import com.braintreegateway.TransactionLevelFeeReport;
import com.braintreegateway.TransactionLevelFeeReportRequest;
import com.braintreegateway.ValidationErrors;
import com.braintreegateway.util.GraphQLClient;
import com.braintreegateway.util.Http;
import java.io.IOException;
import java.text.ParseException;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReportGateway {
    private Http http;
    private GraphQLClient graphQLClient;
    private Configuration configuration;
    private static final String TRANSACTION_LEVEL_FEES_QUERY = "query TransactionLevelFeeReport($date: Date!, $merchantAccountId: ID) {    report {        transactionLevelFees(date: $date, merchantAccountId: $merchantAccountId) {            url        }    }}";

    public ReportGateway(Http http, GraphQLClient graphQLClient, Configuration configuration) {
        this.http = http;
        this.graphQLClient = graphQLClient;
        this.configuration = configuration;
    }

    public Result<TransactionLevelFeeReport> transactionLevelFees(TransactionLevelFeeReportRequest request) throws IOException, ParseException {
        String url = null;
        Map<String, Object> response = this.graphQLClient.query(TRANSACTION_LEVEL_FEES_QUERY, request);
        ValidationErrors errors = GraphQLClient.getErrors(response);
        if (errors != null) {
            return new Result<TransactionLevelFeeReport>(errors);
        }
        try {
            Map data = (Map)response.get("data");
            Map report = (Map)data.get("report");
            Map transactionLevelFees = (Map)report.get("transactionLevelFees");
            url = (String)transactionLevelFees.get("url");
        }
        catch (NullPointerException e) {
            url = null;
        }
        return new Result<TransactionLevelFeeReport>(new TransactionLevelFeeReport(url));
    }
}

