/*
 * Decompiled with CFR 0.152.
 */
package com.braintreegateway;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Map;
import java.util.TimeZone;
import org.apache.commons.csv.CSVRecord;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransactionLevelFeeReportRow {
    private String merchantAccountId;
    private String transactionId;
    private String originalTransactionId;
    private String transactionType;
    private String presentmentCurrency;
    private String settlementCurrency;
    private BigDecimal settlementAmount;
    private Calendar settlementDate;
    private Calendar disbursementDate;
    private String paymentInstrument;
    private String cardBrand;
    private String cardType;
    private String first6OfCreditCard;
    private String issuingBank;
    private BigDecimal refundedAmount;
    private BigDecimal exchangeRate;
    private String orderId;
    private String acquirerReferenceNumber;
    private String cardIssuingCountry;
    private BigDecimal discount;
    private BigDecimal discountCredit;
    private BigDecimal perTransactionFee;
    private BigDecimal perTransactionFeeCredit;
    private String interchangeDescription;
    private String interchangeCurrency;
    private BigDecimal estInterchangeRate;
    private BigDecimal estInterchangeRateCredit;
    private BigDecimal estInterchangeFixed;
    private BigDecimal estInterchangeFixedCredit;
    private BigDecimal estInterchangeTotalAmount;
    private BigDecimal estTotalFeeAmount;
    private BigDecimal braintreeTotalAmount;
    private BigDecimal originalSaleAmount;
    private String refundType;
    private BigDecimal multicurrencyFeeAmount;
    private BigDecimal multicurrencyFeeCredit;
    private BigDecimal totalFeeAmount;

    public TransactionLevelFeeReportRow(CSVRecord record) throws ParseException {
        Map recordMap = record.toMap();
        this.merchantAccountId = this.getFirstOf(recordMap, "Merchant Account ID", "Merchant Account Token");
        this.transactionId = (String)recordMap.get("Transaction ID");
        this.originalTransactionId = (String)recordMap.get("Original Transaction ID");
        this.transactionType = (String)recordMap.get("Transaction Type");
        this.presentmentCurrency = (String)recordMap.get("Presentment Currency");
        this.settlementCurrency = (String)recordMap.get("Settlement Currency");
        this.settlementAmount = new BigDecimal((String)recordMap.get("Settlement Amount"));
        this.settlementDate = this.parseDate((String)recordMap.get("Settlement Date"));
        this.disbursementDate = this.parseDate((String)recordMap.get("Disbursement Date"));
        this.paymentInstrument = (String)recordMap.get("Payment Instrument");
        this.cardBrand = (String)recordMap.get("Card Brand");
        this.cardType = (String)recordMap.get("Card Type");
        this.first6OfCreditCard = (String)recordMap.get("First 6 of CC");
        this.issuingBank = (String)recordMap.get("Issuing Bank");
        this.refundedAmount = new BigDecimal((String)recordMap.get("Refunded Amount"));
        this.exchangeRate = new BigDecimal((String)recordMap.get("Exchange Rate"));
        this.orderId = (String)recordMap.get("Order ID");
        this.acquirerReferenceNumber = (String)recordMap.get("Acquirer Reference Number");
        this.cardIssuingCountry = (String)recordMap.get("Card Issuing Country");
        this.discount = new BigDecimal((String)recordMap.get("Discount"));
        this.discountCredit = new BigDecimal((String)recordMap.get("Discount Credit"));
        this.perTransactionFee = new BigDecimal((String)recordMap.get("Per Transaction Fee"));
        this.perTransactionFeeCredit = new BigDecimal((String)recordMap.get("Per Transaction Fee Credit"));
        this.braintreeTotalAmount = this.maybeParseBigDecimal((String)recordMap.get("Braintree Total Amount"));
        this.interchangeDescription = (String)recordMap.get("Interchange Description");
        this.interchangeCurrency = (String)recordMap.get("Interchange Currency");
        this.estInterchangeRate = this.maybeParseBigDecimal((String)recordMap.get("Est. Interchange Rate"));
        this.estInterchangeRateCredit = this.maybeParseBigDecimal((String)recordMap.get("Est. Interchange Rate Credit"));
        this.estInterchangeFixed = this.maybeParseBigDecimal((String)recordMap.get("Est. Interchange Fixed"));
        this.estInterchangeFixedCredit = this.maybeParseBigDecimal((String)recordMap.get("Est. Interchange Fixed Credit"));
        this.estInterchangeTotalAmount = this.maybeParseBigDecimal((String)recordMap.get("Est. Interchange Total Amount"));
        this.estTotalFeeAmount = this.maybeParseBigDecimal((String)recordMap.get("Est. Total Fee Amount"));
        this.originalSaleAmount = this.maybeParseBigDecimal((String)recordMap.get("Original Sale Amount"));
        this.refundType = (String)recordMap.get("Refund Type");
        this.multicurrencyFeeAmount = this.maybeParseBigDecimal((String)recordMap.get("Multicurrency Fee Amount"));
        this.multicurrencyFeeCredit = this.maybeParseBigDecimal((String)recordMap.get("Multicurrency Fee Credit"));
        this.totalFeeAmount = this.maybeParseBigDecimal((String)recordMap.get("Total Fee Amount"));
    }

    public String getMerchantAccountId() {
        return this.merchantAccountId;
    }

    public String getTransactionId() {
        return this.transactionId;
    }

    public String getOriginalTransactionId() {
        return this.originalTransactionId;
    }

    public String getTransactionType() {
        return this.transactionType;
    }

    public String getPresentmentCurrency() {
        return this.presentmentCurrency;
    }

    public String getSettlementCurrency() {
        return this.settlementCurrency;
    }

    public BigDecimal getSettlementAmount() {
        return this.settlementAmount;
    }

    public Calendar getSettlementDate() {
        return this.settlementDate;
    }

    public Calendar getDisbursementDate() {
        return this.disbursementDate;
    }

    public String getPaymentInstrument() {
        return this.paymentInstrument;
    }

    public String getCardBrand() {
        return this.cardBrand;
    }

    public String getCardType() {
        return this.cardType;
    }

    public String getFirst6OfCreditCard() {
        return this.first6OfCreditCard;
    }

    public String getIssuingBank() {
        return this.issuingBank;
    }

    public BigDecimal getRefundedAmount() {
        return this.refundedAmount;
    }

    public BigDecimal getExchangeRate() {
        return this.exchangeRate;
    }

    public String getOrderId() {
        return this.orderId;
    }

    public String getAcquirerReferenceNumber() {
        return this.acquirerReferenceNumber;
    }

    public String getCardIssuingCountry() {
        return this.cardIssuingCountry;
    }

    public BigDecimal getDiscount() {
        return this.discount;
    }

    public BigDecimal getDiscountCredit() {
        return this.discountCredit;
    }

    public BigDecimal getPerTransactionFee() {
        return this.perTransactionFee;
    }

    public BigDecimal getPerTransactionFeeCredit() {
        return this.perTransactionFeeCredit;
    }

    public BigDecimal getBraintreeTotalAmount() {
        return this.braintreeTotalAmount;
    }

    public String getInterchangeDescription() {
        return this.interchangeDescription;
    }

    public String getInterchangeCurrency() {
        return this.interchangeCurrency;
    }

    public BigDecimal getEstInterchangeRate() {
        return this.estInterchangeRate;
    }

    public BigDecimal getEstInterchangeRateCredit() {
        return this.estInterchangeRateCredit;
    }

    public BigDecimal getEstInterchangeFixed() {
        return this.estInterchangeFixed;
    }

    public BigDecimal getEstInterchangeFixedCredit() {
        return this.estInterchangeFixedCredit;
    }

    public BigDecimal getEstInterchangeTotalAmount() {
        return this.estInterchangeTotalAmount;
    }

    public BigDecimal getEstTotalFeeAmount() {
        return this.estTotalFeeAmount;
    }

    public BigDecimal getOriginalSaleAmount() {
        return this.originalSaleAmount;
    }

    public String getRefundType() {
        return this.refundType;
    }

    public BigDecimal getMulticurrencyFeeAmount() {
        return this.multicurrencyFeeAmount;
    }

    public BigDecimal getMulticurrencyFeeCredit() {
        return this.multicurrencyFeeCredit;
    }

    public BigDecimal getTotalFeeAmount() {
        return this.totalFeeAmount;
    }

    private Calendar parseDate(String dateString) throws ParseException {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        calendar.setTime(dateFormat.parse(dateString));
        return calendar;
    }

    private BigDecimal maybeParseBigDecimal(String numberString) throws NumberFormatException {
        if (numberString == null || numberString.equals("")) {
            return null;
        }
        return new BigDecimal(numberString);
    }

    private String getFirstOf(Map<String, String> map, String ... keys) {
        for (String key : keys) {
            if (!map.containsKey(key)) continue;
            return map.get(key);
        }
        return null;
    }
}

