/*
 * Decompiled with CFR 0.152.
 */
package com.braintreegateway;

import com.braintreegateway.AchMandate;
import com.braintreegateway.PaymentMethod;
import com.braintreegateway.Subscription;
import com.braintreegateway.util.NodeWrapper;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UsBankAccount
implements PaymentMethod {
    private String routingNumber;
    private String last4;
    private String accountType;
    private String accountHolderName;
    private String token;
    private String imageUrl;
    private String bankName;
    private List<Subscription> subscriptions;
    private String customerId;
    private Boolean isDefault;
    private AchMandate achMandate;

    public UsBankAccount(NodeWrapper node) {
        this.routingNumber = node.findString("routing-number");
        this.last4 = node.findString("last-4");
        this.accountType = node.findString("account-type");
        this.accountHolderName = node.findString("account-holder-name");
        this.token = node.findString("token");
        this.imageUrl = node.findString("image-url");
        this.bankName = node.findString("bank-name");
        this.subscriptions = new ArrayList<Subscription>();
        for (NodeWrapper subscriptionResponse : node.findAll("subscriptions/subscription")) {
            this.subscriptions.add(new Subscription(subscriptionResponse));
        }
        this.customerId = node.findString("customer-id");
        this.isDefault = node.findBoolean("default");
        this.achMandate = new AchMandate(node.findFirst("ach-mandate"));
    }

    public String getRoutingNumber() {
        return this.routingNumber;
    }

    public String getLast4() {
        return this.last4;
    }

    public String getAccountType() {
        return this.accountType;
    }

    public String getAccountHolderName() {
        return this.accountHolderName;
    }

    @Override
    public String getToken() {
        return this.token;
    }

    @Override
    public String getImageUrl() {
        return this.imageUrl;
    }

    public String getBankName() {
        return this.bankName;
    }

    @Override
    public boolean isDefault() {
        return this.isDefault;
    }

    public AchMandate getAchMandate() {
        return this.achMandate;
    }

    @Override
    public String getCustomerId() {
        return this.customerId;
    }

    @Override
    public List<Subscription> getSubscriptions() {
        return this.subscriptions;
    }
}

