/*
 * Decompiled with CFR 0.152.
 */
package com.braintreegateway;

import com.braintreegateway.OAuthConnectUrlBusinessRequest;
import com.braintreegateway.OAuthConnectUrlUserRequest;
import com.braintreegateway.Request;
import com.braintreegateway.RequestBuilder;

public class OAuthConnectUrlRequest
extends Request {
    private String merchantId;
    private String scope;
    private String clientId;
    private String state;
    private String redirectUri;
    private String landingPage;
    private Boolean loginOnly;
    private String[] paymentMethods = new String[0];
    private OAuthConnectUrlUserRequest user;
    private OAuthConnectUrlBusinessRequest business;

    public OAuthConnectUrlRequest merchantId(String merchantId) {
        this.merchantId = merchantId;
        return this;
    }

    public OAuthConnectUrlRequest scope(String scope) {
        this.scope = scope;
        return this;
    }

    public OAuthConnectUrlRequest clientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    public OAuthConnectUrlRequest state(String state) {
        this.state = state;
        return this;
    }

    public OAuthConnectUrlRequest landingPage(String landingPage) {
        this.landingPage = landingPage;
        return this;
    }

    public OAuthConnectUrlRequest loginOnly(Boolean loginOnly) {
        this.loginOnly = loginOnly;
        return this;
    }

    public OAuthConnectUrlRequest redirectUri(String redirectUri) {
        this.redirectUri = redirectUri;
        return this;
    }

    public OAuthConnectUrlRequest paymentMethods(String[] paymentMethods) {
        this.paymentMethods = paymentMethods;
        return this;
    }

    public OAuthConnectUrlUserRequest user() {
        this.user = new OAuthConnectUrlUserRequest(this);
        return this.user;
    }

    public OAuthConnectUrlBusinessRequest business() {
        this.business = new OAuthConnectUrlBusinessRequest(this);
        return this.business;
    }

    public String toQueryString() {
        RequestBuilder builder = new RequestBuilder("").addTopLevelElement("merchantId", this.merchantId).addTopLevelElement("scope", this.scope).addTopLevelElement("clientId", this.clientId).addTopLevelElement("state", this.state).addTopLevelElement("redirectUri", this.redirectUri).addTopLevelElement("landingPage", this.landingPage).addTopLevelElement("loginOnly", String.valueOf(this.loginOnly));
        for (String paymentMethod : this.paymentMethods) {
            builder.addTopLevelElement("payment_methods[]", paymentMethod);
        }
        builder.addElement("user", this.user).addElement("business", this.business);
        return builder.toQueryString();
    }
}

