/*
 * Decompiled with CFR 0.152.
 */
package com.braintreegateway.util;

import com.braintreegateway.Configuration;
import com.braintreegateway.Request;
import com.braintreegateway.exceptions.AuthenticationException;
import com.braintreegateway.exceptions.AuthorizationException;
import com.braintreegateway.exceptions.DownForMaintenanceException;
import com.braintreegateway.exceptions.NotFoundException;
import com.braintreegateway.exceptions.ServerException;
import com.braintreegateway.exceptions.TimeoutException;
import com.braintreegateway.exceptions.TooManyRequestsException;
import com.braintreegateway.exceptions.UnexpectedException;
import com.braintreegateway.exceptions.UpgradeRequiredException;
import com.braintreegateway.org.apache.commons.codec.binary.Base64;
import com.braintreegateway.util.NodeWrapper;
import com.braintreegateway.util.NodeWrapperFactory;
import com.braintreegateway.util.StringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManagerFactory;
import org.json.JSONObject;

public class Http {
    public static final String LINE_FEED = "\r\n";
    private volatile SSLSocketFactory sslSocketFactory;
    private Configuration configuration;

    public Http(Configuration configuration) {
        this.configuration = configuration;
    }

    public NodeWrapper delete(String url) {
        return this.httpRequest(RequestMethod.DELETE, url);
    }

    public NodeWrapper get(String url) {
        return this.httpRequest(RequestMethod.GET, url);
    }

    public NodeWrapper post(String url) {
        return this.httpRequest(RequestMethod.POST, url, null, null);
    }

    public NodeWrapper post(String url, Request request) {
        return this.httpRequest(RequestMethod.POST, url, request.toXML(), null);
    }

    public NodeWrapper post(String url, String request) {
        return this.httpRequest(RequestMethod.POST, url, request, null);
    }

    public NodeWrapper postMultipart(String url, String request, File file) {
        return this.httpRequest(RequestMethod.POST, url, request, file);
    }

    public NodeWrapper put(String url) {
        return this.httpRequest(RequestMethod.PUT, url, null, null);
    }

    public NodeWrapper put(String url, Request request) {
        return this.httpRequest(RequestMethod.PUT, url, request.toXML(), null);
    }

    private NodeWrapper httpRequest(RequestMethod requestMethod, String url) {
        return this.httpRequest(requestMethod, url, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NodeWrapper httpRequest(RequestMethod requestMethod, String url, String postBody, File file) {
        HttpURLConnection connection = null;
        NodeWrapper nodeWrapper = null;
        String boundary = "boundary" + System.currentTimeMillis();
        String contentType = file == null ? "application/xml" : "multipart/form-data; boundary=" + boundary;
        try {
            connection = this.buildConnection(requestMethod, url, contentType);
            Logger logger = this.configuration.getLogger();
            if (postBody != null) {
                logger.log(Level.FINE, this.formatSanitizeBodyForLog(postBody));
            }
            if (connection instanceof HttpsURLConnection) {
                ((HttpsURLConnection)connection).setSSLSocketFactory(this.getSSLSocketFactory());
            }
            if (postBody != null) {
                OutputStream outputStream = null;
                try {
                    outputStream = connection.getOutputStream();
                    PrintWriter writer = new PrintWriter((Writer)new OutputStreamWriter(outputStream, "UTF-8"), true);
                    if (file == null) {
                        outputStream.write(postBody.getBytes("UTF-8"));
                    } else {
                        JSONObject obj = new JSONObject(postBody);
                        Iterator keys = obj.keys();
                        while (keys.hasNext()) {
                            String key = (String)keys.next();
                            this.addFormField(key, (String)obj.get(key), writer, boundary);
                        }
                        this.addFilePart("file", file, writer, outputStream, boundary);
                        this.finish(writer, boundary);
                    }
                }
                finally {
                    if (outputStream != null) {
                        outputStream.close();
                    }
                }
            }
            Http.throwExceptionIfErrorStatusCode(connection.getResponseCode(), null);
            InputStream responseStream = null;
            try {
                InputStream inputStream = responseStream = connection.getResponseCode() == 422 ? connection.getErrorStream() : connection.getInputStream();
                if ("gzip".equalsIgnoreCase(connection.getContentEncoding())) {
                    responseStream = new GZIPInputStream(responseStream);
                }
                String xml = StringUtils.inputStreamToString(responseStream);
                logger.log(Level.INFO, "[Braintree] [{0}]] {1} {2}", new Object[]{this.getCurrentTime(), requestMethod.toString(), url});
                logger.log(Level.FINE, "[Braintree] [{0}] {1} {2} {3}", new Object[]{this.getCurrentTime(), requestMethod.toString(), url, connection.getResponseCode()});
                if (xml != null) {
                    logger.log(Level.FINE, this.formatSanitizeBodyForLog(xml));
                }
                if (xml == null || xml.trim().equals("")) {
                    NodeWrapper nodeWrapper2 = null;
                    return nodeWrapper2;
                }
                nodeWrapper = NodeWrapperFactory.instance.create(xml);
            }
            finally {
                if (responseStream != null) {
                    responseStream.close();
                }
            }
        }
        catch (SocketTimeoutException e) {
            throw new TimeoutException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new UnexpectedException(e.getMessage(), e);
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
        return nodeWrapper;
    }

    private void addFormField(String key, String value, PrintWriter writer, String boundary) {
        writer.append("--" + boundary).append(LINE_FEED);
        writer.append("Content-Disposition: form-data; name=\"" + key + "\"").append(LINE_FEED);
        writer.append(LINE_FEED);
        writer.append(value).append(LINE_FEED);
        writer.flush();
    }

    private void addFilePart(String fieldName, File uploadFile, PrintWriter writer, OutputStream outputStream, String boundary) throws IOException {
        int bytesRead;
        String filename = uploadFile.getName();
        writer.append("--" + boundary).append(LINE_FEED);
        writer.append("Content-Disposition: form-data; name=\"" + fieldName + "\"; filename=\"" + filename + "\"").append(LINE_FEED);
        writer.append("Content-Type: " + URLConnection.guessContentTypeFromName(filename)).append(LINE_FEED);
        writer.append(LINE_FEED);
        writer.flush();
        FileInputStream inputStream = new FileInputStream(uploadFile);
        byte[] buffer = new byte[4096];
        while ((bytesRead = inputStream.read(buffer)) != -1) {
            outputStream.write(buffer, 0, bytesRead);
        }
        outputStream.flush();
        inputStream.close();
        writer.append(LINE_FEED);
        writer.flush();
    }

    private void finish(PrintWriter writer, String boundary) {
        writer.append("--" + boundary + "--").append(LINE_FEED);
        writer.append(LINE_FEED).flush();
        writer.close();
    }

    private String formatSanitizeBodyForLog(String body) {
        if (body == null) {
            return body;
        }
        Pattern regex = Pattern.compile("(^)", 8);
        Matcher regexMatcher = regex.matcher(body);
        if (regexMatcher.find()) {
            body = regexMatcher.replaceAll("[Braintree] $1");
        }
        if ((regexMatcher = (regex = Pattern.compile("<number>(.{6}).+?(.{4})</number>")).matcher(body)).find()) {
            body = regexMatcher.replaceAll("<number>$1******$2</number>");
        }
        body = body.replaceAll("<cvv>.+?</cvv>", "<cvv>***</cvv>");
        return body;
    }

    private String getCurrentTime() {
        return new SimpleDateFormat("d/MMM/yyyy HH:mm:ss Z").format(new Date());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SSLSocketFactory getSSLSocketFactory() {
        if (this.sslSocketFactory == null) {
            Http http = this;
            synchronized (http) {
                if (this.sslSocketFactory == null) {
                    try {
                        KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
                        keyStore.load(null);
                        for (String certificateFilename : this.configuration.getEnvironment().certificateFilenames) {
                            CertificateFactory cf = CertificateFactory.getInstance("X.509");
                            InputStream certStream = null;
                            try {
                                certStream = Http.class.getClassLoader().getResourceAsStream(certificateFilename);
                                Collection<? extends Certificate> coll = cf.generateCertificates(certStream);
                                for (Certificate certificate : coll) {
                                    if (!(certificate instanceof X509Certificate)) continue;
                                    X509Certificate x509cert = (X509Certificate)certificate;
                                    Principal principal = x509cert.getSubjectDN();
                                    String subject = principal.getName();
                                    keyStore.setCertificateEntry(subject, certificate);
                                }
                            }
                            finally {
                                if (certStream != null) {
                                    certStream.close();
                                }
                            }
                        }
                        KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                        kmf.init(keyStore, null);
                        TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                        tmf.init(keyStore);
                        SSLContext sslContext = null;
                        try {
                            sslContext = SSLContext.getInstance("TLSv1.2");
                        }
                        catch (NoSuchAlgorithmException e) {
                            sslContext = SSLContext.getInstance("TLS");
                        }
                        sslContext.init(kmf.getKeyManagers(), tmf.getTrustManagers(), SecureRandom.getInstance("SHA1PRNG"));
                        this.sslSocketFactory = sslContext.getSocketFactory();
                    }
                    catch (Exception e) {
                        Logger logger = this.configuration.getLogger();
                        logger.log(Level.SEVERE, "SSL Verification failed. Error message: {0}", new Object[]{e.getMessage()});
                        throw new UnexpectedException(e.getMessage(), e);
                    }
                }
            }
        }
        return this.sslSocketFactory;
    }

    private HttpURLConnection buildConnection(RequestMethod requestMethod, String urlString, String contentType) throws IOException {
        URL url = new URL(this.configuration.getBaseURL() + urlString);
        int connectTimeout = this.configuration.getConnectTimeout();
        HttpURLConnection connection = this.configuration.usesProxy() != false ? (HttpURLConnection)url.openConnection(this.configuration.getProxy()) : (HttpURLConnection)url.openConnection();
        connection.setRequestMethod(requestMethod.toString());
        connection.addRequestProperty("Accept", "application/xml");
        connection.addRequestProperty("User-Agent", "Braintree Java " + Configuration.VERSION);
        connection.addRequestProperty("X-ApiVersion", Configuration.apiVersion());
        connection.addRequestProperty("Authorization", this.authorizationHeader());
        connection.addRequestProperty("Accept-Encoding", "gzip");
        connection.setRequestProperty("Content-Type", contentType);
        connection.setDoOutput(true);
        connection.setReadTimeout(this.configuration.getTimeout());
        if (connectTimeout > 0) {
            connection.setConnectTimeout(connectTimeout);
        }
        return connection;
    }

    public static void throwExceptionIfErrorStatusCode(int statusCode, String message) {
        String decodedMessage = null;
        if (message != null) {
            try {
                decodedMessage = URLDecoder.decode(message, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                Logger logger = Logger.getLogger("Braintree");
                logger.log(Level.FINEST, e.getMessage(), e.getStackTrace());
            }
        }
        if (Http.isErrorCode(statusCode)) {
            switch (statusCode) {
                case 401: {
                    throw new AuthenticationException();
                }
                case 403: {
                    throw new AuthorizationException(decodedMessage);
                }
                case 404: {
                    throw new NotFoundException();
                }
                case 426: {
                    throw new UpgradeRequiredException();
                }
                case 429: {
                    throw new TooManyRequestsException();
                }
                case 500: {
                    throw new ServerException();
                }
                case 503: {
                    throw new DownForMaintenanceException();
                }
            }
            throw new UnexpectedException("Unexpected HTTP_RESPONSE " + statusCode);
        }
    }

    private static boolean isErrorCode(int responseCode) {
        return responseCode != 200 && responseCode != 201 && responseCode != 422;
    }

    public String authorizationHeader() {
        if (this.configuration.isAccessToken().booleanValue()) {
            return "Bearer " + this.configuration.getAccessToken();
        }
        String credentials = this.configuration.isClientCredentials() != false ? this.configuration.getClientId() + ":" + this.configuration.getClientSecret() : this.configuration.getPublicKey() + ":" + this.configuration.getPrivateKey();
        return "Basic " + Base64.encodeBase64String(credentials.getBytes()).trim();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum RequestMethod {
        DELETE,
        GET,
        POST,
        PUT;

    }
}

