/*
 * Decompiled with CFR 0.152.
 */
package com.braintreegateway;

import com.braintreegateway.CredentialsParser;
import com.braintreegateway.Environment;
import com.braintreegateway.util.ClientLibraryProperties;
import java.net.InetSocketAddress;
import java.net.Proxy;

public class Configuration {
    private Environment environment;
    private String merchantId;
    private String privateKey;
    private String publicKey;
    private String clientId;
    private String clientSecret;
    private String accessToken;
    private Proxy proxy;
    public static final String VERSION = new ClientLibraryProperties().version();

    public static String apiVersion() {
        return "4";
    }

    public Configuration(Environment environment, String merchantId, String publicKey, String privateKey) {
        this.environment = environment;
        this.merchantId = merchantId;
        this.publicKey = publicKey;
        this.privateKey = privateKey;
    }

    public Configuration(String clientId, String clientSecret) {
        CredentialsParser parser = new CredentialsParser(clientId, clientSecret);
        this.environment = parser.environment;
        this.clientId = parser.clientId;
        this.clientSecret = parser.clientSecret;
    }

    public Configuration(String accessToken) {
        CredentialsParser parser = new CredentialsParser(accessToken);
        this.environment = parser.environment;
        this.merchantId = parser.merchantId;
        this.accessToken = parser.accessToken;
    }

    public Environment getEnvironment() {
        return this.environment;
    }

    public String getPrivateKey() {
        return this.privateKey;
    }

    public String getPublicKey() {
        return this.publicKey;
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public Boolean isClientCredentials() {
        return this.clientId != null;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public Boolean isAccessToken() {
        return this.accessToken != null;
    }

    public String getMerchantPath() {
        return "/merchants/" + this.merchantId;
    }

    public String getBaseURL() {
        return this.environment.baseURL;
    }

    public Boolean usesProxy() {
        return this.proxy != null;
    }

    public void setProxy(String url, Integer port) {
        this.proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(url, (int)port));
    }

    public Proxy getProxy() {
        return this.proxy;
    }
}

