/*
 * Decompiled with CFR 0.152.
 */
package com.braintreegateway;

import com.braintreegateway.Configuration;
import com.braintreegateway.WebhookNotification;
import com.braintreegateway.exceptions.InvalidChallengeException;
import com.braintreegateway.exceptions.InvalidSignatureException;
import com.braintreegateway.org.apache.commons.codec.binary.Base64;
import com.braintreegateway.util.Crypto;
import com.braintreegateway.util.NodeWrapper;
import com.braintreegateway.util.NodeWrapperFactory;
import com.braintreegateway.util.Sha1Hasher;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class WebhookNotificationGateway {
    private Configuration configuration;

    public WebhookNotificationGateway(Configuration configuration) {
        this.configuration = configuration;
    }

    public WebhookNotification parse(String signature, String payload) {
        Pattern p = Pattern.compile("[^A-Za-z0-9+=/\n]");
        Matcher m = p.matcher(payload);
        if (m.find()) {
            throw new InvalidSignatureException("payload contains illegal characters");
        }
        this.validateSignature(signature, payload);
        String xmlPayload = new String(Base64.decodeBase64(payload));
        NodeWrapper node = NodeWrapperFactory.instance.create(xmlPayload);
        return new WebhookNotification(node);
    }

    private void validateSignature(String signature, String payload) {
        String[] signaturePairs;
        String matchingSignature = null;
        for (String signaturePair : signaturePairs = signature.split("&")) {
            String[] candidatePair;
            if (signaturePair.indexOf("|") < 0 || !this.configuration.publicKey.equals((candidatePair = signaturePair.split("\\|"))[0])) continue;
            matchingSignature = candidatePair[1];
            break;
        }
        if (matchingSignature == null) {
            throw new InvalidSignatureException("no matching public key");
        }
        if (!this.matchSignature(payload, matchingSignature).booleanValue() && !this.matchSignature(payload + "\n", matchingSignature).booleanValue()) {
            throw new InvalidSignatureException("signature does not match payload - one has been modified");
        }
    }

    private Boolean matchSignature(String payload, String matchingSignature) {
        String computedSignature = new Sha1Hasher().hmacHash(this.configuration.privateKey, payload);
        return new Crypto().secureCompare(computedSignature, matchingSignature);
    }

    public String verify(String challenge) {
        if (!challenge.matches("^[a-f0-9]{20,32}$")) {
            throw new InvalidChallengeException("challenge contains non-hex characters");
        }
        return this.publicKeySignaturePair(challenge);
    }

    private String publicKeySignaturePair(String stringToSign) {
        return String.format("%s|%s", this.configuration.publicKey, new Sha1Hasher().hmacHash(this.configuration.privateKey, stringToSign));
    }
}

