/*
 * Decompiled with CFR 0.152.
 */
package com.braintreegateway;

import com.braintreegateway.CreditCardRequest;
import com.braintreegateway.Request;
import com.braintreegateway.RequestBuilder;
import com.braintreegateway.TransactionRequest;
import com.braintreegateway.TransparentRedirectGateway;
import java.util.HashMap;
import java.util.Map;

public class CustomerRequest
extends Request {
    private String deviceData;
    private String company;
    private String customerId;
    private String deviceSessionId;
    private String fraudMerchantId;
    private String email;
    private String fax;
    private String firstName;
    private String id;
    private String lastName;
    private String phone;
    private String website;
    private Map<String, String> customFields = new HashMap<String, String>();
    private CreditCardRequest creditCardRequest;
    private TransactionRequest parent;

    public CustomerRequest() {
    }

    public CustomerRequest(TransactionRequest transactionRequest) {
        this();
        this.parent = transactionRequest;
    }

    public CustomerRequest deviceData(String deviceData) {
        this.deviceData = deviceData;
        return this;
    }

    public CustomerRequest company(String company) {
        this.company = company;
        return this;
    }

    public CreditCardRequest creditCard() {
        this.creditCardRequest = new CreditCardRequest(this);
        return this.creditCardRequest;
    }

    public CustomerRequest customerId(String customerId) {
        this.customerId = customerId;
        return this;
    }

    public CustomerRequest customField(String apiName, String value) {
        this.customFields.put(apiName, value);
        return this;
    }

    public CustomerRequest deviceSessionId(String deviceSessionId) {
        this.deviceSessionId = deviceSessionId;
        return this;
    }

    public CustomerRequest fraudMerchantId(String fraudMerchantId) {
        this.fraudMerchantId = fraudMerchantId;
        return this;
    }

    public TransactionRequest done() {
        return this.parent;
    }

    public CustomerRequest email(String email) {
        this.email = email;
        return this;
    }

    public CustomerRequest fax(String fax) {
        this.fax = fax;
        return this;
    }

    public CustomerRequest firstName(String firstName) {
        this.firstName = firstName;
        return this;
    }

    public String getKind() {
        if (this.customerId == null) {
            return TransparentRedirectGateway.CREATE_CUSTOMER;
        }
        return TransparentRedirectGateway.UPDATE_CUSTOMER;
    }

    public CustomerRequest lastName(String lastName) {
        this.lastName = lastName;
        return this;
    }

    public CustomerRequest id(String id) {
        this.id = id;
        return this;
    }

    public String getId() {
        return this.id;
    }

    public CustomerRequest phone(String phone) {
        this.phone = phone;
        return this;
    }

    public CustomerRequest website(String website) {
        this.website = website;
        return this;
    }

    public String toXML() {
        return this.buildRequest("customer").toXML();
    }

    public String toQueryString() {
        return this.toQueryString("customer");
    }

    public String toQueryString(String root) {
        return this.buildRequest(root).addTopLevelElement("customerId", this.customerId).toQueryString();
    }

    protected RequestBuilder buildRequest(String root) {
        RequestBuilder builder = new RequestBuilder(root).addElement("deviceData", this.deviceData).addElement("company", this.company).addElement("email", this.email).addElement("fax", this.fax).addElement("firstName", this.firstName).addElement("id", this.id).addElement("lastName", this.lastName).addElement("phone", this.phone).addElement("website", this.website).addElement("creditCard", this.creditCardRequest);
        if (this.customFields.size() > 0) {
            builder.addElement("customFields", this.customFields);
        }
        return builder;
    }
}

