/*
 * Decompiled with CFR 0.152.
 */
package com.braintreegateway;

import com.braintreegateway.Configuration;
import com.braintreegateway.WebhookNotification;
import com.braintreegateway.org.apache.commons.codec.binary.Base64;
import com.braintreegateway.util.Crypto;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.TimeZone;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebhookTestingGateway {
    private Configuration configuration;
    private String[][] TYPE_DATETIME = new String[][]{{"type", "datetime"}};
    private String[][] TYPE_ARRAY = new String[][]{{"type", "array"}};
    private String[][] TYPE_SYMBOL = new String[][]{{"type", "symbol"}};

    public WebhookTestingGateway(Configuration configuration) {
        this.configuration = configuration;
    }

    private String buildPayload(WebhookNotification.Kind kind, String id) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        String timestamp = dateFormat.format(new Date());
        String payload = "<notification><timestamp type=\"datetime\">" + timestamp + "</timestamp><kind>" + (Object)((Object)kind) + "</kind><subject>" + this.subjectXml(kind, id) + "</subject></notification>";
        return Base64.encodeBase64String(payload.getBytes()).trim();
    }

    private String publicKeySignaturePair(String stringToSign) {
        return String.format("%s|%s", this.configuration.publicKey, new Crypto().hmacHash(this.configuration.privateKey, stringToSign));
    }

    public HashMap<String, String> sampleNotification(WebhookNotification.Kind kind, String id) {
        HashMap<String, String> response = new HashMap<String, String>();
        String payload = this.buildPayload(kind, id);
        response.put("payload", payload);
        response.put("signature", this.publicKeySignaturePair(payload));
        return response;
    }

    private String subjectXml(WebhookNotification.Kind kind, String id) {
        switch (kind) {
            case SUB_MERCHANT_ACCOUNT_APPROVED: {
                return this.merchantAccountXmlActive(id);
            }
            case SUB_MERCHANT_ACCOUNT_DECLINED: {
                return this.merchantAccountXmlDeclined(id);
            }
            case TRANSACTION_DISBURSED: {
                return this.transactionXml(id);
            }
            case PARTNER_USER_CREATED: {
                return this.partnerUserCreatedXml(id);
            }
            case PARTNER_USER_DELETED: {
                return this.partnerUserDeletedXml(id);
            }
            case PARTNER_MERCHANT_DECLINED: {
                return this.partnerMerchantDeclinedXml(id);
            }
        }
        return this.subscriptionXml(id);
    }

    private String merchantAccountXmlDeclined(String id) {
        return WebhookTestingGateway.node("api-error-response", WebhookTestingGateway.node("message", "Credit score is too low"), WebhookTestingGateway.node("errors", this.TYPE_ARRAY, WebhookTestingGateway.node("merchant-account", WebhookTestingGateway.node("errors", this.TYPE_ARRAY, WebhookTestingGateway.node("error", WebhookTestingGateway.node("code", "82621"), WebhookTestingGateway.node("message", "Credit score is too low"), WebhookTestingGateway.node("attribute", this.TYPE_SYMBOL, "base"))))), WebhookTestingGateway.node("merchant-account", WebhookTestingGateway.node("id", id), WebhookTestingGateway.node("status", "suspended"), WebhookTestingGateway.node("master-merchant-account", WebhookTestingGateway.node("id", "master_ma_for_" + id), WebhookTestingGateway.node("status", "suspended"))));
    }

    private String merchantAccountXmlActive(String id) {
        return WebhookTestingGateway.node("merchant-account", WebhookTestingGateway.node("id", id), WebhookTestingGateway.node("master-merchant-account", WebhookTestingGateway.node("id", id), WebhookTestingGateway.node("status", "active")), WebhookTestingGateway.node("status", "active"));
    }

    private String subscriptionXml(String id) {
        return WebhookTestingGateway.node("subscription", WebhookTestingGateway.node("id", id), WebhookTestingGateway.node("transactions", this.TYPE_ARRAY, new String[0]), WebhookTestingGateway.node("add_ons", this.TYPE_ARRAY, new String[0]), WebhookTestingGateway.node("discounts", this.TYPE_ARRAY, new String[0]));
    }

    private String transactionXml(String id) {
        return WebhookTestingGateway.node("transaction", WebhookTestingGateway.node("id", id), WebhookTestingGateway.node("amount", "100"), WebhookTestingGateway.node("disbursement-details", WebhookTestingGateway.node("disbursement-date", this.TYPE_DATETIME, "2013-07-09T18:23:29Z")), WebhookTestingGateway.node("billing", new String[0]), WebhookTestingGateway.node("credit-card", new String[0]), WebhookTestingGateway.node("customer", new String[0]), WebhookTestingGateway.node("descriptor", new String[0]), WebhookTestingGateway.node("shipping", new String[0]), WebhookTestingGateway.node("subscription", new String[0]));
    }

    private String partnerUserCreatedXml(String id) {
        return WebhookTestingGateway.node("partner-user", WebhookTestingGateway.node("partner-user-id", "abc123"), WebhookTestingGateway.node("merchant-public-id", "public_id"), WebhookTestingGateway.node("public-key", "public_key"), WebhookTestingGateway.node("private-key", "private_key"));
    }

    private String partnerUserDeletedXml(String id) {
        return WebhookTestingGateway.node("partner-user", WebhookTestingGateway.node("partner-user-id", "abc123"));
    }

    private String partnerMerchantDeclinedXml(String id) {
        return WebhookTestingGateway.node("partner-user", WebhookTestingGateway.node("partner-user-id", "abc123"));
    }

    private static String node(String name, String ... contents) {
        return WebhookTestingGateway.node(name, (String[][])null, contents);
    }

    private static String node(String name, String[][] attributes, String ... contents) {
        StringBuilder buffer = new StringBuilder();
        buffer.append('<').append(name);
        if (attributes != null) {
            for (String[] stringArray : attributes) {
                buffer.append(" ");
                buffer.append(stringArray[0]).append("=\"").append(stringArray[1]).append("\"");
            }
        }
        buffer.append('>');
        for (String[] stringArray : contents) {
            buffer.append((String)stringArray);
        }
        buffer.append("</").append(name).append('>');
        return buffer.toString();
    }
}

