/*
 * Decompiled with CFR 0.152.
 */
package com.braintreegateway;

import com.braintreegateway.Configuration;
import com.braintreegateway.ResourceCollection;
import com.braintreegateway.Result;
import com.braintreegateway.Transaction;
import com.braintreegateway.TransactionCloneRequest;
import com.braintreegateway.TransactionPager;
import com.braintreegateway.TransactionRequest;
import com.braintreegateway.TransactionSearchRequest;
import com.braintreegateway.TransparentRedirectRequest;
import com.braintreegateway.exceptions.NotFoundException;
import com.braintreegateway.util.Http;
import com.braintreegateway.util.NodeWrapper;
import com.braintreegateway.util.TrUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransactionGateway {
    private Http http;
    private Configuration configuration;

    public TransactionGateway(Http http, Configuration configuration) {
        this.http = http;
        this.configuration = configuration;
    }

    public Result<Transaction> cloneTransaction(String id, TransactionCloneRequest request) {
        NodeWrapper response = this.http.post("/transactions/" + id + "/clone", request);
        return new Result<Transaction>(response, Transaction.class);
    }

    @Deprecated
    public Result<Transaction> confirmTransparentRedirect(String queryString) {
        TransparentRedirectRequest trRequest = new TransparentRedirectRequest(this.configuration, queryString);
        NodeWrapper node = this.http.post("/transactions/all/confirm_transparent_redirect_request", trRequest);
        return new Result<Transaction>(node, Transaction.class);
    }

    public Result<Transaction> credit(TransactionRequest request) {
        NodeWrapper response = this.http.post("/transactions", request.type(Transaction.Type.CREDIT));
        return new Result<Transaction>(response, Transaction.class);
    }

    public String creditTrData(TransactionRequest trData, String redirectURL) {
        return new TrUtil(this.configuration).buildTrData(trData.type(Transaction.Type.CREDIT), redirectURL);
    }

    public Transaction find(String id) {
        if (id == null || id.trim().equals("")) {
            throw new NotFoundException();
        }
        return new Transaction(this.http.get("/transactions/" + id));
    }

    public Result<Transaction> refund(String id) {
        NodeWrapper response = this.http.post("/transactions/" + id + "/refund");
        return new Result<Transaction>(response, Transaction.class);
    }

    public Result<Transaction> refund(String id, BigDecimal amount) {
        TransactionRequest request = new TransactionRequest().amount(amount);
        NodeWrapper response = this.http.post("/transactions/" + id + "/refund", request);
        return new Result<Transaction>(response, Transaction.class);
    }

    public Result<Transaction> sale(TransactionRequest request) {
        NodeWrapper response = this.http.post("/transactions", request.type(Transaction.Type.SALE));
        return new Result<Transaction>(response, Transaction.class);
    }

    public String saleTrData(TransactionRequest trData, String redirectURL) {
        return new TrUtil(this.configuration).buildTrData(trData.type(Transaction.Type.SALE), redirectURL);
    }

    public ResourceCollection<Transaction> search(TransactionSearchRequest query) {
        NodeWrapper node = this.http.post("/transactions/advanced_search_ids", query);
        return new ResourceCollection<Transaction>(new TransactionPager(this, query), node);
    }

    List<Transaction> fetchTransactions(TransactionSearchRequest query, List<String> ids) {
        query.ids().in(ids);
        NodeWrapper response = this.http.post("/transactions/advanced_search", query);
        ArrayList<Transaction> items = new ArrayList<Transaction>();
        for (NodeWrapper node : response.findAll("transaction")) {
            items.add(new Transaction(node));
        }
        return items;
    }

    public Result<Transaction> cancelRelease(String id) {
        TransactionRequest request = new TransactionRequest();
        NodeWrapper response = this.http.put("/transactions/" + id + "/cancel_release", request);
        return new Result<Transaction>(response, Transaction.class);
    }

    public Result<Transaction> holdInEscrow(String id) {
        TransactionRequest request = new TransactionRequest();
        NodeWrapper response = this.http.put("/transactions/" + id + "/hold_in_escrow", request);
        return new Result<Transaction>(response, Transaction.class);
    }

    public Result<Transaction> releaseFromEscrow(String id) {
        TransactionRequest request = new TransactionRequest();
        NodeWrapper response = this.http.put("/transactions/" + id + "/release_from_escrow", request);
        return new Result<Transaction>(response, Transaction.class);
    }

    public Result<Transaction> submitForSettlement(String id) {
        return this.submitForSettlement(id, null);
    }

    public Result<Transaction> submitForSettlement(String id, BigDecimal amount) {
        TransactionRequest request = new TransactionRequest().amount(amount);
        NodeWrapper response = this.http.put("/transactions/" + id + "/submit_for_settlement", request);
        return new Result<Transaction>(response, Transaction.class);
    }

    @Deprecated
    public String transparentRedirectURLForCreate() {
        return this.configuration.baseMerchantURL + "/transactions/all/create_via_transparent_redirect_request";
    }

    public Result<Transaction> voidTransaction(String id) {
        NodeWrapper response = this.http.put("/transactions/" + id + "/void");
        return new Result<Transaction>(response, Transaction.class);
    }
}

