/*
 * Decompiled with CFR 0.152.
 */
package com.braintreegateway;

import java.util.Arrays;

public class Environment {
    public static final Environment DEVELOPMENT = new Environment("http://localhost:" + Environment.developmentPort(), new String[0]);
    public static final Environment PRODUCTION = new Environment("https://www.braintreegateway.com:443", new String[]{"ssl/www_braintreegateway_com.ca.der", "ssl/securetrust.ca.der"});
    public static final Environment SANDBOX = new Environment("https://sandbox.braintreegateway.com:443", new String[]{"ssl/sandbox-godaddy-root.ca.der", "ssl/sandbox_braintreegateway_com.ca.der", "ssl/sandbox-godaddy-intermediate.ca.der"});
    public final String baseURL;
    public final String[] certificateFilenames;

    public Environment(String baseURL, String[] certificateFilenames) {
        this.baseURL = baseURL;
        this.certificateFilenames = Arrays.copyOf(certificateFilenames, certificateFilenames.length);
    }

    public static String developmentPort() {
        if (System.getenv().get("GATEWAY_PORT") != null) {
            return System.getenv().get("GATEWAY_PORT");
        }
        return "3000";
    }
}

