/*
 * Decompiled with CFR 0.152.
 */
package com.braintreegateway.util;

import com.braintreegateway.Configuration;
import com.braintreegateway.Request;
import com.braintreegateway.util.Crypto;
import com.braintreegateway.util.QueryString;
import java.net.URLEncoder;
import java.util.Calendar;
import java.util.Map;
import java.util.TimeZone;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TrUtil {
    private Configuration configuration;

    public TrUtil(Configuration configuration) {
        this.configuration = configuration;
    }

    public String buildTrData(Request request, String redirectURL) {
        Calendar now = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        String dateString = String.format("%1$tY%1$tm%1$td%1$tH%1$tM%1$tS", now);
        String trContent = new QueryString().append("api_version", Configuration.apiVersion()).append("public_key", this.configuration.publicKey).append("redirect_url", redirectURL).append("time", dateString).append("kind", request.getKind()).toString();
        String requestQueryString = request.toQueryString();
        if (requestQueryString.length() > 0) {
            trContent = trContent + "&" + requestQueryString;
        }
        String trHash = new Crypto().hmacHash(this.configuration.privateKey, trContent);
        return trHash + "|" + trContent;
    }

    public boolean isValidTrQueryString(String queryString) {
        String[] pieces = queryString.split("&hash=");
        String queryStringWithoutHash = pieces[0];
        String hash = pieces[1];
        return hash.equals(new Crypto().hmacHash(this.configuration.privateKey, queryStringWithoutHash));
    }

    protected String encodeMap(Map<String, String> map) {
        StringBuilder builder = new StringBuilder();
        String[] keys = map.keySet().toArray(new String[0]);
        for (int i = 0; i < keys.length; ++i) {
            String key = keys[i];
            builder.append(this.encodeParam(key, map.get(key)));
            if (i + 1 >= keys.length) continue;
            builder.append("&");
        }
        return builder.toString();
    }

    protected String encodeParam(String key, String value) {
        String encodedKey = "";
        String encodedValue = "";
        try {
            encodedKey = URLEncoder.encode(key, "UTF-8");
            encodedValue = URLEncoder.encode(value, "UTF-8");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return encodedKey + "=" + encodedValue;
    }

    public String url() {
        return this.configuration.baseMerchantURL + "/transparent_redirect_requests";
    }
}

