/*
 * Decompiled with CFR 0.152.
 */
package com.braintreegateway;

import com.braintreegateway.ThreeDSecureAuthenticateInfo;
import com.braintreegateway.ThreeDSecureLookupInfo;
import com.braintreegateway.util.NodeWrapper;
import java.util.Map;

public class ThreeDSecureInfo {
    private boolean liabilityShifted;
    private boolean liabilityShiftPossible;
    private String enrolled;
    private String status;
    private String cavv;
    private String eciFlag;
    private String xid;
    private String threeDSecureVersion;
    private String dsTransactionId;
    private String threeDSecureAuthenticationId;
    private String acsTransactionId;
    private String paresStatus;
    private String threeDSecureServerTransactionId;
    private ThreeDSecureLookupInfo threeDSecureLookupInfo;
    private ThreeDSecureAuthenticateInfo threeDSecureAuthenticateInfo;

    public ThreeDSecureInfo(NodeWrapper node) {
        NodeWrapper threeDSecureAuthenticateInfoNode;
        this.liabilityShifted = node.findBoolean("liability-shifted");
        this.liabilityShiftPossible = node.findBoolean("liability-shift-possible");
        this.enrolled = node.findString("enrolled");
        this.status = node.findString("status");
        this.cavv = node.findString("cavv");
        this.eciFlag = node.findString("eci-flag");
        this.xid = node.findString("xid");
        this.threeDSecureVersion = node.findString("three-d-secure-version");
        this.dsTransactionId = node.findString("ds-transaction-id");
        this.threeDSecureAuthenticationId = node.findString("three-d-secure-authentication-id");
        this.acsTransactionId = node.findString("acs-transaction-id");
        this.paresStatus = node.findString("pares-status");
        this.threeDSecureServerTransactionId = node.findString("three-d-secure-server-transaction-id");
        NodeWrapper threeDSecureLookupInfoNode = node.findFirst("lookup");
        if (threeDSecureLookupInfoNode != null && !threeDSecureLookupInfoNode.isBlank()) {
            this.threeDSecureLookupInfo = new ThreeDSecureLookupInfo(threeDSecureLookupInfoNode);
        }
        if ((threeDSecureAuthenticateInfoNode = node.findFirst("authenticate")) != null && !threeDSecureAuthenticateInfoNode.isBlank()) {
            this.threeDSecureAuthenticateInfo = new ThreeDSecureAuthenticateInfo(threeDSecureAuthenticateInfoNode);
        }
    }

    public ThreeDSecureInfo(Map<String, Object> map) {
        Map threeDSecureAuthenticateInfoMap;
        this.liabilityShifted = (Boolean)map.get("liabilityShifted");
        this.liabilityShiftPossible = (Boolean)map.get("liabilityShiftPossible");
        this.enrolled = (String)map.get("enrolled");
        this.status = (String)map.get("status");
        this.cavv = (String)map.get("cavv");
        this.eciFlag = (String)map.get("eciFlag");
        this.xid = (String)map.get("xid");
        this.threeDSecureVersion = (String)map.get("threeDSecureVersion");
        this.dsTransactionId = (String)map.get("dsTransactionId");
        this.threeDSecureAuthenticationId = (String)map.get("threeDSecureAuthenticationId");
        this.acsTransactionId = (String)map.get("acsTransactionId");
        this.paresStatus = (String)map.get("paresStatus");
        this.threeDSecureServerTransactionId = (String)map.get("threeDSecureServerTransactionId");
        Map threeDSecureLookupInfoMap = (Map)map.get("lookup");
        if (threeDSecureLookupInfoMap != null) {
            this.threeDSecureLookupInfo = new ThreeDSecureLookupInfo(threeDSecureLookupInfoMap);
        }
        if ((threeDSecureAuthenticateInfoMap = (Map)map.get("authenticate")) != null) {
            this.threeDSecureAuthenticateInfo = new ThreeDSecureAuthenticateInfo(threeDSecureAuthenticateInfoMap);
        }
    }

    public String getStatus() {
        return this.status;
    }

    public String getEnrolled() {
        return this.enrolled;
    }

    public boolean isLiabilityShifted() {
        return this.liabilityShifted;
    }

    public boolean isLiabilityShiftPossible() {
        return this.liabilityShiftPossible;
    }

    public String getCAVV() {
        return this.cavv;
    }

    public String getECIFlag() {
        return this.eciFlag;
    }

    public String getXID() {
        return this.xid;
    }

    public String getThreeDSecureVersion() {
        return this.threeDSecureVersion;
    }

    public String getDsTransactionId() {
        return this.dsTransactionId;
    }

    public String getThreeDSecureAuthenticationId() {
        return this.threeDSecureAuthenticationId;
    }

    public String getAcsTransactionId() {
        return this.acsTransactionId;
    }

    public String getParesStatus() {
        return this.paresStatus;
    }

    public String getThreeDSecureServerTransactionId() {
        return this.threeDSecureServerTransactionId;
    }

    public ThreeDSecureLookupInfo getThreeDSecureLookupInfo() {
        return this.threeDSecureLookupInfo;
    }

    public ThreeDSecureAuthenticateInfo getThreeDSecureAuthenticateInfo() {
        return this.threeDSecureAuthenticateInfo;
    }
}

