/*
 * Decompiled with CFR 0.152.
 */
package com.braintreepayments.api;

import android.content.Context;
import android.content.SharedPreferences;
import androidx.annotation.VisibleForTesting;

class BraintreeSharedPreferences {
    private static final String PREFERENCES_FILE_KEY = "com.braintreepayments.api.SHARED_PREFERENCES";
    private static volatile BraintreeSharedPreferences INSTANCE;
    private final SharedPreferences sharedPreferences;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static BraintreeSharedPreferences getInstance(Context context) {
        if (INSTANCE != null) return INSTANCE;
        Class<BraintreeSharedPreferences> clazz = BraintreeSharedPreferences.class;
        synchronized (BraintreeSharedPreferences.class) {
            if (INSTANCE != null) return INSTANCE;
            INSTANCE = new BraintreeSharedPreferences(BraintreeSharedPreferences.createSharedPreferencesInstance(context));
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return INSTANCE;
        }
    }

    private static SharedPreferences createSharedPreferencesInstance(Context context) {
        return context.getSharedPreferences(PREFERENCES_FILE_KEY, 0);
    }

    @VisibleForTesting
    BraintreeSharedPreferences(SharedPreferences sharedPreferences) {
        this.sharedPreferences = sharedPreferences;
    }

    String getString(String key, String fallback) {
        return this.sharedPreferences.getString(key, fallback);
    }

    void putString(String key, String value) {
        this.sharedPreferences.edit().putString(key, value).apply();
    }

    boolean getBoolean(String key) {
        return this.sharedPreferences.getBoolean(key, false);
    }

    void putBoolean(String key, boolean value) {
        this.sharedPreferences.edit().putBoolean(key, value).apply();
    }

    boolean containsKey(String key) {
        return this.sharedPreferences.contains(key);
    }

    long getLong(String key) {
        return this.sharedPreferences.getLong(key, 0L);
    }

    void putStringAndLong(String stringKey, String stringValue, String longKey, long longValue) {
        this.sharedPreferences.edit().putString(stringKey, stringValue).putLong(longKey, longValue).apply();
    }

    void clearSharedPreferences() {
        this.sharedPreferences.edit().clear().apply();
    }
}

