/*
 * Decompiled with CFR 0.152.
 */
package com.braintreepayments.api;

import com.braintreepayments.api.AuthenticationException;
import com.braintreepayments.api.AuthorizationException;
import com.braintreepayments.api.HttpResponseParser;
import com.braintreepayments.api.RateLimitException;
import com.braintreepayments.api.ServerException;
import com.braintreepayments.api.ServiceUnavailableException;
import com.braintreepayments.api.UnexpectedException;
import com.braintreepayments.api.UnprocessableEntityException;
import com.braintreepayments.api.UpgradeRequiredException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.nio.charset.StandardCharsets;
import java.util.zip.GZIPInputStream;

class BaseHttpResponseParser
implements HttpResponseParser {
    private static final int HTTP_UNPROCESSABLE_ENTITY = 422;
    private static final int HTTP_UPGRADE_REQUIRED = 426;
    private static final int HTTP_TOO_MANY_REQUESTS = 429;

    BaseHttpResponseParser() {
    }

    @Override
    public String parse(int responseCode, HttpURLConnection connection) throws Exception {
        String responseBody = this.parseBody(responseCode, connection);
        switch (responseCode) {
            case 200: 
            case 201: 
            case 202: {
                return responseBody;
            }
            case 400: 
            case 422: {
                throw new UnprocessableEntityException(responseBody);
            }
            case 401: {
                throw new AuthenticationException(responseBody);
            }
            case 403: {
                throw new AuthorizationException(responseBody);
            }
            case 426: {
                throw new UpgradeRequiredException(responseBody);
            }
            case 429: {
                throw new RateLimitException("You are being rate-limited. Please try again in a few minutes.");
            }
            case 500: {
                throw new ServerException(responseBody);
            }
            case 503: {
                throw new ServiceUnavailableException(responseBody);
            }
        }
        throw new UnexpectedException(responseBody);
    }

    private String parseBody(int responseCode, HttpURLConnection connection) throws IOException {
        boolean gzip = "gzip".equals(connection.getContentEncoding());
        switch (responseCode) {
            case 200: 
            case 201: 
            case 202: {
                return this.readStream(connection.getInputStream(), gzip);
            }
            case 429: {
                return null;
            }
        }
        return this.readStream(connection.getErrorStream(), gzip);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readStream(InputStream in, boolean gzip) throws IOException {
        if (in == null) {
            return null;
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            int count;
            if (gzip) {
                in = new GZIPInputStream(in);
            }
            byte[] buffer = new byte[1024];
            while ((count = in.read(buffer)) != -1) {
                out.write(buffer, 0, count);
            }
            String string = new String(out.toByteArray(), StandardCharsets.UTF_8);
            return string;
        }
        finally {
            try {
                in.close();
            }
            catch (IOException iOException) {}
        }
    }
}

