/*
 * Decompiled with CFR 0.152.
 */
package com.braintreepayments.api;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import androidx.annotation.Nullable;
import com.braintreepayments.api.Authorization;
import com.braintreepayments.api.ClientToken;
import com.braintreepayments.api.Configuration;
import com.braintreepayments.api.PayPalRequest;
import com.braintreepayments.api.PostalAddress;
import org.json.JSONException;
import org.json.JSONObject;

public class PayPalVaultRequest
extends PayPalRequest
implements Parcelable {
    private boolean shouldOfferCredit;
    private String userAuthenticationEmail;
    public static final Parcelable.Creator<PayPalVaultRequest> CREATOR = new Parcelable.Creator<PayPalVaultRequest>(){

        public PayPalVaultRequest createFromParcel(Parcel in) {
            return new PayPalVaultRequest(in);
        }

        public PayPalVaultRequest[] newArray(int size) {
            return new PayPalVaultRequest[size];
        }
    };

    @Deprecated
    public PayPalVaultRequest() {
        super(false);
    }

    public PayPalVaultRequest(boolean hasUserLocationConsent) {
        super(hasUserLocationConsent);
    }

    public void setShouldOfferCredit(boolean shouldOfferCredit) {
        this.shouldOfferCredit = shouldOfferCredit;
    }

    public boolean getShouldOfferCredit() {
        return this.shouldOfferCredit;
    }

    public void setUserAuthenticationEmail(@Nullable String userAuthenticationEmail) {
        this.userAuthenticationEmail = userAuthenticationEmail;
    }

    @Nullable
    public String getUserAuthenticationEmail() {
        return this.userAuthenticationEmail;
    }

    @Override
    String createRequestBody(Configuration configuration, Authorization authorization, String successUrl, String cancelUrl) throws JSONException {
        JSONObject parameters = new JSONObject().put("return_url", (Object)successUrl).put("cancel_url", (Object)cancelUrl).put("offer_paypal_credit", this.shouldOfferCredit);
        if (authorization instanceof ClientToken) {
            parameters.put("authorization_fingerprint", (Object)authorization.getBearer());
        } else {
            parameters.put("client_key", (Object)authorization.getBearer());
        }
        String billingAgreementDescription = this.getBillingAgreementDescription();
        if (!TextUtils.isEmpty((CharSequence)billingAgreementDescription)) {
            parameters.put("description", (Object)billingAgreementDescription);
        }
        parameters.putOpt("payer_email", (Object)this.userAuthenticationEmail);
        JSONObject experienceProfile = new JSONObject();
        experienceProfile.put("no_shipping", !this.isShippingAddressRequired());
        experienceProfile.put("landing_page_type", (Object)this.getLandingPageType());
        String displayName = this.getDisplayName();
        if (TextUtils.isEmpty((CharSequence)displayName)) {
            displayName = configuration.getPayPalDisplayName();
        }
        experienceProfile.put("brand_name", (Object)displayName);
        if (this.getLocaleCode() != null) {
            experienceProfile.put("locale_code", (Object)this.getLocaleCode());
        }
        if (this.getShippingAddressOverride() != null) {
            experienceProfile.put("address_override", !this.isShippingAddressEditable());
            JSONObject shippingAddressJson = new JSONObject();
            parameters.put("shipping_address", (Object)shippingAddressJson);
            PostalAddress shippingAddress = this.getShippingAddressOverride();
            shippingAddressJson.put("line1", (Object)shippingAddress.getStreetAddress());
            shippingAddressJson.put("line2", (Object)shippingAddress.getExtendedAddress());
            shippingAddressJson.put("city", (Object)shippingAddress.getLocality());
            shippingAddressJson.put("state", (Object)shippingAddress.getRegion());
            shippingAddressJson.put("postal_code", (Object)shippingAddress.getPostalCode());
            shippingAddressJson.put("country_code", (Object)shippingAddress.getCountryCodeAlpha2());
            shippingAddressJson.put("recipient_name", (Object)shippingAddress.getRecipientName());
        } else {
            experienceProfile.put("address_override", false);
        }
        if (this.getMerchantAccountId() != null) {
            parameters.put("merchant_account_id", (Object)this.getMerchantAccountId());
        }
        if (this.getRiskCorrelationId() != null) {
            parameters.put("correlation_id", (Object)this.getRiskCorrelationId());
        }
        parameters.put("experience_profile", (Object)experienceProfile);
        return parameters.toString();
    }

    PayPalVaultRequest(Parcel in) {
        super(in);
        this.shouldOfferCredit = in.readByte() != 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        super.writeToParcel(dest, flags);
        dest.writeByte((byte)(this.shouldOfferCredit ? 1 : 0));
    }

    @Override
    public int describeContents() {
        return 0;
    }
}

