/*
 * Decompiled with CFR 0.152.
 */
package com.braintreepayments.api;

import com.braintreepayments.api.PayPalCheckoutRequest;
import com.braintreepayments.api.PayPalRequest;
import com.braintreepayments.api.PayPalVaultRequest;

class PayPalResponse {
    private String approvalUrl;
    private String clientMetadataId;
    private String pairingId;
    private final PayPalRequest payPalRequest;
    private String successUrl;

    PayPalResponse(PayPalRequest payPalRequest) {
        this.payPalRequest = payPalRequest;
    }

    String getApprovalUrl() {
        return this.approvalUrl;
    }

    PayPalResponse approvalUrl(String value) {
        this.approvalUrl = value;
        return this;
    }

    String getClientMetadataId() {
        return this.clientMetadataId;
    }

    PayPalResponse clientMetadataId(String value) {
        this.clientMetadataId = value;
        return this;
    }

    String getIntent() {
        if (this.payPalRequest instanceof PayPalCheckoutRequest) {
            return ((PayPalCheckoutRequest)this.payPalRequest).getIntent();
        }
        return null;
    }

    String getUserAction() {
        if (this.payPalRequest instanceof PayPalCheckoutRequest) {
            return ((PayPalCheckoutRequest)this.payPalRequest).getUserAction();
        }
        return "";
    }

    boolean isBillingAgreement() {
        return this.payPalRequest instanceof PayPalVaultRequest;
    }

    String getMerchantAccountId() {
        return this.payPalRequest.getMerchantAccountId();
    }

    String getPairingId() {
        return this.pairingId;
    }

    PayPalResponse pairingId(String value) {
        this.pairingId = value;
        return this;
    }

    String getSuccessUrl() {
        return this.successUrl;
    }

    PayPalResponse successUrl(String value) {
        this.successUrl = value;
        return this;
    }
}

