/*
 * Decompiled with CFR 0.152.
 */
package com.braintreepayments.api;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.braintreepayments.api.Authorization;
import com.braintreepayments.api.Configuration;
import com.braintreepayments.api.PayPalLineItem;
import com.braintreepayments.api.PostalAddress;
import java.util.ArrayList;
import java.util.Collection;
import org.json.JSONException;

public abstract class PayPalRequest
implements Parcelable {
    static final String NO_SHIPPING_KEY = "no_shipping";
    static final String ADDRESS_OVERRIDE_KEY = "address_override";
    static final String LOCALE_CODE_KEY = "locale_code";
    static final String REQUEST_BILLING_AGREEMENT_KEY = "request_billing_agreement";
    static final String BILLING_AGREEMENT_DETAILS_KEY = "billing_agreement_details";
    static final String DESCRIPTION_KEY = "description";
    static final String PAYER_EMAIL_KEY = "payer_email";
    static final String AUTHORIZATION_FINGERPRINT_KEY = "authorization_fingerprint";
    static final String TOKENIZATION_KEY = "client_key";
    static final String RETURN_URL_KEY = "return_url";
    static final String OFFER_CREDIT_KEY = "offer_paypal_credit";
    static final String OFFER_PAY_LATER_KEY = "offer_pay_later";
    static final String CANCEL_URL_KEY = "cancel_url";
    static final String EXPERIENCE_PROFILE_KEY = "experience_profile";
    static final String AMOUNT_KEY = "amount";
    static final String CURRENCY_ISO_CODE_KEY = "currency_iso_code";
    static final String INTENT_KEY = "intent";
    static final String LANDING_PAGE_TYPE_KEY = "landing_page_type";
    static final String DISPLAY_NAME_KEY = "brand_name";
    static final String SHIPPING_ADDRESS_KEY = "shipping_address";
    static final String MERCHANT_ACCOUNT_ID = "merchant_account_id";
    static final String CORRELATION_ID_KEY = "correlation_id";
    static final String LINE_ITEMS_KEY = "line_items";
    static final String USER_ACTION_KEY = "user_action";
    public static final String LANDING_PAGE_TYPE_BILLING = "billing";
    public static final String LANDING_PAGE_TYPE_LOGIN = "login";
    private String localeCode;
    private String billingAgreementDescription;
    private boolean shippingAddressRequired;
    private boolean shippingAddressEditable = false;
    private PostalAddress shippingAddressOverride;
    private String landingPageType;
    private String displayName;
    private String merchantAccountId;
    private String riskCorrelationId;
    private final ArrayList<PayPalLineItem> lineItems;
    private final boolean hasUserLocationConsent;

    @Deprecated
    public PayPalRequest() {
        this.shippingAddressRequired = false;
        this.lineItems = new ArrayList();
        this.hasUserLocationConsent = false;
    }

    public PayPalRequest(boolean hasUserLocationConsent) {
        this.shippingAddressRequired = false;
        this.lineItems = new ArrayList();
        this.hasUserLocationConsent = hasUserLocationConsent;
    }

    public void setShippingAddressRequired(boolean shippingAddressRequired) {
        this.shippingAddressRequired = shippingAddressRequired;
    }

    public void setShippingAddressEditable(boolean shippingAddressEditable) {
        this.shippingAddressEditable = shippingAddressEditable;
    }

    public void setLocaleCode(@Nullable String localeCode) {
        this.localeCode = localeCode;
    }

    public void setDisplayName(@Nullable String displayName) {
        this.displayName = displayName;
    }

    public void setBillingAgreementDescription(@Nullable String description) {
        this.billingAgreementDescription = description;
    }

    public void setShippingAddressOverride(@Nullable PostalAddress shippingAddressOverride) {
        this.shippingAddressOverride = shippingAddressOverride;
    }

    public void setLandingPageType(@Nullable String landingPageType) {
        this.landingPageType = landingPageType;
    }

    public void setMerchantAccountId(@Nullable String merchantAccountId) {
        this.merchantAccountId = merchantAccountId;
    }

    public void setRiskCorrelationId(@Nullable String riskCorrelationId) {
        this.riskCorrelationId = riskCorrelationId;
    }

    public void setLineItems(@NonNull Collection<PayPalLineItem> lineItems) {
        this.lineItems.clear();
        this.lineItems.addAll(lineItems);
    }

    @Nullable
    public String getLocaleCode() {
        return this.localeCode;
    }

    @Nullable
    public String getBillingAgreementDescription() {
        return this.billingAgreementDescription;
    }

    public boolean isShippingAddressRequired() {
        return this.shippingAddressRequired;
    }

    public boolean isShippingAddressEditable() {
        return this.shippingAddressEditable;
    }

    @Nullable
    public PostalAddress getShippingAddressOverride() {
        return this.shippingAddressOverride;
    }

    @Nullable
    public String getDisplayName() {
        return this.displayName;
    }

    @Nullable
    public String getMerchantAccountId() {
        return this.merchantAccountId;
    }

    @Nullable
    public String getRiskCorrelationId() {
        return this.riskCorrelationId;
    }

    @NonNull
    public ArrayList<PayPalLineItem> getLineItems() {
        return this.lineItems;
    }

    @Nullable
    public String getLandingPageType() {
        return this.landingPageType;
    }

    public boolean hasUserLocationConsent() {
        return this.hasUserLocationConsent;
    }

    abstract String createRequestBody(Configuration var1, Authorization var2, String var3, String var4) throws JSONException;

    protected PayPalRequest(Parcel in) {
        this.localeCode = in.readString();
        this.billingAgreementDescription = in.readString();
        this.shippingAddressRequired = in.readByte() != 0;
        this.shippingAddressEditable = in.readByte() != 0;
        this.shippingAddressOverride = (PostalAddress)in.readParcelable(PostalAddress.class.getClassLoader());
        this.landingPageType = in.readString();
        this.displayName = in.readString();
        this.merchantAccountId = in.readString();
        this.riskCorrelationId = in.readString();
        this.lineItems = in.createTypedArrayList(PayPalLineItem.CREATOR);
        this.hasUserLocationConsent = in.readByte() != 0;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int i) {
        parcel.writeString(this.localeCode);
        parcel.writeString(this.billingAgreementDescription);
        parcel.writeByte((byte)(this.shippingAddressRequired ? 1 : 0));
        parcel.writeByte((byte)(this.shippingAddressEditable ? 1 : 0));
        parcel.writeParcelable((Parcelable)this.shippingAddressOverride, i);
        parcel.writeString(this.landingPageType);
        parcel.writeString(this.displayName);
        parcel.writeString(this.merchantAccountId);
        parcel.writeString(this.riskCorrelationId);
        parcel.writeTypedList(this.lineItems);
        parcel.writeByte((byte)(this.hasUserLocationConsent ? 1 : 0));
    }
}

