/*
 * Decompiled with CFR 0.152.
 */
package com.braintreepayments.api;

import android.os.Handler;
import android.os.Looper;
import androidx.annotation.NonNull;
import androidx.annotation.VisibleForTesting;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleEventObserver;
import androidx.lifecycle.LifecycleOwner;
import com.braintreepayments.api.BrowserSwitchResult;
import com.braintreepayments.api.PayPalClient;

class PayPalLifecycleObserver
implements LifecycleEventObserver {
    @VisibleForTesting
    final PayPalClient payPalClient;

    PayPalLifecycleObserver(PayPalClient payPalClient) {
        this.payPalClient = payPalClient;
    }

    public void onStateChanged(@NonNull LifecycleOwner lifecycleOwner, @NonNull Lifecycle.Event event) {
        if (event == Lifecycle.Event.ON_RESUME) {
            FragmentActivity activity = null;
            if (lifecycleOwner instanceof FragmentActivity) {
                activity = (FragmentActivity)lifecycleOwner;
            } else if (lifecycleOwner instanceof Fragment) {
                activity = ((Fragment)lifecycleOwner).getActivity();
            }
            if (activity != null) {
                final FragmentActivity finalActivity = activity;
                new Handler(Looper.getMainLooper()).post(new Runnable(){

                    @Override
                    public void run() {
                        BrowserSwitchResult pendingResultFromCache;
                        BrowserSwitchResult resultToDeliver = null;
                        BrowserSwitchResult pendingResult = PayPalLifecycleObserver.this.payPalClient.getBrowserSwitchResult(finalActivity);
                        if (pendingResult != null && pendingResult.getRequestCode() == 13591) {
                            resultToDeliver = PayPalLifecycleObserver.this.payPalClient.deliverBrowserSwitchResult(finalActivity);
                        }
                        if ((pendingResultFromCache = PayPalLifecycleObserver.this.payPalClient.getBrowserSwitchResultFromNewTask(finalActivity)) != null && pendingResultFromCache.getRequestCode() == 13591) {
                            resultToDeliver = PayPalLifecycleObserver.this.payPalClient.deliverBrowserSwitchResultFromNewTask(finalActivity);
                        }
                        if (resultToDeliver != null) {
                            PayPalLifecycleObserver.this.payPalClient.onBrowserSwitchResult(resultToDeliver);
                        }
                    }
                });
            }
        }
    }
}

