/*
 * Decompiled with CFR 0.152.
 */
package com.braintreepayments.api;

import android.content.Context;
import android.net.Uri;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.braintreepayments.api.ApiClient;
import com.braintreepayments.api.Authorization;
import com.braintreepayments.api.AuthorizationCallback;
import com.braintreepayments.api.BraintreeClient;
import com.braintreepayments.api.Configuration;
import com.braintreepayments.api.ConfigurationCallback;
import com.braintreepayments.api.HttpResponseCallback;
import com.braintreepayments.api.PayPalAccount;
import com.braintreepayments.api.PayPalAccountNonce;
import com.braintreepayments.api.PayPalBrowserSwitchResultCallback;
import com.braintreepayments.api.PayPalDataCollector;
import com.braintreepayments.api.PayPalDataCollectorInternalRequest;
import com.braintreepayments.api.PayPalInternalClientCallback;
import com.braintreepayments.api.PayPalPaymentResource;
import com.braintreepayments.api.PayPalRequest;
import com.braintreepayments.api.PayPalResponse;
import com.braintreepayments.api.PayPalVaultRequest;
import com.braintreepayments.api.PaymentMethod;
import com.braintreepayments.api.TokenizeCallback;
import org.json.JSONException;
import org.json.JSONObject;

class PayPalInternalClient {
    private static final String CREATE_SINGLE_PAYMENT_ENDPOINT = "paypal_hermes/create_payment_resource";
    private static final String SETUP_BILLING_AGREEMENT_ENDPOINT = "paypal_hermes/setup_billing_agreement";
    private final String cancelUrl;
    private final String successUrl;
    private final BraintreeClient braintreeClient;
    private final PayPalDataCollector payPalDataCollector;
    private final ApiClient apiClient;

    PayPalInternalClient(BraintreeClient braintreeClient) {
        this(braintreeClient, new PayPalDataCollector(braintreeClient), new ApiClient(braintreeClient));
    }

    @VisibleForTesting
    PayPalInternalClient(BraintreeClient braintreeClient, PayPalDataCollector payPalDataCollector, ApiClient apiClient) {
        this.braintreeClient = braintreeClient;
        this.payPalDataCollector = payPalDataCollector;
        this.apiClient = apiClient;
        this.cancelUrl = String.format("%s://onetouch/v1/cancel", braintreeClient.getReturnUrlScheme());
        this.successUrl = String.format("%s://onetouch/v1/success", braintreeClient.getReturnUrlScheme());
    }

    void sendRequest(final Context context, final PayPalRequest payPalRequest, final PayPalInternalClientCallback callback) {
        this.braintreeClient.getAuthorization(new AuthorizationCallback(){

            public void onAuthorizationResult(final @Nullable Authorization authorization, @Nullable Exception authError) {
                if (authorization != null) {
                    PayPalInternalClient.this.braintreeClient.getConfiguration(new ConfigurationCallback(){

                        public void onResult(final @Nullable Configuration configuration, @Nullable Exception configError) {
                            if (configuration == null) {
                                callback.onResult(null, configError);
                                return;
                            }
                            try {
                                boolean isBillingAgreement = payPalRequest instanceof PayPalVaultRequest;
                                String endpoint = isBillingAgreement ? PayPalInternalClient.SETUP_BILLING_AGREEMENT_ENDPOINT : PayPalInternalClient.CREATE_SINGLE_PAYMENT_ENDPOINT;
                                String url = String.format("/v1/%s", endpoint);
                                String requestBody = payPalRequest.createRequestBody(configuration, authorization, PayPalInternalClient.this.successUrl, PayPalInternalClient.this.cancelUrl);
                                PayPalInternalClient.this.braintreeClient.sendPOST(url, requestBody, new HttpResponseCallback(){

                                    public void onResult(String responseBody, Exception httpError) {
                                        if (responseBody != null) {
                                            try {
                                                PayPalResponse payPalResponse = new PayPalResponse(payPalRequest).successUrl(PayPalInternalClient.this.successUrl);
                                                PayPalPaymentResource paypalPaymentResource = PayPalPaymentResource.fromJson(responseBody);
                                                String redirectUrl = paypalPaymentResource.getRedirectUrl();
                                                if (redirectUrl != null) {
                                                    Uri parsedRedirectUri = Uri.parse((String)redirectUrl);
                                                    String pairingId = PayPalInternalClient.this.findPairingId(parsedRedirectUri);
                                                    String clientMetadataId = payPalRequest.getRiskCorrelationId();
                                                    if (clientMetadataId == null) {
                                                        PayPalDataCollectorInternalRequest dataCollectorRequest = new PayPalDataCollectorInternalRequest(payPalRequest.hasUserLocationConsent()).setApplicationGuid(PayPalInternalClient.this.payPalDataCollector.getPayPalInstallationGUID(context));
                                                        if (pairingId != null) {
                                                            dataCollectorRequest.setRiskCorrelationId(pairingId);
                                                        }
                                                        clientMetadataId = PayPalInternalClient.this.payPalDataCollector.getClientMetadataId(context, dataCollectorRequest, configuration);
                                                    }
                                                    if (pairingId != null) {
                                                        payPalResponse.pairingId(pairingId);
                                                    }
                                                    payPalResponse.clientMetadataId(clientMetadataId).approvalUrl(parsedRedirectUri.toString());
                                                }
                                                callback.onResult(payPalResponse, null);
                                            }
                                            catch (JSONException exception) {
                                                callback.onResult(null, (Exception)((Object)exception));
                                            }
                                        } else {
                                            callback.onResult(null, httpError);
                                        }
                                    }
                                });
                            }
                            catch (JSONException exception) {
                                callback.onResult(null, (Exception)((Object)exception));
                            }
                        }
                    });
                } else {
                    callback.onResult(null, authError);
                }
            }
        });
    }

    void tokenize(PayPalAccount payPalAccount, final PayPalBrowserSwitchResultCallback callback) {
        this.apiClient.tokenizeREST((PaymentMethod)payPalAccount, new TokenizeCallback(){

            public void onResult(JSONObject tokenizationResponse, Exception exception) {
                if (tokenizationResponse != null) {
                    try {
                        PayPalAccountNonce payPalAccountNonce = PayPalAccountNonce.fromJSON(tokenizationResponse);
                        callback.onResult(payPalAccountNonce, null);
                    }
                    catch (JSONException e) {
                        callback.onResult(null, (Exception)((Object)e));
                    }
                } else {
                    callback.onResult(null, exception);
                }
            }
        });
    }

    private String findPairingId(Uri redirectUri) {
        String pairingId = redirectUri.getQueryParameter("ba_token");
        if (pairingId == null) {
            pairingId = redirectUri.getQueryParameter("token");
        }
        return pairingId;
    }
}

