/*
 * Decompiled with CFR 0.152.
 */
package com.braintreepayments.api;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.Nullable;
import com.braintreepayments.api.Json;
import org.json.JSONObject;

public class PayPalCreditFinancingAmount
implements Parcelable {
    private static final String CURRENCY_KEY = "currency";
    private static final String VALUE_KEY = "value";
    private String currency;
    private String value;
    public static final Parcelable.Creator<PayPalCreditFinancingAmount> CREATOR = new Parcelable.Creator<PayPalCreditFinancingAmount>(){

        public PayPalCreditFinancingAmount createFromParcel(Parcel source) {
            return new PayPalCreditFinancingAmount(source);
        }

        public PayPalCreditFinancingAmount[] newArray(int size) {
            return new PayPalCreditFinancingAmount[size];
        }
    };

    private PayPalCreditFinancingAmount() {
    }

    static PayPalCreditFinancingAmount fromJson(JSONObject amount) {
        PayPalCreditFinancingAmount result = new PayPalCreditFinancingAmount();
        if (amount == null) {
            return result;
        }
        result.currency = Json.optString((JSONObject)amount, (String)CURRENCY_KEY, null);
        result.value = Json.optString((JSONObject)amount, (String)VALUE_KEY, null);
        return result;
    }

    @Nullable
    public String getCurrency() {
        return this.currency;
    }

    @Nullable
    public String getValue() {
        return this.value;
    }

    public String toString() {
        return String.format("%s %s", this.value, this.currency);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.currency);
        dest.writeString(this.value);
    }

    private PayPalCreditFinancingAmount(Parcel in) {
        this.currency = in.readString();
        this.value = in.readString();
    }
}

