/*
 * Decompiled with CFR 0.152.
 */
package com.braintreepayments.api;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import com.braintreepayments.api.PayPalCreditFinancingAmount;
import org.json.JSONException;
import org.json.JSONObject;

public class PayPalCreditFinancing
implements Parcelable {
    private static final String CARD_AMOUNT_IMMUTABLE_KEY = "cardAmountImmutable";
    private static final String MONTHLY_PAYMENT_KEY = "monthlyPayment";
    private static final String PAYER_ACCEPTANCE_KEY = "payerAcceptance";
    private static final String TERM_KEY = "term";
    private static final String TOTAL_COST_KEY = "totalCost";
    private static final String TOTAL_INTEREST_KEY = "totalInterest";
    private boolean cardAmountImmutable;
    private PayPalCreditFinancingAmount monthlyPayment;
    private boolean payerAcceptance;
    private int term;
    private PayPalCreditFinancingAmount totalCost;
    private PayPalCreditFinancingAmount totalInterest;
    public static final Parcelable.Creator<PayPalCreditFinancing> CREATOR = new Parcelable.Creator<PayPalCreditFinancing>(){

        public PayPalCreditFinancing createFromParcel(Parcel source) {
            return new PayPalCreditFinancing(source);
        }

        public PayPalCreditFinancing[] newArray(int size) {
            return new PayPalCreditFinancing[size];
        }
    };

    private PayPalCreditFinancing() {
    }

    static PayPalCreditFinancing fromJson(JSONObject creditFinancing) throws JSONException {
        PayPalCreditFinancing result = new PayPalCreditFinancing();
        if (creditFinancing == null) {
            return result;
        }
        result.cardAmountImmutable = creditFinancing.optBoolean(CARD_AMOUNT_IMMUTABLE_KEY, false);
        result.monthlyPayment = PayPalCreditFinancingAmount.fromJson(creditFinancing.getJSONObject(MONTHLY_PAYMENT_KEY));
        result.payerAcceptance = creditFinancing.optBoolean(PAYER_ACCEPTANCE_KEY, false);
        result.term = creditFinancing.optInt(TERM_KEY, 0);
        result.totalCost = PayPalCreditFinancingAmount.fromJson(creditFinancing.getJSONObject(TOTAL_COST_KEY));
        result.totalInterest = PayPalCreditFinancingAmount.fromJson(creditFinancing.getJSONObject(TOTAL_INTEREST_KEY));
        return result;
    }

    public int getTerm() {
        return this.term;
    }

    public boolean isCardAmountImmutable() {
        return this.cardAmountImmutable;
    }

    @NonNull
    public PayPalCreditFinancingAmount getMonthlyPayment() {
        return this.monthlyPayment;
    }

    public boolean hasPayerAcceptance() {
        return this.payerAcceptance;
    }

    @NonNull
    public PayPalCreditFinancingAmount getTotalCost() {
        return this.totalCost;
    }

    @NonNull
    public PayPalCreditFinancingAmount getTotalInterest() {
        return this.totalInterest;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeByte(this.cardAmountImmutable ? (byte)1 : 0);
        dest.writeParcelable((Parcelable)this.monthlyPayment, flags);
        dest.writeByte(this.payerAcceptance ? (byte)1 : 0);
        dest.writeInt(this.term);
        dest.writeParcelable((Parcelable)this.totalCost, flags);
        dest.writeParcelable((Parcelable)this.totalInterest, flags);
    }

    private PayPalCreditFinancing(Parcel in) {
        this.cardAmountImmutable = in.readByte() != 0;
        this.monthlyPayment = (PayPalCreditFinancingAmount)in.readParcelable(PayPalCreditFinancingAmount.class.getClassLoader());
        this.payerAcceptance = in.readByte() != 0;
        this.term = in.readInt();
        this.totalCost = (PayPalCreditFinancingAmount)in.readParcelable(PayPalCreditFinancingAmount.class.getClassLoader());
        this.totalInterest = (PayPalCreditFinancingAmount)in.readParcelable(PayPalCreditFinancingAmount.class.getClassLoader());
    }
}

