/*
 * Decompiled with CFR 0.152.
 */
package com.braintreepayments.api;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleObserver;
import com.braintreepayments.api.BraintreeClient;
import com.braintreepayments.api.BraintreeException;
import com.braintreepayments.api.BrowserSwitchException;
import com.braintreepayments.api.BrowserSwitchOptions;
import com.braintreepayments.api.BrowserSwitchResult;
import com.braintreepayments.api.Configuration;
import com.braintreepayments.api.ConfigurationCallback;
import com.braintreepayments.api.Json;
import com.braintreepayments.api.PayPalAccount;
import com.braintreepayments.api.PayPalAccountNonce;
import com.braintreepayments.api.PayPalBrowserSwitchException;
import com.braintreepayments.api.PayPalBrowserSwitchResultCallback;
import com.braintreepayments.api.PayPalCheckoutRequest;
import com.braintreepayments.api.PayPalFlowStartedCallback;
import com.braintreepayments.api.PayPalInternalClient;
import com.braintreepayments.api.PayPalInternalClientCallback;
import com.braintreepayments.api.PayPalLifecycleObserver;
import com.braintreepayments.api.PayPalListener;
import com.braintreepayments.api.PayPalRequest;
import com.braintreepayments.api.PayPalResponse;
import com.braintreepayments.api.PayPalVaultRequest;
import com.braintreepayments.api.UserCanceledException;
import org.json.JSONException;
import org.json.JSONObject;

public class PayPalClient {
    private final BraintreeClient braintreeClient;
    private final PayPalInternalClient internalPayPalClient;
    private PayPalListener listener;
    private String payPalContextId = null;
    private Boolean isVaultRequest = false;
    @VisibleForTesting
    BrowserSwitchResult pendingBrowserSwitchResult;

    public PayPalClient(@NonNull FragmentActivity activity, @NonNull BraintreeClient braintreeClient) {
        this(activity, activity.getLifecycle(), braintreeClient, new PayPalInternalClient(braintreeClient));
    }

    public PayPalClient(@NonNull Fragment fragment, @NonNull BraintreeClient braintreeClient) {
        this(fragment.getActivity(), fragment.getLifecycle(), braintreeClient, new PayPalInternalClient(braintreeClient));
    }

    public PayPalClient(@NonNull BraintreeClient braintreeClient) {
        this(null, null, braintreeClient, new PayPalInternalClient(braintreeClient));
    }

    @VisibleForTesting
    PayPalClient(FragmentActivity activity, Lifecycle lifecycle, BraintreeClient braintreeClient, PayPalInternalClient internalPayPalClient) {
        this.braintreeClient = braintreeClient;
        this.internalPayPalClient = internalPayPalClient;
        if (activity != null && lifecycle != null) {
            PayPalLifecycleObserver observer = new PayPalLifecycleObserver(this);
            lifecycle.addObserver((LifecycleObserver)observer);
        }
    }

    public void setListener(PayPalListener listener) {
        this.listener = listener;
        if (this.pendingBrowserSwitchResult != null) {
            this.deliverBrowserSwitchResultToListener(this.pendingBrowserSwitchResult);
        }
    }

    private static boolean payPalConfigInvalid(Configuration configuration) {
        return configuration == null || !configuration.isPayPalEnabled();
    }

    @Nullable
    public BrowserSwitchResult parseBrowserSwitchResult(@NonNull Context context, @Nullable Intent intent) {
        int requestCode = 13591;
        return this.braintreeClient.parseBrowserSwitchResult(context, requestCode, intent);
    }

    public void clearActiveBrowserSwitchRequests(@NonNull Context context) {
        this.braintreeClient.clearActiveBrowserSwitchRequests(context);
    }

    private void assertCanPerformBrowserSwitch(FragmentActivity activity) throws BrowserSwitchException {
        this.braintreeClient.assertCanPerformBrowserSwitch(activity, 13591);
    }

    private static Exception createPayPalError() {
        return new BraintreeException("PayPal is not enabled. See https://developer.paypal.com/braintree/docs/guides/paypal/overview/android/v4 for more information.");
    }

    private static Exception createBrowserSwitchError(BrowserSwitchException exception) {
        return new BraintreeException("AndroidManifest.xml is incorrectly configured or another app defines the same browser switch url as this app. See https://developer.paypal.com/braintree/docs/guides/client-sdk/setup/android/v4#browser-switch-setup for the correct configuration: " + exception.getMessage());
    }

    public void tokenizePayPalAccount(@NonNull FragmentActivity activity, @NonNull PayPalRequest payPalRequest) {
        this.tokenizePayPalAccount(activity, payPalRequest, new PayPalFlowStartedCallback(){

            @Override
            public void onResult(@Nullable Exception error) {
                if (error != null && PayPalClient.this.listener != null) {
                    PayPalClient.this.listener.onPayPalFailure(error);
                }
            }
        });
    }

    @Deprecated
    public void tokenizePayPalAccount(@NonNull FragmentActivity activity, @NonNull PayPalRequest payPalRequest, @NonNull PayPalFlowStartedCallback callback) {
        if (payPalRequest instanceof PayPalCheckoutRequest) {
            this.isVaultRequest = false;
            this.sendCheckoutRequest(activity, (PayPalCheckoutRequest)payPalRequest, callback);
        } else if (payPalRequest instanceof PayPalVaultRequest) {
            this.isVaultRequest = true;
            this.sendVaultRequest(activity, (PayPalVaultRequest)payPalRequest, callback);
        }
    }

    @Deprecated
    public void requestOneTimePayment(@NonNull FragmentActivity activity, @NonNull PayPalCheckoutRequest payPalCheckoutRequest, @NonNull PayPalFlowStartedCallback callback) {
        this.tokenizePayPalAccount(activity, payPalCheckoutRequest, callback);
    }

    @Deprecated
    public void requestBillingAgreement(@NonNull FragmentActivity activity, @NonNull PayPalVaultRequest payPalVaultRequest, @NonNull PayPalFlowStartedCallback callback) {
        this.tokenizePayPalAccount(activity, payPalVaultRequest, callback);
    }

    private void sendCheckoutRequest(final FragmentActivity activity, final PayPalCheckoutRequest payPalCheckoutRequest, final PayPalFlowStartedCallback callback) {
        this.braintreeClient.sendAnalyticsEvent("paypal.single-payment.selected", this.payPalContextId, null, this.isVaultRequest.booleanValue());
        if (payPalCheckoutRequest.getShouldOfferPayLater()) {
            this.braintreeClient.sendAnalyticsEvent("paypal.single-payment.paylater.offered", this.payPalContextId, null, this.isVaultRequest.booleanValue());
        }
        this.braintreeClient.getConfiguration(new ConfigurationCallback(){

            public void onResult(@Nullable Configuration configuration, @Nullable Exception error) {
                if (error != null) {
                    callback.onResult(error);
                    return;
                }
                if (PayPalClient.payPalConfigInvalid(configuration)) {
                    Exception configInvalidError = PayPalClient.createPayPalError();
                    callback.onResult(configInvalidError);
                    return;
                }
                try {
                    PayPalClient.this.assertCanPerformBrowserSwitch(activity);
                }
                catch (BrowserSwitchException browserSwitchException) {
                    PayPalClient.this.braintreeClient.sendAnalyticsEvent("paypal.invalid-manifest", PayPalClient.this.payPalContextId, null, PayPalClient.this.isVaultRequest.booleanValue());
                    Exception manifestInvalidError = PayPalClient.createBrowserSwitchError(browserSwitchException);
                    callback.onResult(manifestInvalidError);
                    return;
                }
                PayPalClient.this.sendPayPalRequest(activity, payPalCheckoutRequest, callback);
            }
        });
    }

    private void sendVaultRequest(final FragmentActivity activity, final PayPalVaultRequest payPalVaultRequest, final PayPalFlowStartedCallback callback) {
        this.braintreeClient.sendAnalyticsEvent("paypal.billing-agreement.selected", this.payPalContextId, null, this.isVaultRequest.booleanValue());
        if (payPalVaultRequest.getShouldOfferCredit()) {
            this.braintreeClient.sendAnalyticsEvent("paypal.billing-agreement.credit.offered", this.payPalContextId, null, this.isVaultRequest.booleanValue());
        }
        this.braintreeClient.getConfiguration(new ConfigurationCallback(){

            public void onResult(@Nullable Configuration configuration, @Nullable Exception error) {
                if (error != null) {
                    callback.onResult(error);
                    return;
                }
                if (PayPalClient.payPalConfigInvalid(configuration)) {
                    Exception configInvalidError = PayPalClient.createPayPalError();
                    callback.onResult(configInvalidError);
                    return;
                }
                try {
                    PayPalClient.this.assertCanPerformBrowserSwitch(activity);
                }
                catch (BrowserSwitchException browserSwitchException) {
                    PayPalClient.this.braintreeClient.sendAnalyticsEvent("paypal.invalid-manifest", PayPalClient.this.payPalContextId, null, PayPalClient.this.isVaultRequest.booleanValue());
                    Exception manifestInvalidError = PayPalClient.createBrowserSwitchError(browserSwitchException);
                    callback.onResult(manifestInvalidError);
                    return;
                }
                PayPalClient.this.sendPayPalRequest(activity, payPalVaultRequest, callback);
            }
        });
    }

    private void sendPayPalRequest(final FragmentActivity activity, final PayPalRequest payPalRequest, final PayPalFlowStartedCallback callback) {
        this.internalPayPalClient.sendRequest((Context)activity, payPalRequest, new PayPalInternalClientCallback(){

            @Override
            public void onResult(PayPalResponse payPalResponse, Exception error) {
                if (payPalResponse != null) {
                    String analyticsPrefix = PayPalClient.getAnalyticsEventPrefix(payPalRequest);
                    PayPalClient.this.braintreeClient.sendAnalyticsEvent(String.format("%s.browser-switch.started", analyticsPrefix), PayPalClient.this.payPalContextId, null, PayPalClient.this.isVaultRequest.booleanValue());
                    try {
                        PayPalClient.this.startBrowserSwitch(activity, payPalResponse);
                        callback.onResult(null);
                    }
                    catch (BrowserSwitchException | JSONException exception) {
                        callback.onResult((Exception)exception);
                    }
                } else {
                    callback.onResult(error);
                }
            }
        });
    }

    private void startBrowserSwitch(FragmentActivity activity, PayPalResponse payPalResponse) throws JSONException, BrowserSwitchException {
        JSONObject metadata = new JSONObject();
        metadata.put("approval-url", (Object)payPalResponse.getApprovalUrl());
        metadata.put("success-url", (Object)payPalResponse.getSuccessUrl());
        String paymentType = payPalResponse.isBillingAgreement() ? "billing-agreement" : "single-payment";
        metadata.put("payment-type", (Object)paymentType);
        metadata.put("client-metadata-id", (Object)payPalResponse.getClientMetadataId());
        metadata.put("merchant-account-id", (Object)payPalResponse.getMerchantAccountId());
        metadata.put("source", (Object)"paypal-browser");
        metadata.put("intent", (Object)payPalResponse.getIntent());
        BrowserSwitchOptions browserSwitchOptions = new BrowserSwitchOptions().requestCode(13591).url(Uri.parse((String)payPalResponse.getApprovalUrl())).returnUrlScheme(this.braintreeClient.getReturnUrlScheme()).launchAsNewTask(this.braintreeClient.launchesBrowserSwitchAsNewTask()).metadata(metadata);
        this.braintreeClient.startBrowserSwitch(activity, browserSwitchOptions);
    }

    private static String getAnalyticsEventPrefix(PayPalRequest request) {
        return request instanceof PayPalVaultRequest ? "paypal.billing-agreement" : "paypal.single-payment";
    }

    void onBrowserSwitchResult(@NonNull BrowserSwitchResult browserSwitchResult) {
        this.pendingBrowserSwitchResult = browserSwitchResult;
        if (this.listener != null) {
            this.deliverBrowserSwitchResultToListener(this.pendingBrowserSwitchResult);
        }
    }

    private void deliverBrowserSwitchResultToListener(BrowserSwitchResult browserSwitchResult) {
        this.onBrowserSwitchResult(browserSwitchResult, new PayPalBrowserSwitchResultCallback(){

            @Override
            public void onResult(@Nullable PayPalAccountNonce payPalAccountNonce, @Nullable Exception error) {
                if (payPalAccountNonce != null && PayPalClient.this.listener != null) {
                    PayPalClient.this.listener.onPayPalSuccess(payPalAccountNonce);
                } else if (error != null && PayPalClient.this.listener != null) {
                    PayPalClient.this.listener.onPayPalFailure(error);
                }
            }
        });
        this.pendingBrowserSwitchResult = null;
    }

    BrowserSwitchResult getBrowserSwitchResult(FragmentActivity activity) {
        return this.braintreeClient.getBrowserSwitchResult(activity);
    }

    BrowserSwitchResult deliverBrowserSwitchResult(FragmentActivity activity) {
        return this.braintreeClient.deliverBrowserSwitchResult(activity);
    }

    BrowserSwitchResult getBrowserSwitchResultFromNewTask(FragmentActivity activity) {
        return this.braintreeClient.getBrowserSwitchResultFromNewTask((Context)activity);
    }

    BrowserSwitchResult deliverBrowserSwitchResultFromNewTask(FragmentActivity activity) {
        return this.braintreeClient.deliverBrowserSwitchResultFromNewTask((Context)activity);
    }

    public void onBrowserSwitchResult(@NonNull BrowserSwitchResult browserSwitchResult, final @NonNull PayPalBrowserSwitchResultCallback callback) {
        String pairingId;
        String analyticsPrefix;
        if (browserSwitchResult == null) {
            callback.onResult(null, (Exception)new BraintreeException("BrowserSwitchResult cannot be null"));
            return;
        }
        JSONObject metadata = browserSwitchResult.getRequestMetadata();
        String clientMetadataId = Json.optString((JSONObject)metadata, (String)"client-metadata-id", null);
        String merchantAccountId = Json.optString((JSONObject)metadata, (String)"merchant-account-id", null);
        String payPalIntent = Json.optString((JSONObject)metadata, (String)"intent", null);
        String approvalUrl = Json.optString((JSONObject)metadata, (String)"approval-url", null);
        String successUrl = Json.optString((JSONObject)metadata, (String)"success-url", null);
        String paymentType = Json.optString((JSONObject)metadata, (String)"payment-type", (String)"unknown");
        boolean isBillingAgreement = paymentType.equalsIgnoreCase("billing-agreement");
        String tokenKey = isBillingAgreement ? "ba_token" : "token";
        String string = analyticsPrefix = isBillingAgreement ? "paypal.billing-agreement" : "paypal.single-payment";
        if (approvalUrl != null && (pairingId = Uri.parse((String)approvalUrl).getQueryParameter(tokenKey)) != null && !pairingId.isEmpty()) {
            this.payPalContextId = pairingId;
        }
        int result = browserSwitchResult.getStatus();
        switch (result) {
            case 2: {
                callback.onResult(null, (Exception)((Object)new UserCanceledException("User canceled PayPal.")));
                this.braintreeClient.sendAnalyticsEvent(String.format("%s.browser-switch.canceled", analyticsPrefix), this.payPalContextId, null, this.isVaultRequest.booleanValue());
                break;
            }
            case 1: {
                try {
                    Uri deepLinkUri = browserSwitchResult.getDeepLinkUrl();
                    if (deepLinkUri != null) {
                        JSONObject urlResponseData = this.parseUrlResponseData(deepLinkUri, successUrl, approvalUrl, tokenKey);
                        PayPalAccount payPalAccount = new PayPalAccount();
                        payPalAccount.setClientMetadataId(clientMetadataId);
                        payPalAccount.setIntent(payPalIntent);
                        payPalAccount.setSource("paypal-browser");
                        payPalAccount.setUrlResponseData(urlResponseData);
                        payPalAccount.setPaymentType(paymentType);
                        if (merchantAccountId != null) {
                            payPalAccount.setMerchantAccountId(merchantAccountId);
                        }
                        if (payPalIntent != null) {
                            payPalAccount.setIntent(payPalIntent);
                        }
                        this.internalPayPalClient.tokenize(payPalAccount, new PayPalBrowserSwitchResultCallback(){

                            @Override
                            public void onResult(@Nullable PayPalAccountNonce payPalAccountNonce, @Nullable Exception error) {
                                if (payPalAccountNonce != null && payPalAccountNonce.getCreditFinancing() != null) {
                                    PayPalClient.this.braintreeClient.sendAnalyticsEvent("paypal.credit.accepted", PayPalClient.this.payPalContextId, null, PayPalClient.this.isVaultRequest.booleanValue());
                                }
                                callback.onResult(payPalAccountNonce, error);
                            }
                        });
                        this.braintreeClient.sendAnalyticsEvent(String.format("%s.browser-switch.succeeded", analyticsPrefix), this.payPalContextId, null, this.isVaultRequest.booleanValue());
                        break;
                    }
                    callback.onResult(null, (Exception)new BraintreeException("Unknown error"));
                    break;
                }
                catch (UserCanceledException e) {
                    callback.onResult(null, (Exception)((Object)e));
                    this.braintreeClient.sendAnalyticsEvent(String.format("%s.browser-switch.canceled", analyticsPrefix), this.payPalContextId, null, this.isVaultRequest.booleanValue());
                    break;
                }
                catch (PayPalBrowserSwitchException | JSONException e) {
                    callback.onResult(null, (Exception)e);
                    this.braintreeClient.sendAnalyticsEvent(String.format("%s.browser-switch.failed", analyticsPrefix), this.payPalContextId, null, this.isVaultRequest.booleanValue());
                }
            }
        }
    }

    private JSONObject parseUrlResponseData(Uri uri, String successUrl, String approvalUrl, String tokenKey) throws JSONException, UserCanceledException, PayPalBrowserSwitchException {
        String status = uri.getLastPathSegment();
        if (!Uri.parse((String)successUrl).getLastPathSegment().equals(status)) {
            throw new UserCanceledException("User canceled PayPal.", true);
        }
        String requestXoToken = Uri.parse((String)approvalUrl).getQueryParameter(tokenKey);
        String responseXoToken = uri.getQueryParameter(tokenKey);
        if (responseXoToken != null && TextUtils.equals((CharSequence)requestXoToken, (CharSequence)responseXoToken)) {
            JSONObject client = new JSONObject();
            client.put("environment", null);
            JSONObject urlResponseData = new JSONObject();
            urlResponseData.put("client", (Object)client);
            JSONObject response = new JSONObject();
            response.put("webURL", (Object)uri.toString());
            urlResponseData.put("response", (Object)response);
            urlResponseData.put("response_type", (Object)"web");
            return urlResponseData;
        }
        throw new PayPalBrowserSwitchException("The response contained inconsistent data.");
    }
}

