/*
 * Decompiled with CFR 0.152.
 */
package com.braintreepayments.api;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.braintreepayments.api.Authorization;
import com.braintreepayments.api.ClientToken;
import com.braintreepayments.api.Configuration;
import com.braintreepayments.api.PayPalLineItem;
import com.braintreepayments.api.PayPalRequest;
import com.braintreepayments.api.PostalAddress;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class PayPalCheckoutRequest
extends PayPalRequest
implements Parcelable {
    public static final String USER_ACTION_DEFAULT = "";
    public static final String USER_ACTION_COMMIT = "commit";
    private String intent = "authorize";
    private String userAction = "";
    private final String amount;
    private String currencyCode;
    private boolean shouldRequestBillingAgreement;
    private boolean shouldOfferPayLater;
    public static final Parcelable.Creator<PayPalCheckoutRequest> CREATOR = new Parcelable.Creator<PayPalCheckoutRequest>(){

        public PayPalCheckoutRequest createFromParcel(Parcel in) {
            return new PayPalCheckoutRequest(in);
        }

        public PayPalCheckoutRequest[] newArray(int size) {
            return new PayPalCheckoutRequest[size];
        }
    };

    @Deprecated
    public PayPalCheckoutRequest(@NonNull String amount) {
        this(amount, false);
    }

    public PayPalCheckoutRequest(@NonNull String amount, boolean hasUserLocationConsent) {
        super(hasUserLocationConsent);
        this.amount = amount;
    }

    public void setCurrencyCode(@Nullable String currencyCode) {
        this.currencyCode = currencyCode;
    }

    public void setIntent(@NonNull String intent) {
        this.intent = intent;
    }

    public void setUserAction(@NonNull String userAction) {
        this.userAction = userAction;
    }

    public void setShouldOfferPayLater(boolean shouldOfferPayLater) {
        this.shouldOfferPayLater = shouldOfferPayLater;
    }

    public void setShouldRequestBillingAgreement(boolean shouldRequestBillingAgreement) {
        this.shouldRequestBillingAgreement = shouldRequestBillingAgreement;
    }

    @NonNull
    public String getAmount() {
        return this.amount;
    }

    @Nullable
    public String getCurrencyCode() {
        return this.currencyCode;
    }

    @NonNull
    public String getIntent() {
        return this.intent;
    }

    @NonNull
    public String getUserAction() {
        return this.userAction;
    }

    public boolean getShouldOfferPayLater() {
        return this.shouldOfferPayLater;
    }

    public boolean getShouldRequestBillingAgreement() {
        return this.shouldRequestBillingAgreement;
    }

    @Override
    String createRequestBody(Configuration configuration, Authorization authorization, String successUrl, String cancelUrl) throws JSONException {
        String currencyCode;
        JSONObject parameters = new JSONObject().put("return_url", (Object)successUrl).put("cancel_url", (Object)cancelUrl).put("offer_pay_later", this.shouldOfferPayLater);
        if (authorization instanceof ClientToken) {
            parameters.put("authorization_fingerprint", (Object)authorization.getBearer());
        } else {
            parameters.put("client_key", (Object)authorization.getBearer());
        }
        if (this.shouldRequestBillingAgreement) {
            parameters.put("request_billing_agreement", true);
        }
        String billingAgreementDescription = this.getBillingAgreementDescription();
        if (this.shouldRequestBillingAgreement && !TextUtils.isEmpty((CharSequence)billingAgreementDescription)) {
            JSONObject details = new JSONObject().put("description", (Object)billingAgreementDescription);
            parameters.put("billing_agreement_details", (Object)details);
        }
        if ((currencyCode = this.getCurrencyCode()) == null) {
            currencyCode = configuration.getPayPalCurrencyIsoCode();
        }
        parameters.put("amount", (Object)this.amount).put("currency_iso_code", (Object)currencyCode).put("intent", (Object)this.intent);
        if (!this.getLineItems().isEmpty()) {
            JSONArray lineItems = new JSONArray();
            for (PayPalLineItem lineItem : this.getLineItems()) {
                lineItems.put((Object)lineItem.toJson());
            }
            parameters.put("line_items", (Object)lineItems);
        }
        JSONObject experienceProfile = new JSONObject();
        experienceProfile.put("no_shipping", !this.isShippingAddressRequired());
        experienceProfile.put("landing_page_type", (Object)this.getLandingPageType());
        String displayName = this.getDisplayName();
        if (TextUtils.isEmpty((CharSequence)displayName)) {
            displayName = configuration.getPayPalDisplayName();
        }
        experienceProfile.put("brand_name", (Object)displayName);
        if (this.getLocaleCode() != null) {
            experienceProfile.put("locale_code", (Object)this.getLocaleCode());
        }
        if (this.getUserAction() != USER_ACTION_DEFAULT) {
            experienceProfile.put("user_action", (Object)this.getUserAction());
        }
        if (this.getShippingAddressOverride() != null) {
            experienceProfile.put("address_override", !this.isShippingAddressEditable());
            PostalAddress shippingAddress = this.getShippingAddressOverride();
            parameters.put("line1", (Object)shippingAddress.getStreetAddress());
            parameters.put("line2", (Object)shippingAddress.getExtendedAddress());
            parameters.put("city", (Object)shippingAddress.getLocality());
            parameters.put("state", (Object)shippingAddress.getRegion());
            parameters.put("postal_code", (Object)shippingAddress.getPostalCode());
            parameters.put("country_code", (Object)shippingAddress.getCountryCodeAlpha2());
            parameters.put("recipient_name", (Object)shippingAddress.getRecipientName());
        } else {
            experienceProfile.put("address_override", false);
        }
        if (this.getMerchantAccountId() != null) {
            parameters.put("merchant_account_id", (Object)this.getMerchantAccountId());
        }
        if (this.getRiskCorrelationId() != null) {
            parameters.put("correlation_id", (Object)this.getRiskCorrelationId());
        }
        parameters.put("experience_profile", (Object)experienceProfile);
        return parameters.toString();
    }

    PayPalCheckoutRequest(Parcel in) {
        super(in);
        this.intent = in.readString();
        this.userAction = in.readString();
        this.amount = in.readString();
        this.currencyCode = in.readString();
        this.shouldRequestBillingAgreement = in.readByte() != 0;
        this.shouldOfferPayLater = in.readByte() != 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        super.writeToParcel(dest, flags);
        dest.writeString(this.intent);
        dest.writeString(this.userAction);
        dest.writeString(this.amount);
        dest.writeString(this.currencyCode);
        dest.writeByte((byte)(this.shouldRequestBillingAgreement ? 1 : 0));
        dest.writeByte((byte)(this.shouldOfferPayLater ? 1 : 0));
    }

    @Override
    public int describeContents() {
        return 0;
    }
}

