/*
 * Decompiled with CFR 0.152.
 */
package com.braintreepayments.api;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.braintreepayments.api.Json;
import com.braintreepayments.api.PayPalCreditFinancing;
import com.braintreepayments.api.PaymentMethodNonce;
import com.braintreepayments.api.PostalAddress;
import com.braintreepayments.api.PostalAddressParser;
import org.json.JSONException;
import org.json.JSONObject;

public class PayPalAccountNonce
extends PaymentMethodNonce {
    static final String API_RESOURCE_KEY = "paypalAccounts";
    private static final String PAYMENT_METHOD_DATA_KEY = "paymentMethodData";
    private static final String TOKENIZATION_DATA_KEY = "tokenizationData";
    private static final String TOKEN_KEY = "token";
    private static final String PAYMENT_METHOD_NONCE_KEY = "nonce";
    private static final String PAYMENT_METHOD_DEFAULT_KEY = "default";
    private static final String CREDIT_FINANCING_KEY = "creditFinancingOffered";
    private static final String DETAILS_KEY = "details";
    private static final String EMAIL_KEY = "email";
    private static final String PAYER_INFO_KEY = "payerInfo";
    private static final String ACCOUNT_ADDRESS_KEY = "accountAddress";
    private static final String SHIPPING_ADDRESS_KEY = "shippingAddress";
    private static final String BILLING_ADDRESS_KEY = "billingAddress";
    private static final String FIRST_NAME_KEY = "firstName";
    private static final String LAST_NAME_KEY = "lastName";
    private static final String PHONE_KEY = "phone";
    private static final String PAYER_ID_KEY = "payerId";
    private static final String CLIENT_METADATA_ID_KEY = "correlationId";
    private final String clientMetadataId;
    private final PostalAddress billingAddress;
    private final PostalAddress shippingAddress;
    private final String firstName;
    private final String lastName;
    private final String phone;
    private final String email;
    private final String payerId;
    private final PayPalCreditFinancing creditFinancing;
    private final String authenticateUrl;
    public static final Parcelable.Creator<PayPalAccountNonce> CREATOR = new Parcelable.Creator<PayPalAccountNonce>(){

        public PayPalAccountNonce createFromParcel(Parcel source) {
            return new PayPalAccountNonce(source);
        }

        public PayPalAccountNonce[] newArray(int size) {
            return new PayPalAccountNonce[size];
        }
    };

    static PayPalAccountNonce fromJSON(JSONObject inputJson) throws JSONException {
        JSONObject shippingAddressJson;
        PostalAddress billingAddress;
        PostalAddress shippingAddress;
        JSONObject json;
        boolean getShippingAddressFromTopLevel = false;
        if (inputJson.has(API_RESOURCE_KEY)) {
            json = inputJson.getJSONArray(API_RESOURCE_KEY).getJSONObject(0);
        } else if (inputJson.has(PAYMENT_METHOD_DATA_KEY)) {
            getShippingAddressFromTopLevel = true;
            JSONObject tokenObj = new JSONObject(inputJson.getJSONObject(PAYMENT_METHOD_DATA_KEY).getJSONObject(TOKENIZATION_DATA_KEY).getString(TOKEN_KEY));
            json = tokenObj.getJSONArray(API_RESOURCE_KEY).getJSONObject(0);
        } else {
            json = inputJson;
        }
        String nonce = json.getString(PAYMENT_METHOD_NONCE_KEY);
        boolean isDefault = json.optBoolean(PAYMENT_METHOD_DEFAULT_KEY, false);
        String authenticateUrl = Json.optString((JSONObject)json, (String)"authenticateUrl", null);
        JSONObject details = json.getJSONObject(DETAILS_KEY);
        String email = Json.optString((JSONObject)details, (String)EMAIL_KEY, null);
        String clientMetadataId = Json.optString((JSONObject)details, (String)CLIENT_METADATA_ID_KEY, null);
        PayPalCreditFinancing payPalCreditFinancing = null;
        String firstName = null;
        String lastName = null;
        String phone = null;
        String payerId = null;
        try {
            if (details.has(CREDIT_FINANCING_KEY)) {
                JSONObject creditFinancing = details.getJSONObject(CREDIT_FINANCING_KEY);
                payPalCreditFinancing = PayPalCreditFinancing.fromJson(creditFinancing);
            }
            JSONObject payerInfo = details.getJSONObject(PAYER_INFO_KEY);
            JSONObject billingAddressJson = payerInfo.optJSONObject(BILLING_ADDRESS_KEY);
            if (payerInfo.has(ACCOUNT_ADDRESS_KEY)) {
                billingAddressJson = payerInfo.optJSONObject(ACCOUNT_ADDRESS_KEY);
            }
            shippingAddress = PostalAddressParser.fromJson((JSONObject)payerInfo.optJSONObject(SHIPPING_ADDRESS_KEY));
            billingAddress = PostalAddressParser.fromJson((JSONObject)billingAddressJson);
            firstName = Json.optString((JSONObject)payerInfo, (String)FIRST_NAME_KEY, (String)"");
            lastName = Json.optString((JSONObject)payerInfo, (String)LAST_NAME_KEY, (String)"");
            phone = Json.optString((JSONObject)payerInfo, (String)PHONE_KEY, (String)"");
            payerId = Json.optString((JSONObject)payerInfo, (String)PAYER_ID_KEY, (String)"");
            if (email == null) {
                email = Json.optString((JSONObject)payerInfo, (String)EMAIL_KEY, null);
            }
        }
        catch (JSONException e) {
            billingAddress = new PostalAddress();
            shippingAddress = new PostalAddress();
        }
        if (getShippingAddressFromTopLevel && (shippingAddressJson = json.optJSONObject(SHIPPING_ADDRESS_KEY)) != null) {
            shippingAddress = PostalAddressParser.fromJson((JSONObject)shippingAddressJson);
        }
        return new PayPalAccountNonce(clientMetadataId, billingAddress, shippingAddress, firstName, lastName, phone, email, payerId, payPalCreditFinancing, authenticateUrl, nonce, isDefault);
    }

    private PayPalAccountNonce(String clientMetadataId, PostalAddress billingAddress, PostalAddress shippingAddress, String firstName, String lastName, String phone, String email, String payerId, PayPalCreditFinancing creditFinancing, String authenticateUrl, String nonce, boolean isDefault) {
        super(nonce, isDefault);
        this.clientMetadataId = clientMetadataId;
        this.billingAddress = billingAddress;
        this.shippingAddress = shippingAddress;
        this.firstName = firstName;
        this.lastName = lastName;
        this.phone = phone;
        this.email = email;
        this.payerId = payerId;
        this.creditFinancing = creditFinancing;
        this.authenticateUrl = authenticateUrl;
    }

    @Nullable
    public String getEmail() {
        return this.email;
    }

    @NonNull
    public PostalAddress getBillingAddress() {
        return this.billingAddress;
    }

    @NonNull
    public PostalAddress getShippingAddress() {
        return this.shippingAddress;
    }

    @NonNull
    public String getFirstName() {
        return this.firstName;
    }

    @NonNull
    public String getLastName() {
        return this.lastName;
    }

    @NonNull
    public String getPhone() {
        return this.phone;
    }

    @Nullable
    public String getClientMetadataId() {
        return this.clientMetadataId;
    }

    @NonNull
    public String getPayerId() {
        return this.payerId;
    }

    @Nullable
    public PayPalCreditFinancing getCreditFinancing() {
        return this.creditFinancing;
    }

    @Nullable
    public String getAuthenticateUrl() {
        return this.authenticateUrl;
    }

    public void writeToParcel(Parcel dest, int flags) {
        super.writeToParcel(dest, flags);
        dest.writeString(this.clientMetadataId);
        dest.writeParcelable((Parcelable)this.billingAddress, flags);
        dest.writeParcelable((Parcelable)this.shippingAddress, flags);
        dest.writeString(this.firstName);
        dest.writeString(this.lastName);
        dest.writeString(this.email);
        dest.writeString(this.phone);
        dest.writeString(this.payerId);
        dest.writeParcelable((Parcelable)this.creditFinancing, flags);
        dest.writeString(this.authenticateUrl);
    }

    private PayPalAccountNonce(Parcel in) {
        super(in);
        this.clientMetadataId = in.readString();
        this.billingAddress = (PostalAddress)in.readParcelable(PostalAddress.class.getClassLoader());
        this.shippingAddress = (PostalAddress)in.readParcelable(PostalAddress.class.getClassLoader());
        this.firstName = in.readString();
        this.lastName = in.readString();
        this.email = in.readString();
        this.phone = in.readString();
        this.payerId = in.readString();
        this.creditFinancing = (PayPalCreditFinancing)in.readParcelable(PayPalCreditFinancing.class.getClassLoader());
        this.authenticateUrl = in.readString();
    }
}

