/*
 * Decompiled with CFR 0.152.
 */
package com.braintreepayments.api;

import androidx.annotation.RestrictTo;
import com.braintreepayments.api.PaymentMethod;
import java.util.Iterator;
import org.json.JSONException;
import org.json.JSONObject;

class PayPalAccount
extends PaymentMethod {
    private static final String PAYPAL_ACCOUNT_KEY = "paypalAccount";
    private static final String CORRELATION_ID_KEY = "correlationId";
    private static final String INTENT_KEY = "intent";
    private static final String MERCHANT_ACCOUNT_ID_KEY = "merchant_account_id";
    private String clientMetadataId;
    private JSONObject urlResponseData = new JSONObject();
    private String intent;
    private String merchantAccountId;
    private String paymentType;

    PayPalAccount() {
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public JSONObject buildJSON() throws JSONException {
        JSONObject json = super.buildJSON();
        JSONObject paymentMethodNonceJson = new JSONObject();
        paymentMethodNonceJson.put(CORRELATION_ID_KEY, (Object)this.clientMetadataId);
        paymentMethodNonceJson.put(INTENT_KEY, (Object)this.intent);
        if ("single-payment".equalsIgnoreCase(this.paymentType)) {
            JSONObject optionsJson = new JSONObject();
            optionsJson.put("validate", false);
            paymentMethodNonceJson.put("options", (Object)optionsJson);
        }
        Iterator urlResponseDataKeyIterator = this.urlResponseData.keys();
        while (urlResponseDataKeyIterator.hasNext()) {
            String key = (String)urlResponseDataKeyIterator.next();
            paymentMethodNonceJson.put(key, this.urlResponseData.get(key));
        }
        if (this.merchantAccountId != null) {
            json.put(MERCHANT_ACCOUNT_ID_KEY, (Object)this.merchantAccountId);
        }
        json.put(PAYPAL_ACCOUNT_KEY, (Object)paymentMethodNonceJson);
        return json;
    }

    void setClientMetadataId(String clientMetadataId) {
        this.clientMetadataId = clientMetadataId;
    }

    void setUrlResponseData(JSONObject urlResponseData) {
        if (urlResponseData != null) {
            this.urlResponseData = urlResponseData;
        }
    }

    void setIntent(String intent) {
        this.intent = intent;
    }

    void setMerchantAccountId(String merchantAccountId) {
        this.merchantAccountId = merchantAccountId;
    }

    void setPaymentType(String paymentType) {
        this.paymentType = paymentType;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public String getApiPath() {
        return "paypal_accounts";
    }
}

