/*
 * Decompiled with CFR 0.152.
 */
package com.braintreepayments.api;

import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import androidx.activity.ComponentActivity;
import androidx.annotation.NonNull;
import androidx.annotation.VisibleForTesting;
import com.braintreepayments.api.BrowserSwitchException;
import com.braintreepayments.api.BrowserSwitchFinalResult;
import com.braintreepayments.api.BrowserSwitchInspector;
import com.braintreepayments.api.BrowserSwitchOptions;
import com.braintreepayments.api.BrowserSwitchRequest;
import com.braintreepayments.api.BrowserSwitchStartResult;
import com.braintreepayments.api.ChromeCustomTabsInternalClient;
import com.braintreepayments.api.browserswitch.R;
import org.json.JSONObject;

public class BrowserSwitchClient {
    private final BrowserSwitchInspector browserSwitchInspector;
    private final ChromeCustomTabsInternalClient customTabsInternalClient;

    public BrowserSwitchClient() {
        this(new BrowserSwitchInspector(), new ChromeCustomTabsInternalClient());
    }

    @VisibleForTesting
    BrowserSwitchClient(BrowserSwitchInspector browserSwitchInspector, ChromeCustomTabsInternalClient customTabsInternalClient) {
        this.browserSwitchInspector = browserSwitchInspector;
        this.customTabsInternalClient = customTabsInternalClient;
    }

    @NonNull
    public BrowserSwitchStartResult start(@NonNull ComponentActivity activity, @NonNull BrowserSwitchOptions browserSwitchOptions) {
        try {
            this.assertCanPerformBrowserSwitch(activity, browserSwitchOptions);
        }
        catch (BrowserSwitchException e) {
            return new BrowserSwitchStartResult.Failure(e);
        }
        Uri browserSwitchUrl = browserSwitchOptions.getUrl();
        int requestCode = browserSwitchOptions.getRequestCode();
        String returnUrlScheme = browserSwitchOptions.getReturnUrlScheme();
        Uri appLinkUri = browserSwitchOptions.getAppLinkUri();
        JSONObject metadata = browserSwitchOptions.getMetadata();
        if (activity.isFinishing()) {
            String activityFinishingMessage = "Unable to start browser switch while host Activity is finishing.";
            return new BrowserSwitchStartResult.Failure(new BrowserSwitchException(activityFinishingMessage));
        }
        boolean launchAsNewTask = browserSwitchOptions.isLaunchAsNewTask();
        try {
            BrowserSwitchRequest request = new BrowserSwitchRequest(requestCode, browserSwitchUrl, metadata, returnUrlScheme, appLinkUri);
            this.customTabsInternalClient.launchUrl((Context)activity, browserSwitchUrl, launchAsNewTask);
            return new BrowserSwitchStartResult.Started(request.toBase64EncodedJSON());
        }
        catch (ActivityNotFoundException | BrowserSwitchException e) {
            return new BrowserSwitchStartResult.Failure(new BrowserSwitchException("Unable to start browser switch without a web browser.", (Exception)e));
        }
    }

    public void assertCanPerformBrowserSwitch(ComponentActivity activity, BrowserSwitchOptions browserSwitchOptions) throws BrowserSwitchException {
        Context appContext = activity.getApplicationContext();
        int requestCode = browserSwitchOptions.getRequestCode();
        String returnUrlScheme = browserSwitchOptions.getReturnUrlScheme();
        String errorMessage = null;
        if (!this.isValidRequestCode(requestCode)) {
            errorMessage = activity.getString(R.string.error_request_code_invalid);
        } else if (returnUrlScheme == null && browserSwitchOptions.getAppLinkUri() == null) {
            errorMessage = activity.getString(R.string.error_app_link_uri_or_return_url_required);
        } else if (returnUrlScheme != null && !this.browserSwitchInspector.isDeviceConfiguredForDeepLinking(appContext, returnUrlScheme)) {
            errorMessage = activity.getString(R.string.error_device_not_configured_for_deep_link);
        }
        if (errorMessage != null) {
            throw new BrowserSwitchException(errorMessage);
        }
    }

    private boolean isValidRequestCode(int requestCode) {
        return requestCode != Integer.MIN_VALUE;
    }

    public BrowserSwitchFinalResult completeRequest(@NonNull Intent intent, @NonNull String pendingRequest) {
        if (intent != null && intent.getData() != null) {
            Uri returnUrl = intent.getData();
            try {
                BrowserSwitchRequest pr = BrowserSwitchRequest.fromBase64EncodedJSON(pendingRequest);
                if (returnUrl != null && (pr.matchesDeepLinkUrlScheme(returnUrl) || pr.matchesAppLinkUri(returnUrl))) {
                    return new BrowserSwitchFinalResult.Success(returnUrl, pr);
                }
            }
            catch (BrowserSwitchException e) {
                throw new RuntimeException(e);
            }
        }
        return BrowserSwitchFinalResult.NoResult.INSTANCE;
    }
}

