/*
 * Decompiled with CFR 0.152.
 */
package com.braintreepayments.api.models;

import com.braintreepayments.api.Json;
import com.braintreepayments.api.models.CardConfiguration;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.json.JSONObject;

public class VisaCheckoutConfiguration {
    private boolean mIsEnabled;
    private String mApiKey;
    private String mExternalClientId;
    private List<String> mCardBrands;

    static VisaCheckoutConfiguration fromJson(JSONObject json) {
        VisaCheckoutConfiguration visaCheckoutConfiguration = new VisaCheckoutConfiguration();
        if (json == null) {
            json = new JSONObject();
        }
        visaCheckoutConfiguration.mApiKey = Json.optString((JSONObject)json, (String)"apikey", (String)"");
        visaCheckoutConfiguration.mIsEnabled = !visaCheckoutConfiguration.mApiKey.equals("");
        visaCheckoutConfiguration.mExternalClientId = Json.optString((JSONObject)json, (String)"externalClientId", (String)"");
        visaCheckoutConfiguration.mCardBrands = VisaCheckoutConfiguration.supportedCardTypesToAcceptedCardBrands(CardConfiguration.fromJson(json).getSupportedCardTypes());
        return visaCheckoutConfiguration;
    }

    public boolean isEnabled() {
        return this.mIsEnabled;
    }

    public String getExternalClientId() {
        return this.mExternalClientId;
    }

    public String getApiKey() {
        return this.mApiKey;
    }

    public List<String> getAcceptedCardBrands() {
        return this.mCardBrands;
    }

    private static List<String> supportedCardTypesToAcceptedCardBrands(Set<String> supportedCardTypes) {
        ArrayList<String> acceptedCardBrands = new ArrayList<String>();
        for (String supportedCardType : supportedCardTypes) {
            switch (supportedCardType.toLowerCase(Locale.ROOT)) {
                case "visa": {
                    acceptedCardBrands.add("VISA");
                    break;
                }
                case "mastercard": {
                    acceptedCardBrands.add("MASTERCARD");
                    break;
                }
                case "discover": {
                    acceptedCardBrands.add("DISCOVER");
                    break;
                }
                case "american express": {
                    acceptedCardBrands.add("AMEX");
                }
            }
        }
        return acceptedCardBrands;
    }
}

