/*
 * Decompiled with CFR 0.152.
 */
package com.braintreepayments.api.models;

import android.os.Parcel;
import android.os.Parcelable;
import com.braintreepayments.api.models.ThreeDSecureAdditionalInformation;
import com.braintreepayments.api.models.ThreeDSecurePostalAddress;
import com.braintreepayments.api.models.ThreeDSecureV1UiCustomization;
import com.cardinalcommerce.shared.userinterfaces.UiCustomization;
import java.io.Serializable;
import org.json.JSONException;
import org.json.JSONObject;

public class ThreeDSecureRequest
implements Parcelable {
    public static final String VERSION_1 = "1";
    public static final String VERSION_2 = "2";
    private String mNonce;
    private String mAmount;
    private String mMobilePhoneNumber;
    private String mEmail;
    private String mShippingMethod;
    private ThreeDSecurePostalAddress mBillingAddress;
    private String mVersionRequested = "1";
    private ThreeDSecureAdditionalInformation mAdditionalInformation;
    private boolean mChallengeRequested = false;
    private boolean mExemptionRequested = false;
    private UiCustomization mUiCustomization;
    private ThreeDSecureV1UiCustomization mV1UiCustomization;
    public static final Parcelable.Creator<ThreeDSecureRequest> CREATOR = new Parcelable.Creator<ThreeDSecureRequest>(){

        public ThreeDSecureRequest createFromParcel(Parcel source) {
            return new ThreeDSecureRequest(source);
        }

        public ThreeDSecureRequest[] newArray(int size) {
            return new ThreeDSecureRequest[size];
        }
    };

    public ThreeDSecureRequest nonce(String nonce) {
        this.mNonce = nonce;
        return this;
    }

    public ThreeDSecureRequest amount(String amount) {
        this.mAmount = amount;
        return this;
    }

    public ThreeDSecureRequest mobilePhoneNumber(String mobilePhoneNumber) {
        this.mMobilePhoneNumber = mobilePhoneNumber;
        return this;
    }

    public ThreeDSecureRequest email(String email) {
        this.mEmail = email;
        return this;
    }

    public ThreeDSecureRequest shippingMethod(String shippingMethod) {
        this.mShippingMethod = shippingMethod;
        return this;
    }

    public ThreeDSecureRequest billingAddress(ThreeDSecurePostalAddress billingAddress) {
        this.mBillingAddress = billingAddress;
        return this;
    }

    public ThreeDSecureRequest versionRequested(String versionRequested) {
        this.mVersionRequested = versionRequested;
        return this;
    }

    public ThreeDSecureRequest additionalInformation(ThreeDSecureAdditionalInformation additionalInformation) {
        this.mAdditionalInformation = additionalInformation;
        return this;
    }

    public ThreeDSecureRequest challengeRequested(boolean challengeRequested) {
        this.mChallengeRequested = challengeRequested;
        return this;
    }

    public ThreeDSecureRequest exemptionRequested(boolean exemptionRequested) {
        this.mExemptionRequested = exemptionRequested;
        return this;
    }

    public ThreeDSecureRequest uiCustomization(UiCustomization uiCustomization) {
        this.mUiCustomization = uiCustomization;
        return this;
    }

    public ThreeDSecureRequest v1UiCustomization(ThreeDSecureV1UiCustomization v1UiCustomization) {
        this.mV1UiCustomization = v1UiCustomization;
        return this;
    }

    public String getNonce() {
        return this.mNonce;
    }

    public String getAmount() {
        return this.mAmount;
    }

    public String getMobilePhoneNumber() {
        return this.mMobilePhoneNumber;
    }

    public String getEmail() {
        return this.mEmail;
    }

    public String getShippingMethod() {
        return this.mShippingMethod;
    }

    public ThreeDSecurePostalAddress getBillingAddress() {
        return this.mBillingAddress;
    }

    public String getVersionRequested() {
        return this.mVersionRequested;
    }

    public ThreeDSecureAdditionalInformation getAdditionalInformation() {
        return this.mAdditionalInformation;
    }

    public boolean isChallengeRequested() {
        return this.mChallengeRequested;
    }

    public boolean isExemptionRequested() {
        return this.mExemptionRequested;
    }

    public UiCustomization getUiCustomization() {
        return this.mUiCustomization;
    }

    public ThreeDSecureV1UiCustomization getV1UiCustomization() {
        return this.mV1UiCustomization;
    }

    public ThreeDSecureRequest() {
        this.mUiCustomization = new UiCustomization();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.mNonce);
        dest.writeString(this.mAmount);
        dest.writeString(this.mMobilePhoneNumber);
        dest.writeString(this.mEmail);
        dest.writeString(this.mShippingMethod);
        dest.writeParcelable((Parcelable)this.mBillingAddress, flags);
        dest.writeString(this.mVersionRequested);
        dest.writeParcelable((Parcelable)this.mAdditionalInformation, flags);
        dest.writeByte(this.mChallengeRequested ? (byte)1 : 0);
        dest.writeByte(this.mExemptionRequested ? (byte)1 : 0);
        dest.writeSerializable((Serializable)this.mUiCustomization);
        dest.writeParcelable((Parcelable)this.mV1UiCustomization, flags);
    }

    public ThreeDSecureRequest(Parcel in) {
        this.mNonce = in.readString();
        this.mAmount = in.readString();
        this.mMobilePhoneNumber = in.readString();
        this.mEmail = in.readString();
        this.mShippingMethod = in.readString();
        this.mBillingAddress = (ThreeDSecurePostalAddress)in.readParcelable(ThreeDSecurePostalAddress.class.getClassLoader());
        this.mVersionRequested = in.readString();
        this.mAdditionalInformation = (ThreeDSecureAdditionalInformation)in.readParcelable(ThreeDSecureAdditionalInformation.class.getClassLoader());
        this.mChallengeRequested = in.readByte() > 0;
        this.mExemptionRequested = in.readByte() > 0;
        this.mUiCustomization = (UiCustomization)in.readSerializable();
        this.mV1UiCustomization = (ThreeDSecureV1UiCustomization)in.readParcelable(ThreeDSecureV1UiCustomization.class.getClassLoader());
    }

    public String build(String dfReferenceId) {
        JSONObject base = new JSONObject();
        ThreeDSecurePostalAddress billing = this.getBillingAddress();
        JSONObject additionalInfo = this.getAdditionalInformation() == null ? new JSONObject() : this.getAdditionalInformation().toJson();
        try {
            base.put("amount", (Object)this.mAmount);
            base.put("additional_info", (Object)additionalInfo);
            additionalInfo.putOpt("mobile_phone_number", (Object)this.getMobilePhoneNumber());
            additionalInfo.putOpt("shipping_method", (Object)this.getShippingMethod());
            additionalInfo.putOpt("email", (Object)this.getEmail());
            if (billing != null) {
                additionalInfo.putOpt("billing_given_name", (Object)billing.getGivenName());
                additionalInfo.putOpt("billing_surname", (Object)billing.getSurname());
                additionalInfo.putOpt("billing_line1", (Object)billing.getStreetAddress());
                additionalInfo.putOpt("billing_line2", (Object)billing.getExtendedAddress());
                additionalInfo.putOpt("billing_line3", (Object)billing.getLine3());
                additionalInfo.putOpt("billing_city", (Object)billing.getLocality());
                additionalInfo.putOpt("billing_state", (Object)billing.getRegion());
                additionalInfo.putOpt("billing_postal_code", (Object)billing.getPostalCode());
                additionalInfo.putOpt("billing_country_code", (Object)billing.getCountryCodeAlpha2());
                additionalInfo.putOpt("billing_phone_number", (Object)billing.getPhoneNumber());
            }
            if (VERSION_2.equals(this.getVersionRequested())) {
                base.putOpt("df_reference_id", (Object)dfReferenceId);
            }
            base.put("challenge_requested", this.mChallengeRequested);
            base.put("exemption_requested", this.mExemptionRequested);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return base.toString();
    }
}

