/*
 * Decompiled with CFR 0.152.
 */
package com.braintreepayments.api.models;

import android.os.Parcel;
import android.os.Parcelable;
import com.braintreepayments.api.Json;
import com.braintreepayments.api.models.CardNonce;
import org.json.JSONException;
import org.json.JSONObject;

public class ThreeDSecureLookup
implements Parcelable {
    private static final String CARD_NONCE_KEY = "paymentMethod";
    private static final String LOOKUP_KEY = "lookup";
    private static final String ACS_URL_KEY = "acsUrl";
    private static final String MD_KEY = "md";
    private static final String TERM_URL_KEY = "termUrl";
    private static final String PA_REQ_KEY = "pareq";
    private static final String THREE_D_SECURE_VERSION_KEY = "threeDSecureVersion";
    private static final String TRANSACTION_ID_KEY = "transactionId";
    private CardNonce mCardNonce;
    private String mAcsUrl;
    private String mMd;
    private String mTermUrl;
    private String mPareq;
    private String mThreeDSecureVersion;
    private String mTransactionId;
    public static final Parcelable.Creator<ThreeDSecureLookup> CREATOR = new Parcelable.Creator<ThreeDSecureLookup>(){

        public ThreeDSecureLookup createFromParcel(Parcel source) {
            return new ThreeDSecureLookup(source);
        }

        public ThreeDSecureLookup[] newArray(int size) {
            return new ThreeDSecureLookup[size];
        }
    };

    public static ThreeDSecureLookup fromJson(String jsonString) throws JSONException {
        JSONObject json = new JSONObject(jsonString);
        ThreeDSecureLookup lookup = new ThreeDSecureLookup();
        CardNonce cardNonce = new CardNonce();
        cardNonce.fromJson(json.getJSONObject(CARD_NONCE_KEY));
        lookup.mCardNonce = cardNonce;
        JSONObject lookupJson = json.getJSONObject(LOOKUP_KEY);
        lookup.mAcsUrl = lookupJson.isNull(ACS_URL_KEY) ? null : lookupJson.getString(ACS_URL_KEY);
        lookup.mMd = lookupJson.getString(MD_KEY);
        lookup.mTermUrl = lookupJson.getString(TERM_URL_KEY);
        lookup.mPareq = lookupJson.getString(PA_REQ_KEY);
        lookup.mThreeDSecureVersion = Json.optString((JSONObject)lookupJson, (String)THREE_D_SECURE_VERSION_KEY, (String)"");
        lookup.mTransactionId = Json.optString((JSONObject)lookupJson, (String)TRANSACTION_ID_KEY, (String)"");
        return lookup;
    }

    public CardNonce getCardNonce() {
        return this.mCardNonce;
    }

    public String getAcsUrl() {
        return this.mAcsUrl;
    }

    public String getMd() {
        return this.mMd;
    }

    public String getTermUrl() {
        return this.mTermUrl;
    }

    public String getPareq() {
        return this.mPareq;
    }

    public String getThreeDSecureVersion() {
        return this.mThreeDSecureVersion;
    }

    public String getTransactionId() {
        return this.mTransactionId;
    }

    public boolean requiresUserAuthentication() {
        return this.mAcsUrl != null;
    }

    public ThreeDSecureLookup() {
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeParcelable((Parcelable)this.mCardNonce, flags);
        dest.writeString(this.mAcsUrl);
        dest.writeString(this.mMd);
        dest.writeString(this.mTermUrl);
        dest.writeString(this.mPareq);
        dest.writeString(this.mThreeDSecureVersion);
        dest.writeString(this.mTransactionId);
    }

    private ThreeDSecureLookup(Parcel in) {
        this.mCardNonce = (CardNonce)in.readParcelable(CardNonce.class.getClassLoader());
        this.mAcsUrl = in.readString();
        this.mMd = in.readString();
        this.mTermUrl = in.readString();
        this.mPareq = in.readString();
        this.mThreeDSecureVersion = in.readString();
        this.mTransactionId = in.readString();
    }
}

