/*
 * Decompiled with CFR 0.152.
 */
package com.braintreepayments.api.models;

import android.os.Parcel;
import android.os.Parcelable;
import com.braintreepayments.api.models.ThreeDSecureAuthenticationResponse;
import org.json.JSONObject;

public class ThreeDSecureInfo
implements Parcelable {
    private static final String CAVV_KEY = "cavv";
    private static final String DS_TRANSACTION_ID_KEY = "dsTransactionId";
    private static final String ECI_FLAG_KEY = "eciFlag";
    private static final String ENROLLED_KEY = "enrolled";
    private static final String LIABILITY_SHIFTED_KEY = "liabilityShifted";
    private static final String LIABILITY_SHIFT_POSSIBLE_KEY = "liabilityShiftPossible";
    private static final String STATUS_KEY = "status";
    private static final String THREE_D_SECURE_VERSION_KEY = "threeDSecureVersion";
    private static final String XID_KEY = "xid";
    private static final String ACS_TRANSACTION_ID_KEY = "acsTransactionId";
    private static final String THREE_D_SECURE_AUTHENTICATION_ID_KEY = "threeDSecureAuthenticationId";
    private static final String THREE_D_SECURE_SERVER_TRANSACTION_ID_KEY = "threeDSecureServerTransactionId";
    private static final String PARES_STATUS_KEY = "paresStatus";
    private static final String AUTHENTICATION_KEY = "authentication";
    private static final String LOOKUP_KEY = "lookup";
    private static final String TRANS_STATUS_KEY = "transStatus";
    private static final String TRANS_STATUS_REASON_KEY = "transStatusReason";
    private String mCavv;
    private String mDsTransactionId;
    private String mEciFlag;
    private String mEnrolled;
    private boolean mLiabilityShifted;
    private boolean mLiabilityShiftPossible;
    private String mStatus;
    private ThreeDSecureAuthenticationResponse mThreeDSecureAuthenticationResponse;
    private String mThreeDSecureVersion;
    private boolean mWasVerified;
    private String mXid;
    private String mAcsTransactionId;
    private String mThreeDSecureAuthenticationId;
    private String mThreeDSecureServerTransactionId;
    private String mParesStatus;
    private String mAuthenticationTransactionStatus;
    private String mAuthenticationTransactionStatusReason;
    private String mLookupTransactionStatus;
    private String mLookupTransactionStatusReason;
    private String mErrorMessage;
    public static final Parcelable.Creator<ThreeDSecureInfo> CREATOR = new Parcelable.Creator<ThreeDSecureInfo>(){

        public ThreeDSecureInfo createFromParcel(Parcel source) {
            return new ThreeDSecureInfo(source);
        }

        public ThreeDSecureInfo[] newArray(int size) {
            return new ThreeDSecureInfo[size];
        }
    };

    protected static ThreeDSecureInfo fromJson(JSONObject json) {
        JSONObject lookupJson;
        if (json == null) {
            json = new JSONObject();
        }
        ThreeDSecureInfo threeDSecureInfo = new ThreeDSecureInfo();
        threeDSecureInfo.mCavv = json.optString(CAVV_KEY);
        threeDSecureInfo.mDsTransactionId = json.optString(DS_TRANSACTION_ID_KEY);
        threeDSecureInfo.mEciFlag = json.optString(ECI_FLAG_KEY);
        threeDSecureInfo.mEnrolled = json.optString(ENROLLED_KEY);
        threeDSecureInfo.mLiabilityShifted = json.optBoolean(LIABILITY_SHIFTED_KEY);
        threeDSecureInfo.mLiabilityShiftPossible = json.optBoolean(LIABILITY_SHIFT_POSSIBLE_KEY);
        threeDSecureInfo.mStatus = json.optString(STATUS_KEY);
        threeDSecureInfo.mThreeDSecureVersion = json.optString(THREE_D_SECURE_VERSION_KEY);
        threeDSecureInfo.mWasVerified = json.has(LIABILITY_SHIFTED_KEY) && json.has(LIABILITY_SHIFT_POSSIBLE_KEY);
        threeDSecureInfo.mXid = json.optString(XID_KEY);
        threeDSecureInfo.mAcsTransactionId = json.optString(ACS_TRANSACTION_ID_KEY);
        threeDSecureInfo.mThreeDSecureAuthenticationId = json.optString(THREE_D_SECURE_AUTHENTICATION_ID_KEY);
        threeDSecureInfo.mThreeDSecureServerTransactionId = json.optString(THREE_D_SECURE_SERVER_TRANSACTION_ID_KEY);
        threeDSecureInfo.mParesStatus = json.optString(PARES_STATUS_KEY);
        JSONObject authenticationJson = json.optJSONObject(AUTHENTICATION_KEY);
        if (authenticationJson != null) {
            threeDSecureInfo.mAuthenticationTransactionStatus = authenticationJson.optString(TRANS_STATUS_KEY);
            threeDSecureInfo.mAuthenticationTransactionStatusReason = authenticationJson.optString(TRANS_STATUS_REASON_KEY);
        }
        if ((lookupJson = json.optJSONObject(LOOKUP_KEY)) != null) {
            threeDSecureInfo.mLookupTransactionStatus = lookupJson.optString(TRANS_STATUS_KEY);
            threeDSecureInfo.mLookupTransactionStatusReason = lookupJson.optString(TRANS_STATUS_REASON_KEY);
        }
        return threeDSecureInfo;
    }

    protected void setThreeDSecureAuthenticationResponse(ThreeDSecureAuthenticationResponse authResponse) {
        this.mThreeDSecureAuthenticationResponse = authResponse;
    }

    public void setErrorMessage(String errorMessage) {
        this.mErrorMessage = errorMessage;
    }

    public String getCavv() {
        return this.mCavv;
    }

    public String getDsTransactionId() {
        return this.mDsTransactionId;
    }

    public String getEciFlag() {
        return this.mEciFlag;
    }

    public String getEnrolled() {
        return this.mEnrolled;
    }

    public boolean isLiabilityShifted() {
        return this.mLiabilityShifted;
    }

    public boolean isLiabilityShiftPossible() {
        return this.mLiabilityShiftPossible;
    }

    public String getStatus() {
        return this.mStatus;
    }

    public String getThreeDSecureVersion() {
        return this.mThreeDSecureVersion;
    }

    public boolean wasVerified() {
        return this.mWasVerified;
    }

    public String getXid() {
        return this.mXid;
    }

    public String getAcsTransactionId() {
        return this.mAcsTransactionId;
    }

    public String getThreeDSecureAuthenticationId() {
        return this.mThreeDSecureAuthenticationId;
    }

    public String getThreeDSecureServerTransactionId() {
        return this.mThreeDSecureServerTransactionId;
    }

    public String getParesStatus() {
        return this.mParesStatus;
    }

    public ThreeDSecureAuthenticationResponse getThreeDSecureAuthenticationResponse() {
        return this.mThreeDSecureAuthenticationResponse;
    }

    public String getAuthenticationTransactionStatus() {
        return this.mAuthenticationTransactionStatus;
    }

    public String getAuthenticationTransactionStatusReason() {
        return this.mAuthenticationTransactionStatusReason;
    }

    public String getLookupTransactionStatus() {
        return this.mLookupTransactionStatus;
    }

    public String getLookupTransactionStatusReason() {
        return this.mLookupTransactionStatusReason;
    }

    public String getErrorMessage() {
        return this.mErrorMessage;
    }

    public ThreeDSecureInfo() {
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.mCavv);
        dest.writeString(this.mDsTransactionId);
        dest.writeString(this.mEciFlag);
        dest.writeString(this.mEnrolled);
        dest.writeByte(this.mLiabilityShifted ? (byte)1 : 0);
        dest.writeByte(this.mLiabilityShiftPossible ? (byte)1 : 0);
        dest.writeString(this.mStatus);
        dest.writeString(this.mThreeDSecureVersion);
        dest.writeByte(this.mWasVerified ? (byte)1 : 0);
        dest.writeString(this.mXid);
        dest.writeString(this.mAuthenticationTransactionStatus);
        dest.writeString(this.mAuthenticationTransactionStatusReason);
        dest.writeString(this.mLookupTransactionStatus);
        dest.writeString(this.mLookupTransactionStatusReason);
        dest.writeString(this.mThreeDSecureAuthenticationId);
    }

    private ThreeDSecureInfo(Parcel in) {
        this.mCavv = in.readString();
        this.mDsTransactionId = in.readString();
        this.mEciFlag = in.readString();
        this.mEnrolled = in.readString();
        this.mLiabilityShifted = in.readByte() != 0;
        this.mLiabilityShiftPossible = in.readByte() != 0;
        this.mStatus = in.readString();
        this.mThreeDSecureVersion = in.readString();
        this.mWasVerified = in.readByte() != 0;
        this.mXid = in.readString();
        this.mAuthenticationTransactionStatus = in.readString();
        this.mAuthenticationTransactionStatusReason = in.readString();
        this.mLookupTransactionStatus = in.readString();
        this.mLookupTransactionStatusReason = in.readString();
        this.mThreeDSecureAuthenticationId = in.readString();
    }
}

